/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.parser;

import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.suse.salt.netapi.datatypes.Arguments;
import com.suse.salt.netapi.parser.JsonParser;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class ArgumentsAdapter
extends TypeAdapter<Arguments> {
    private static final String KWARG_KEY = "__kwarg__";

    public void write(JsonWriter jsonWriter, Arguments args) throws IOException {
        throw new UnsupportedOperationException("Writing JSON not supported.");
    }

    public Arguments read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            throw new JsonParseException("null is not a valid value for Arguments");
        }
        Arguments result = new Arguments();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            if (jsonReader.peek() == JsonToken.BEGIN_OBJECT) {
                Map<String, Object> arg = this.readObjectArgument(jsonReader);
                if (this.isKwarg(arg)) {
                    arg.remove(KWARG_KEY);
                    result.getKwargs().putAll(arg);
                    continue;
                }
                result.getArgs().add(arg);
                continue;
            }
            result.getArgs().add(JsonParser.GSON.fromJson(jsonReader, Object.class));
        }
        jsonReader.endArray();
        return result;
    }

    private Map<String, Object> readObjectArgument(JsonReader jsonReader) throws IOException {
        LinkedHashMap<String, Object> arg = new LinkedHashMap<String, Object>();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            arg.put(jsonReader.nextName(), JsonParser.GSON.fromJson(jsonReader, Object.class));
        }
        jsonReader.endObject();
        return arg;
    }

    private boolean isKwarg(Map<String, Object> arg) {
        Object kwarg = arg.get(KWARG_KEY);
        return kwarg != null && kwarg instanceof Boolean && (Boolean)kwarg != false;
    }
}

