/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls.modules;

import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.calls.LocalCall;
import com.suse.salt.netapi.parser.JsonParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SaltUtil {
    public static LocalCall<List<String>> syncBeacons(Optional<Boolean> refresh, Optional<String> saltenv) {
        LinkedHashMap<String, Object> args = SaltUtil.syncArgs(refresh, saltenv);
        return new LocalCall<List<String>>("saltutil.sync_beacons", Optional.empty(), Optional.of(args), new TypeToken<List<String>>(){});
    }

    public static LocalCall<List<String>> syncGrains(Optional<Boolean> refresh, Optional<String> saltenv) {
        LinkedHashMap<String, Object> args = SaltUtil.syncArgs(refresh, saltenv);
        return new LocalCall<List<String>>("saltutil.sync_grains", Optional.empty(), Optional.of(args), new TypeToken<List<String>>(){});
    }

    public static LocalCall<List<String>> syncModules(Optional<Boolean> refresh, Optional<String> saltenv) {
        LinkedHashMap<String, Object> args = SaltUtil.syncArgs(refresh, saltenv);
        return new LocalCall<List<String>>("saltutil.sync_modules", Optional.empty(), Optional.of(args), new TypeToken<List<String>>(){});
    }

    public static LocalCall<Map<String, Object>> syncAll(Optional<Boolean> refresh, Optional<String> saltenv) {
        LinkedHashMap<String, Object> args = SaltUtil.syncArgs(refresh, saltenv);
        return new LocalCall<Map<String, Object>>("saltutil.sync_all", Optional.empty(), Optional.of(args), new TypeToken<Map<String, Object>>(){});
    }

    public static LocalCall<Boolean> refreshPillar(Optional<Boolean> refresh, Optional<String> saltenv) {
        LinkedHashMap<String, Object> args = SaltUtil.syncArgs(refresh, saltenv);
        return new LocalCall<Boolean>("saltutil.refresh_pillar", Optional.empty(), Optional.of(args), new TypeToken<Boolean>(){});
    }

    private static LinkedHashMap<String, Object> syncArgs(Optional<Boolean> refresh, Optional<String> saltenv) {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        refresh.ifPresent(value -> args.put("refresh", value));
        saltenv.ifPresent(value -> args.put("saltenv", value));
        return args;
    }

    public static LocalCall<List<RunningInfo>> running() {
        return new LocalCall<List<RunningInfo>>("saltutil.running", Optional.empty(), Optional.empty(), new TypeToken<List<RunningInfo>>(){});
    }

    public static class RunningInfo {
        private String jid;
        private String fun;
        private int pid;
        private String target;
        @SerializedName(value="tgt_type")
        private String targetType;
        private String user;
        private Optional<JsonElement> metadata = Optional.empty();

        public <R> Optional<R> getMetadata(Class<R> type) {
            return this.metadata.map(json -> JsonParser.GSON.fromJson(json, type));
        }

        public <R> Optional<R> getMetadata(TypeToken<R> type) {
            return this.metadata.map(json -> JsonParser.GSON.fromJson(json, type.getType()));
        }

        public String getJid() {
            return this.jid;
        }

        public String getFun() {
            return this.fun;
        }

        public int getPid() {
            return this.pid;
        }

        public String getTarget() {
            return this.target;
        }

        public String getTargetType() {
            return this.targetType;
        }

        public String getUser() {
            return this.user;
        }
    }
}

