/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.datatypes;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SaltVersion
implements Comparable<SaltVersion> {
    private static Pattern SALT_VERSION_REGEX = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)([Rr][Cc](\\d+))?$");
    private final int year;
    private final int month;
    private final int bugfix;
    private final Optional<Integer> releaseCandidate;

    public static Optional<SaltVersion> parse(String versionString) {
        Matcher matcher = SALT_VERSION_REGEX.matcher(versionString);
        if (matcher.matches()) {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(2));
            int bugfix = Integer.parseInt(matcher.group(3));
            Optional<Integer> rc = Optional.ofNullable(matcher.group(5)).map(Integer::parseInt);
            return Optional.of(new SaltVersion(year, month, bugfix, rc));
        }
        return Optional.empty();
    }

    public SaltVersion(int year, int month, int bugfix, Optional<Integer> releaseCandidate) {
        this.year = year;
        this.month = month;
        this.bugfix = bugfix;
        this.releaseCandidate = releaseCandidate;
    }

    public SaltVersion(int year, int month, int bugfix, int releaseCandidate) {
        this(year, month, bugfix, Optional.of(releaseCandidate));
    }

    public SaltVersion(int year, int month, int bugfix) {
        this(year, month, bugfix, Optional.empty());
    }

    public Optional<Integer> getReleaseCandidate() {
        return this.releaseCandidate;
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getBugfix() {
        return this.bugfix;
    }

    public String toString() {
        return this.getYear() + "." + this.getMonth() + "." + this.getBugfix() + this.getReleaseCandidate().map(rc -> "rc" + rc).orElse("");
    }

    @Override
    public int compareTo(SaltVersion other) {
        if (this == other) {
            return 0;
        }
        if (this.getYear() > other.getYear()) {
            return 1;
        }
        if (this.getYear() < other.getYear()) {
            return -1;
        }
        if (this.getMonth() > other.getMonth()) {
            return 1;
        }
        if (this.getMonth() < other.getMonth()) {
            return -1;
        }
        if (this.getBugfix() > other.getBugfix()) {
            return 1;
        }
        if (this.getBugfix() < other.getBugfix()) {
            return -1;
        }
        return this.getReleaseCandidate().map(lhsRc -> other.getReleaseCandidate().map(lhsRc::compareTo).orElse(-1)).orElseGet(() -> other.getReleaseCandidate().map(rhsRc -> 1).orElse(0));
    }
}

