/*
 * Decompiled with CFR 0.152.
 */
package com.suse.salt.netapi.calls;

import com.google.gson.reflect.TypeToken;
import com.suse.salt.netapi.AuthModule;
import com.suse.salt.netapi.calls.Call;
import com.suse.salt.netapi.calls.Client;
import com.suse.salt.netapi.calls.LocalAsyncResult;
import com.suse.salt.netapi.calls.RunnerAsyncResult;
import com.suse.salt.netapi.calls.RunnerCall;
import com.suse.salt.netapi.calls.SaltSSHConfig;
import com.suse.salt.netapi.calls.SaltSSHUtils;
import com.suse.salt.netapi.calls.runner.Jobs;
import com.suse.salt.netapi.client.SaltClient;
import com.suse.salt.netapi.datatypes.Batch;
import com.suse.salt.netapi.datatypes.Event;
import com.suse.salt.netapi.datatypes.target.SSHTarget;
import com.suse.salt.netapi.datatypes.target.Target;
import com.suse.salt.netapi.errors.GenericError;
import com.suse.salt.netapi.event.EventListener;
import com.suse.salt.netapi.event.EventStream;
import com.suse.salt.netapi.event.JobReturnEvent;
import com.suse.salt.netapi.event.RunnerReturnEvent;
import com.suse.salt.netapi.exception.SaltException;
import com.suse.salt.netapi.results.Result;
import com.suse.salt.netapi.results.Return;
import com.suse.salt.netapi.results.SSHResult;
import com.suse.salt.netapi.utils.ClientUtils;
import com.suse.salt.netapi.utils.FunctionE;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.websocket.CloseReason;

public class LocalCall<R>
implements Call<R> {
    private final String functionName;
    private final Optional<List<?>> arg;
    private final Optional<Map<String, ?>> kwarg;
    private final TypeToken<R> returnType;
    private final Optional<?> metadata;
    private final Optional<Integer> timeout;
    private final Optional<Integer> gatherJobTimeout;

    public LocalCall(String functionName, Optional<List<?>> arg, Optional<Map<String, ?>> kwarg, TypeToken<R> returnType, Optional<?> metadata, Optional<Integer> timeout, Optional<Integer> gatherJobTimeout) {
        this.functionName = functionName;
        this.arg = arg;
        this.kwarg = kwarg;
        this.returnType = returnType;
        this.metadata = metadata;
        this.timeout = timeout;
        this.gatherJobTimeout = gatherJobTimeout;
    }

    public LocalCall(String functionName, Optional<List<?>> arg, Optional<Map<String, ?>> kwarg, TypeToken<R> returnType, Optional<Integer> timeout, Optional<Integer> gatherJobTimeout) {
        this(functionName, arg, kwarg, returnType, Optional.empty(), timeout, gatherJobTimeout);
    }

    public LocalCall(String functionName, Optional<List<?>> arg, Optional<Map<String, ?>> kwarg, TypeToken<R> returnType, Optional<?> metadata) {
        this(functionName, arg, kwarg, returnType, metadata, Optional.empty(), Optional.empty());
    }

    public LocalCall(String functionName, Optional<List<?>> arg, Optional<Map<String, ?>> kwarg, TypeToken<R> returnType) {
        this(functionName, arg, kwarg, returnType, Optional.empty());
    }

    public LocalCall<R> withMetadata(Object metadata) {
        return new LocalCall<R>(this.functionName, this.arg, this.kwarg, this.returnType, Optional.of(metadata), this.timeout, this.gatherJobTimeout);
    }

    public LocalCall<R> withoutMetadata() {
        return new LocalCall<R>(this.functionName, this.arg, this.kwarg, this.returnType, Optional.empty(), this.timeout, this.gatherJobTimeout);
    }

    public LocalCall<R> withTimeouts(Optional<Integer> timeout, Optional<Integer> gatherJobTimeout) {
        return new LocalCall<R>(this.functionName, this.arg, this.kwarg, this.returnType, this.metadata, timeout, gatherJobTimeout);
    }

    public LocalCall<R> withoutTimeouts() {
        return new LocalCall<R>(this.functionName, this.arg, this.kwarg, this.returnType, this.metadata, Optional.empty(), Optional.empty());
    }

    public TypeToken<R> getReturnType() {
        return this.returnType;
    }

    @Override
    public Map<String, Object> getPayload() {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("fun", this.functionName);
        this.arg.ifPresent(arg -> payload.put("arg", arg));
        this.kwarg.ifPresent(kwarg -> payload.put("kwarg", kwarg));
        this.metadata.ifPresent(m -> payload.put("metadata", m));
        this.timeout.ifPresent(timeout -> payload.put("timeout", timeout));
        this.gatherJobTimeout.ifPresent(gatherJobTimeout -> payload.put("gather_job_timeout", gatherJobTimeout));
        return payload;
    }

    public LocalAsyncResult<R> callAsync(SaltClient client, Target<?> target) throws SaltException {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.putAll(this.getPayload());
        customArgs.put("tgt", target.getTarget());
        customArgs.put("expr_form", target.getType());
        Return wrapper = (Return)client.call(this, Client.LOCAL_ASYNC, "/", Optional.of(customArgs), new TypeToken<Return<List<LocalAsyncResult<R>>>>(){});
        LocalAsyncResult result = (LocalAsyncResult)((List)wrapper.getResult()).get(0);
        result.setType(this.getReturnType());
        return result;
    }

    public Map<String, CompletionStage<Result<R>>> callAsync(SaltClient client, Target<?> target, String username, String password, AuthModule authModule, EventStream events, CompletionStage<GenericError> cancel) throws SaltException {
        return this.callAsync((LocalCall<R> localCall) -> localCall.callAsync(client, target, username, password, authModule), (RunnerCall<Map<String, R>> runnerCall) -> runnerCall.callAsync(client, username, password, authModule), events, cancel);
    }

    public Map<String, CompletionStage<Result<R>>> callAsync(SaltClient client, Target<?> target, EventStream events, CompletionStage<GenericError> cancel) throws SaltException {
        return this.callAsync((LocalCall<R> localCall) -> localCall.callAsync(client, target), (RunnerCall<Map<String, R>> runnerCall) -> runnerCall.callAsync(client), events, cancel);
    }

    public Map<String, CompletionStage<Result<R>>> callAsync(FunctionE<LocalCall<R>, LocalAsyncResult<R>> localAsync, FunctionE<RunnerCall<Map<String, R>>, RunnerAsyncResult<Map<String, R>>> runnerAsync, EventStream events, CompletionStage<GenericError> cancel) throws SaltException {
        final LocalAsyncResult<R> lar = localAsync.apply(this);
        TypeToken<R> returnTypeToken = this.getReturnType();
        ParameterizedType result = ClientUtils.parameterizedType(null, Result.class, new Type[]{returnTypeToken.getType()});
        final TypeToken typeToken = TypeToken.get((Type)result);
        final Map<String, CompletableFuture> futures = lar.getMinions().stream().collect(Collectors.toMap(mid -> mid, mid -> new CompletableFuture()));
        EventListener listener = new EventListener(){

            @Override
            public void notify(Event event) {
                Optional<JobReturnEvent> jobReturnEvent = JobReturnEvent.parse(event);
                if (jobReturnEvent.isPresent()) {
                    jobReturnEvent.ifPresent(e -> LocalCall.onJobReturn(lar.getJid(), e, typeToken, futures));
                } else {
                    RunnerReturnEvent.parse(event).ifPresent(e -> LocalCall.onRunnerReturn(lar.getJid(), e, typeToken, futures));
                }
            }

            @Override
            public void eventStreamClosed(CloseReason closeReason) {
                Result error = Result.error(new GenericError("EventStream closed with reason " + closeReason));
                futures.values().forEach(f -> f.complete(error));
            }
        };
        CompletableFuture<Void> allResolves = CompletableFuture.allOf((CompletableFuture[])futures.entrySet().stream().map(entry -> ((CompletableFuture)entry.getValue()).handle((v, e) -> 0)).toArray(CompletableFuture[]::new));
        allResolves.whenComplete((v, e) -> events.removeEventListener(listener));
        cancel.whenComplete((v, e) -> {
            if (v != null) {
                Result error = Result.error(v);
                futures.values().forEach(f -> f.complete(error));
            } else if (e != null) {
                futures.values().forEach(f -> f.completeExceptionally((Throwable)e));
            }
        });
        events.addEventListener(listener);
        runnerAsync.apply(Jobs.lookupJid(lar));
        return futures.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (CompletionStage)e.getValue()));
    }

    public LocalAsyncResult<R> callAsync(SaltClient client, Target<?> target, String username, String password, AuthModule authModule) throws SaltException {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.putAll(this.getPayload());
        customArgs.put("username", username);
        customArgs.put("password", password);
        customArgs.put("eauth", authModule.getValue());
        customArgs.put("tgt", target.getTarget());
        customArgs.put("expr_form", target.getType());
        Return wrapper = (Return)client.call(this, Client.LOCAL_ASYNC, "/run", Optional.of(customArgs), new TypeToken<Return<List<LocalAsyncResult<R>>>>(){});
        LocalAsyncResult result = (LocalAsyncResult)((List)wrapper.getResult()).get(0);
        result.setType(this.getReturnType());
        return result;
    }

    public Map<String, Result<R>> callSync(SaltClient client, Target<?> target) throws SaltException {
        return this.callSyncHelper(client, target, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()).get(0);
    }

    public List<Map<String, Result<R>>> callSync(SaltClient client, Target<?> target, Batch batch) throws SaltException {
        return this.callSyncHelper(client, target, Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(batch));
    }

    public Map<String, Result<R>> callSync(SaltClient client, Target<?> target, String username, String password, AuthModule authModule) throws SaltException {
        return this.callSyncHelper(client, target, Optional.of(username), Optional.of(password), Optional.of(authModule), Optional.empty()).get(0);
    }

    public List<Map<String, Result<R>>> callSync(SaltClient client, Target<?> target, String username, String password, AuthModule authModule, Batch batch) throws SaltException {
        return this.callSyncHelper(client, target, Optional.of(username), Optional.of(password), Optional.of(authModule), Optional.of(batch));
    }

    private List<Map<String, Result<R>>> callSyncHelper(SaltClient client, Target<?> target, Optional<String> username, Optional<String> password, Optional<AuthModule> authModule, Optional<Batch> batch) throws SaltException {
        HashMap<String, Object> customArgs = new HashMap<String, Object>();
        customArgs.putAll(this.getPayload());
        customArgs.put("tgt", target.getTarget());
        customArgs.put("expr_form", target.getType());
        username.ifPresent(v -> customArgs.put("username", v));
        password.ifPresent(v -> customArgs.put("password", v));
        authModule.ifPresent(v -> customArgs.put("eauth", v.getValue()));
        batch.ifPresent(v -> customArgs.put("batch", v.toString()));
        Client clientType = batch.isPresent() ? Client.LOCAL_BATCH : Client.LOCAL;
        String endPoint = username.isPresent() ? "/run" : "/";
        ParameterizedType xor = ClientUtils.parameterizedType(null, Result.class, new Type[]{this.getReturnType().getType()});
        ParameterizedType map = ClientUtils.parameterizedType(null, Map.class, new Type[]{String.class, xor});
        ParameterizedType listType = ClientUtils.parameterizedType(null, List.class, new Type[]{map});
        ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Return.class, new Type[]{listType});
        Return wrapper = (Return)client.call(this, clientType, endPoint, Optional.of(customArgs), TypeToken.get((Type)wrapperType));
        return (List)wrapper.getResult();
    }

    public Map<String, Result<SSHResult<R>>> callSyncSSH(SaltClient client, SSHTarget<?> target, SaltSSHConfig cfg) throws SaltException {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.putAll(this.getPayload());
        args.put("tgt", target.getTarget());
        args.put("expr_form", target.getType());
        SaltSSHUtils.mapConfigPropsToArgs(cfg, args);
        ParameterizedType xor = ClientUtils.parameterizedType(null, Result.class, new Type[]{ClientUtils.parameterizedType(null, SSHResult.class, new Type[]{this.getReturnType().getType()})});
        ParameterizedType map = ClientUtils.parameterizedType(null, Map.class, new Type[]{String.class, xor});
        ParameterizedType listType = ClientUtils.parameterizedType(null, List.class, new Type[]{map});
        ParameterizedType wrapperType = ClientUtils.parameterizedType(null, Return.class, new Type[]{listType});
        Return wrapper = (Return)client.call(this, Client.SSH, "/run", Optional.of(args), TypeToken.get((Type)wrapperType));
        return (Map)((List)wrapper.getResult()).get(0);
    }

    private static <R> void onRunnerReturn(String jid, RunnerReturnEvent rre, TypeToken<Result<R>> tt, Map<String, CompletableFuture<Result<R>>> targets) {
        Jobs.Info result;
        RunnerReturnEvent.Data data = rre.getData();
        if (data.getFun().contentEquals("runner.jobs.list_job") && (result = data.getResult(Jobs.Info.class)).getJid().equals(jid)) {
            targets.forEach((mid, f) -> result.getResult((String)mid, tt).ifPresent(f::complete));
        }
    }

    private static <R> void onJobReturn(String jid, JobReturnEvent jre, TypeToken<Result<R>> tt, Map<String, CompletableFuture<Result<R>>> targets) {
        CompletableFuture<Result<R>> f;
        if (jre.getJobId().contentEquals(jid) && (f = targets.get(jre.getMinionId())) != null) {
            f.complete(jre.getData().getResult(tt));
        }
    }
}

