package com.surveymonkey.surveymonkeyandroidsdk.utils

import android.app.Activity
import android.content.Intent
import android.net.Uri
import android.os.Environment
import android.provider.MediaStore
import androidx.core.content.FileProvider
import com.surveymonkey.surveymonkeyandroidsdk.R
import java.io.File
import java.io.IOException
import java.util.Calendar

internal class ImageFetcher {
    private var mImageFileName: String? = null
    private var mImageFilePath: String? = null
    private var imageUri: Uri? = null

    fun openCamera(activity: Activity): Uri? {
        reset()
        val intent = Intent(MediaStore.ACTION_IMAGE_CAPTURE)
        if (intent.resolveActivity(activity.packageManager) == null) {
            // Ensure that there's a camera activity to handle the intent
            return null
        }
        // Create the File where the photo should go
        try {
            val now = Calendar.getInstance().timeInMillis
            val fileName = now.toString()
            val storageDir =
                Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_PICTURES)
            val imageFile = File.createTempFile(
                fileName,  /* prefix */
                ".jpg",  /* suffix */
                storageDir /* directory */
            )
            mImageFileName = imageFile.name
            mImageFilePath = imageFile.absolutePath
            imageUri = FileProvider.getUriForFile(
                activity,
                activity.getString(R.string.photo_path),
                imageFile)
        } catch (ex: IOException) {
            reset()
        }

        return imageUri
    }

    private fun reset() {
        mImageFilePath = null
        mImageFileName = null
    }
}