package com.surveymonkey.surveymonkeyandroidsdk

import android.content.DialogInterface
import android.os.Bundle
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.DialogFragment
import com.surveymonkey.surveymonkeyandroidsdk.databinding.FragmentMediaSourceBinding
import com.surveymonkey.surveymonkeyandroidsdk.listener.MediaSelectionListener
internal class MediaSourceDialogFragment: DialogFragment(), View.OnClickListener {
    private lateinit var mBinding: FragmentMediaSourceBinding
    private lateinit var mMediaSelectionListener: MediaSelectionListener

    companion object {
        @JvmStatic
        fun newInstance(listener: MediaSelectionListener): MediaSourceDialogFragment {
            val fragment = MediaSourceDialogFragment()
            fragment.apply {
                this.mMediaSelectionListener = listener
            }
            return fragment
        }
    }


    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        mBinding = FragmentMediaSourceBinding.inflate(inflater)
        mBinding.selectCamera.setOnClickListener(this)
        mBinding.selectFromPhone.setOnClickListener(this)
        this.isCancelable = false
        return mBinding.root
    }

    override fun onClick(v: View) {
        when(v.id) {
            R.id.select_camera -> {
                Log.d("Camera selected","Camera selected")
                mMediaSelectionListener.onMediaOptionSelected(1)
                dismiss()

            }
            R.id.select_from_phone -> {
                Log.d("Phone selected","Phone selected")
                mMediaSelectionListener.onMediaOptionSelected(2)
                dismiss()
            }
        }
    }
}