package com.surveymonkey.surveymonkeyandroidsdk.utils

import android.content.Context
import android.net.ConnectivityManager
import android.net.NetworkCapabilities
import android.net.Uri
import android.os.Build
import android.text.TextUtils
import com.surveymonkey.surveymonkeyandroidsdk.BuildConfig
import org.json.JSONException
import org.json.JSONObject

 object SMNetworkUtils {
    @JvmStatic
    fun buildURL(collectorHash: String, customVariables: JSONObject?): String {
        var url = BuildConfig.SURVEY_BASE_URL + collectorHash
        if (customVariables != null) {
            url += jSONToQueryString(customVariables)
        }
        return url
    }

    private fun jSONToQueryString(jsonObject: JSONObject): String {
        var queryString = "?"
        val params = ArrayList<String?>()
        val keys = jsonObject.keys()
        while (keys.hasNext()) {
            try {
                val key = keys.next()
                if (jsonObject[key] is String) {
                    params.add(
                        String.format(
                            "%1\$s=%2\$s",
                            key,
                            Uri.encode(jsonObject.getString(key))
                        )
                    )
                }
            } catch (e: JSONException) {
                e.printStackTrace()
            }
        }
        queryString += TextUtils.join("&", params)
        return queryString
    }

    @JvmStatic
    internal fun getConnectivityType(context: Context): String {
        var connectivity = ConnectivityType.NO_CONNECTION
        val connectivityManager = context.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            try {
                connectivityManager.getNetworkCapabilities(connectivityManager.activeNetwork)
                    ?.let { cap ->
                        connectivity = when {
                            cap.hasTransport(NetworkCapabilities.TRANSPORT_WIFI) -> ConnectivityType.WIFI
                            cap.hasTransport(NetworkCapabilities.TRANSPORT_CELLULAR) -> ConnectivityType.CELLULAR
                            cap.hasTransport(NetworkCapabilities.TRANSPORT_ETHERNET) -> ConnectivityType.ETHERNET
                            else -> ConnectivityType.NO_CONNECTION
                        }
                    }
            } catch (e: SecurityException) {
                // Before it was fixed on Android 12 calling getNetworkCapabilities  could
                // trigger a SecurityException with message "package does not belong to 10411"
            }
        } else {
            connectivityManager.activeNetworkInfo?.let { network ->
                connectivity = when (network.type) {
                    ConnectivityManager.TYPE_WIFI -> ConnectivityType.WIFI
                    ConnectivityManager.TYPE_MOBILE -> ConnectivityType.CELLULAR
                    ConnectivityManager.TYPE_ETHERNET -> ConnectivityType.ETHERNET
                    else -> ConnectivityType.NO_CONNECTION
                }
            }
        }
        return connectivity.value
    }

    internal enum class ConnectivityType(val value: String) {
        NO_CONNECTION("No connection"),
        WIFI("WiFi"),
        CELLULAR("Cellular"),
        ETHERNET("Ethernet")
    }
}