package com.surveymonkey.surveymonkeyandroidsdk.repository

import com.surveymonkey.surveymonkeyandroidsdk.network.SMNetworkService
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMConstants.MASHERY_API_KEY
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMConstants.RESPONDENT_TOKEN
import com.surveymonkey.surveymonkeyandroidsdk.network.RetrofitHelper
import org.json.JSONException
import org.json.JSONObject

internal class SurveyRepositoryImpl() :
    SurveyRepository {
    private val EMBED_DATA = "embed_data"
    override suspend fun getResponse(surveyHash: String): JSONObject? {
        return getRetroService().getResponse(surveyHash)?.let { parseResponse(it) }
    }

    override suspend fun getResponseByToken(token: String): JSONObject {
        val response = getRetroService().getResponseByToken(token)?.let { JSONObject(it) }
        val returnJSON = JSONObject()
        returnJSON.put(RESPONDENT_TOKEN, response?.get (RESPONDENT_TOKEN))
        returnJSON.put(MASHERY_API_KEY, response?.get(MASHERY_API_KEY))
        return returnJSON
    }

    @Throws(JSONException::class)
    private fun parseResponse(response: String): JSONObject {
        val data = JSONObject()
        val dataLocation = response.indexOf("id=\"$EMBED_DATA")
        if (dataLocation != -1) {
            val dataLength = ("id=\"$EMBED_DATA").length
            val position = dataLength + dataLocation
            val restOfString = response.substring(position)
            val startBracePosition = restOfString.indexOf("'{")
            val endBracePosition = restOfString.indexOf("}'")
            val quoteLength = 1
            val dataString = restOfString.substring(
                startBracePosition + quoteLength,
                endBracePosition + quoteLength
            )
            val surveyStatus = JSONObject(dataString)
            data.put("survey_status", surveyStatus)
            data.put("html", response)
        }
        return data
    }

    private fun getRetroService(): SMNetworkService {
        return RetrofitHelper.getRetrofitInstance().create(SMNetworkService::class.java)
    }
}

