/*
 * Decompiled with CFR 0.152.
 */
package com.surveymonkey.surveymonkeyandroidsdk;

import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.surveymonkey.surveymonkeyandroidsdk.R;
import com.surveymonkey.surveymonkeyandroidsdk.SMFeedbackFragmentListener;
import com.surveymonkey.surveymonkeyandroidsdk.loaders.GetRespondentTaskLoader;
import com.surveymonkey.surveymonkeyandroidsdk.loaders.GetRespondentTokenTaskLoader;
import com.surveymonkey.surveymonkeyandroidsdk.loaders.RetrieveSPageTask;
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMError;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.JSONException;
import org.json.JSONObject;

public class SMFeedbackFragment
extends Fragment {
    public static final String TAG = SMFeedbackFragment.class.getSimpleName();
    private static final int RESPONDENT_TOKEN_LOADER_KEY = 1;
    private static final int RESPONDENT_LOADER_KEY = 2;
    public static final String KEY_SM_SPAGE_URL = "smSPageURL";
    public static final String KEY_SM_SPAGE_HTML = "smSPageHTML";
    public static final String KEY_SM_HAS_LOADED_SPAGE_HTML = "smHasLoadedSPageHTML";
    private static final String SURVEY_STATUS = "survey_status";
    private static final String HTML = "html";
    private static final String COLLECTOR_CLOSED = "collector_closed";
    private WebView mWebView;
    private String mSPageHTML;
    private boolean mHasPreLoadedHTML;
    private boolean mHasLoadedSPageWebView;
    private String mURL;
    private SMError mError;
    private String mTokenURL;
    private String mToken;
    private String mMasheryApiKey;
    private ProgressDialog mProgressDialog;
    private ConnectivityMonitor connectivityMonitor;

    public static SMFeedbackFragment newInstance(String url, String spageHTML, boolean hasLoadedHTML) {
        SMFeedbackFragment fragment = new SMFeedbackFragment();
        Bundle bundle = new Bundle();
        bundle.putString(KEY_SM_SPAGE_URL, url);
        bundle.putString(KEY_SM_SPAGE_HTML, spageHTML);
        bundle.putBoolean(KEY_SM_HAS_LOADED_SPAGE_HTML, hasLoadedHTML);
        fragment.setArguments(bundle);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mHasPreLoadedHTML = false;
        this.mHasLoadedSPageWebView = false;
        this.mSPageHTML = null;
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mURL = bundle.getString(KEY_SM_SPAGE_URL);
            this.mHasPreLoadedHTML = bundle.getBoolean(KEY_SM_HAS_LOADED_SPAGE_HTML);
            if (this.mHasPreLoadedHTML) {
                this.mSPageHTML = bundle.getString(KEY_SM_SPAGE_HTML);
                this.loadSurveyPage();
            } else {
                RetrieveSPageTask sPageTask = new RetrieveSPageTask(){

                    protected void onPostExecute(JSONObject data) {
                        try {
                            if (data != null) {
                                JSONObject sdkData = data.getJSONObject(SMFeedbackFragment.SURVEY_STATUS);
                                SMFeedbackFragment.this.mSPageHTML = data.getString(SMFeedbackFragment.HTML);
                                if (!sdkData.getBoolean(SMFeedbackFragment.COLLECTOR_CLOSED)) {
                                    SMFeedbackFragment.this.loadSurveyPage();
                                } else {
                                    SMFeedbackFragment.this.handleCollectorClosed();
                                }
                            } else {
                                SMFeedbackFragment.this.handleCollectorClosed();
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                };
                sPageTask.execute(new String[]{this.mURL});
            }
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_smfeedback, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.connectivityMonitor = new ConnectivityMonitor();
        this.getActivity().registerReceiver((BroadcastReceiver)this.connectivityMonitor, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        Thread.setDefaultUncaughtExceptionHandler(new SMExceptionHandler(this));
        if (!this.mHasLoadedSPageWebView && this.mSPageHTML != null) {
            this.loadSurveyPage();
        }
    }

    public void onDestroy() {
        this.getActivity().unregisterReceiver((BroadcastReceiver)this.connectivityMonitor);
        super.onDestroy();
    }

    private void loadSurveyPage() {
        if (this.getView() != null) {
            this.mProgressDialog = ProgressDialog.show((Context)this.getActivity(), null, (CharSequence)this.getString(R.string.sm_loading_status));
            this.mHasLoadedSPageWebView = true;
            this.mWebView = (WebView)this.getView().findViewById(R.id.sm_feedback_webview);
            this.mWebView.getSettings().setJavaScriptEnabled(true);
            this.mWebView.setWebViewClient((WebViewClient)new SMWebviewClient());
            this.mWebView.loadDataWithBaseURL(this.mURL, this.mSPageHTML, null, "UTF-8", null);
        }
    }

    private void handleCollectorClosed() {
        this.mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_COLLECTOR_CLOSED, null);
        Log.d((String)"SM_SDK_DEBUG", (String)this.mError.getDescription());
        this.handleError(this.mError);
    }

    public Loader<JSONObject> onCreateRespondentTokenTaskLoader(int id2, Bundle args) {
        return new GetRespondentTokenTaskLoader((Context)this.getActivity(), this.mTokenURL);
    }

    public Loader<JSONObject> onCreateRespondentTaskLoader(int id2, Bundle args) {
        return new GetRespondentTaskLoader((Context)this.getActivity(), this.mToken, this.mMasheryApiKey);
    }

    public void onGetRespondentTokenTaskLoadFinished(Loader<JSONObject> loader, JSONObject data) {
        if (data != null) {
            try {
                this.mToken = data.getString("respondent_token");
                this.mMasheryApiKey = data.getString("mashery_api_key");
                GetRespondentTaskLoader respondentTaskLoader = (GetRespondentTaskLoader)this.getActivity().getSupportLoaderManager().getLoader(2);
                if (respondentTaskLoader != null) {
                    this.getActivity().getSupportLoaderManager().initLoader(2, null, (LoaderManager.LoaderCallbacks)new LoaderManager.LoaderCallbacks<JSONObject>(){

                        public Loader<JSONObject> onCreateLoader(int id2, Bundle args) {
                            return SMFeedbackFragment.this.onCreateRespondentTaskLoader(id2, args);
                        }

                        public void onLoadFinished(Loader<JSONObject> loader, JSONObject data) {
                            SMFeedbackFragment.this.onGetRespondentTaskLoadFinished(loader, data);
                        }

                        public void onLoaderReset(Loader<JSONObject> loader) {
                        }
                    });
                }
                this.getActivity().getSupportLoaderManager().restartLoader(2, null, (LoaderManager.LoaderCallbacks)new LoaderManager.LoaderCallbacks<JSONObject>(){

                    public Loader<JSONObject> onCreateLoader(int id2, Bundle args) {
                        return SMFeedbackFragment.this.onCreateRespondentTaskLoader(id2, args);
                    }

                    public void onLoadFinished(Loader<JSONObject> loader, JSONObject data) {
                        SMFeedbackFragment.this.onGetRespondentTaskLoadFinished(loader, data);
                    }

                    public void onLoaderReset(Loader<JSONObject> loader) {
                    }
                });
            }
            catch (JSONException e) {
                this.mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_TOKEN, (Exception)((Object)e));
                Log.d((String)"SM_SDK_DEBUG", (String)this.mError.getDescription());
                throw this.mError;
            }
        }
    }

    public void onGetRespondentTaskLoadFinished(Loader<JSONObject> loader, JSONObject data) {
        if (data != null) {
            try {
                JSONObject result = data.getJSONObject("data");
                this.handleRespondent(result);
            }
            catch (JSONException e) {
                this.mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_RETRIEVING_RESPONSE, (Exception)((Object)e));
                Log.d((String)"SM_SDK_DEBUG", (String)this.mError.getDescription());
                throw this.mError;
            }
        }
    }

    private void handleRespondent(JSONObject r) {
        try {
            ((SMFeedbackFragmentListener)this.getActivity()).onFetchRespondentSuccess(r);
        }
        catch (ClassCastException cce) {
            Log.d((String)"SM_SDK_DEBUG", (String)"SMFeedbackFragmentListener has not been implemented");
            this.showEndOfSurveyOverlay();
        }
    }

    private void handleError(SMError e) {
        try {
            ((SMFeedbackFragmentListener)this.getActivity()).onFetchRespondentFailure(e);
        }
        catch (ClassCastException cce) {
            Log.d((String)"SM_SDK_DEBUG", (String)"SMFeedbackFragmentListener has not been implemented");
            if (e.getErrorCode() == SMError.ErrorType.ERROR_CODE_COLLECTOR_CLOSED.getValue()) {
                this.showSurveyClosedOverlay();
            }
            this.showEndOfSurveyOverlay();
        }
    }

    private void showEndOfSurveyOverlay() {
        this.getView().findViewById(R.id.sm_feedback_survey_ended).setVisibility(0);
        this.getView().findViewById(R.id.sm_feedback_webview).setVisibility(8);
    }

    private void showSurveyClosedOverlay() {
        this.getView().findViewById(R.id.sm_feedback_survey_closed).setVisibility(0);
        this.getView().findViewById(R.id.sm_feedback_webview).setVisibility(8);
    }

    private void getToken() {
        GetRespondentTokenTaskLoader loader = (GetRespondentTokenTaskLoader)this.getActivity().getSupportLoaderManager().getLoader(2);
        if (loader != null) {
            this.getActivity().getSupportLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)new LoaderManager.LoaderCallbacks<JSONObject>(){

                public Loader<JSONObject> onCreateLoader(int id2, Bundle args) {
                    return SMFeedbackFragment.this.onCreateRespondentTokenTaskLoader(id2, args);
                }

                public void onLoadFinished(Loader<JSONObject> loader, JSONObject data) {
                    SMFeedbackFragment.this.onGetRespondentTokenTaskLoadFinished(loader, data);
                }

                public void onLoaderReset(Loader<JSONObject> loader) {
                }
            });
        }
        this.getActivity().getSupportLoaderManager().restartLoader(1, null, (LoaderManager.LoaderCallbacks)new LoaderManager.LoaderCallbacks<JSONObject>(){

            public Loader<JSONObject> onCreateLoader(int id2, Bundle args) {
                return SMFeedbackFragment.this.onCreateRespondentTokenTaskLoader(id2, args);
            }

            public void onLoadFinished(Loader<JSONObject> loader, JSONObject data) {
                SMFeedbackFragment.this.onGetRespondentTokenTaskLoadFinished(loader, data);
            }

            public void onLoaderReset(Loader<JSONObject> loader) {
            }
        });
    }

    public static class ConnectivityMonitor
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            if (!this.isNetworkConnected(context)) {
                ((FragmentActivity)context).getSupportFragmentManager().findFragmentByTag(TAG).getView().findViewById(R.id.sm_feedback_no_network).setVisibility(0);
                ((FragmentActivity)context).getSupportFragmentManager().findFragmentByTag(TAG).getView().findViewById(R.id.sm_feedback_webview).setVisibility(8);
            } else {
                ((FragmentActivity)context).getSupportFragmentManager().findFragmentByTag(TAG).getView().findViewById(R.id.sm_feedback_no_network).setVisibility(8);
                ((FragmentActivity)context).getSupportFragmentManager().findFragmentByTag(TAG).getView().findViewById(R.id.sm_feedback_webview).setVisibility(0);
            }
        }

        public boolean isNetworkConnected(Context context) {
            ConnectivityManager manager = (ConnectivityManager)((FragmentActivity)context).getSupportFragmentManager().findFragmentByTag(TAG).getActivity().getApplication().getSystemService("connectivity");
            NetworkInfo activeNetInfo = manager.getActiveNetworkInfo();
            return activeNetInfo != null && activeNetInfo.isConnected();
        }
    }

    protected class SMExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        public SMExceptionHandler(Fragment context) {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable exception) {
            SMError cause = (SMError)exception.getCause();
            SMFeedbackFragment.this.handleError(cause);
        }
    }

    private class SMWebviewClient
    extends WebViewClient {
        private SMWebviewClient() {
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            URL resourceURL = null;
            try {
                resourceURL = new URL(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (resourceURL.getPath().startsWith("/r/embed/sdk_token")) {
                view.stopLoading();
                SMFeedbackFragment.this.mTokenURL = url;
                SMFeedbackFragment.this.getToken();
            } else {
                super.onPageStarted(view, url, favicon);
            }
        }

        public void onPageFinished(WebView view, String url) {
            URL resourceURL = null;
            try {
                resourceURL = new URL(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (resourceURL.getPath().startsWith("/r/")) {
                SMFeedbackFragment.this.mProgressDialog.dismiss();
            }
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (!url.contains("surveymonkey.com/r/")) {
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                SMFeedbackFragment.this.startActivity(browserIntent);
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }
    }
}

