/*
 * Decompiled with CFR 0.152.
 */
package com.surveymonkey.surveymonkeyandroidsdk;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import com.surveymonkey.surveymonkeyandroidsdk.SMFeedbackFragment;
import com.surveymonkey.surveymonkeyandroidsdk.SMFeedbackFragmentListener;
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMError;
import java.io.Serializable;
import org.json.JSONObject;

public class SMFeedbackActivity
extends FragmentActivity
implements SMFeedbackFragmentListener {
    public static final String KEY_SM_SPAGE_HTML = "smSPageHTML";
    public static final String KEY_SM_SPAGE_URL = "smSPageURL";
    public static final String KEY_SM_ERROR = "smError";
    public static final String KEY_SM_DESCRIPTION = "smDescription";
    public static final String SM_RESPONDENT = "smRespondent";
    public static final String SM_ERROR_CODE = "smErrorCode";
    private String mSPageHTML;
    private String mURL;
    private SMError mError;

    public static void startActivityForResult(Activity context, int requestCode, String url, String sPageHTML) {
        Intent intent = new Intent((Context)context, SMFeedbackActivity.class);
        if (sPageHTML != null) {
            intent.putExtra(KEY_SM_SPAGE_HTML, sPageHTML);
        }
        intent.putExtra(KEY_SM_SPAGE_URL, url);
        context.startActivityForResult(intent, requestCode);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Intent intent = this.getIntent();
        this.mSPageHTML = intent.getStringExtra(KEY_SM_SPAGE_HTML);
        if (this.mSPageHTML == null) {
            this.mError = SMError.sdkClientErrorFromCode(SMError.ErrorType.ERROR_CODE_COLLECTOR_CLOSED, null);
            Log.d((String)"SM_SDK_DEBUG", (String)this.mError.getDescription());
            this.onFetchRespondentFailure(this.mError);
        }
        this.mURL = intent.getStringExtra(KEY_SM_SPAGE_URL);
        if (savedInstanceState == null) {
            this.getSupportFragmentManager().beginTransaction().add(0x1020002, (Fragment)SMFeedbackFragment.newInstance(this.mURL, this.mSPageHTML, true), SMFeedbackFragment.TAG).commit();
        }
    }

    public void onBackPressed() {
        this.mError = SMError.sdkClientErrorFromCode(SMError.ErrorType.ERROR_CODE_USER_CANCELED, null);
        Log.d((String)"SM_SDK_DEBUG", (String)this.mError.getDescription());
        this.onFetchRespondentFailure(this.mError);
    }

    @Override
    public void onFetchRespondentSuccess(JSONObject respondent) {
        Intent intent = new Intent();
        intent.putExtra(SM_RESPONDENT, respondent.toString());
        this.setResult(-1, intent);
        this.finish();
    }

    @Override
    public void onFetchRespondentFailure(SMError e) {
        Intent intent = new Intent();
        intent.putExtra(KEY_SM_ERROR, (Serializable)e);
        if (e != null) {
            intent.putExtra(KEY_SM_DESCRIPTION, e.getDescription());
            intent.putExtra(SM_ERROR_CODE, e.getErrorCode());
        } else {
            intent.putExtra(KEY_SM_DESCRIPTION, "");
            intent.putExtra(SM_ERROR_CODE, -1);
        }
        this.setResult(0, intent);
        this.finish();
    }
}

