/*
 * Decompiled with CFR 0.152.
 */
package com.surveymonkey.surveymonkeyandroidsdk;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.util.Log;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.surveymonkey.surveymonkeyandroidsdk.R;
import com.surveymonkey.surveymonkeyandroidsdk.loaders.GetRespondentTaskLoader;
import com.surveymonkey.surveymonkeyandroidsdk.loaders.GetRespondentTokenTaskLoader;
import com.surveymonkey.surveymonkeyandroidsdk.utils.SMError;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.JSONException;
import org.json.JSONObject;

public class SMFeedbackActivity
extends FragmentActivity {
    private static final int RESPONDENT_TOKEN_LOADER_KEY = 1;
    private static final int RESPONDENT_LOADER_KEY = 2;
    public static final String KEY_SM_SPAGE_HTML = "smSPageHTML";
    public static final String KEY_SM_SPAGE_URL = "smSPageURL";
    public static final String KEY_SM_ERROR = "smError";
    public static final String KEY_SM_DESCRIPTION = "smDescription";
    public static final String SM_RESPONDENT = "smRespondent";
    public static final String SM_ERROR_CODE = "smErrorCode";
    private WebView mWebView;
    private String mSPageHTML;
    private String mURL;
    private SMError mError;
    private String mTokenURL;
    private String mToken;
    private String mMasheryApiKey;
    private ProgressDialog mProgressDialog;
    private ConnectivityMonitor connectivityMonitor;

    public static void startActivityForResult(Activity context, int requestCode, String url, String sPageHTML) {
        Intent intent = new Intent((Context)context, SMFeedbackActivity.class);
        if (sPageHTML != null) {
            intent.putExtra(KEY_SM_SPAGE_HTML, sPageHTML);
        }
        intent.putExtra(KEY_SM_SPAGE_URL, url);
        context.startActivityForResult(intent, requestCode);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.connectivityMonitor = new ConnectivityMonitor();
        this.registerReceiver(this.connectivityMonitor, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        Thread.setDefaultUncaughtExceptionHandler(new SMExceptionHandler((Activity)this));
        Intent intent = this.getIntent();
        this.mSPageHTML = intent.getStringExtra(KEY_SM_SPAGE_HTML);
        if (this.mSPageHTML == null) {
            this.mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_COLLECTOR_CLOSED, null);
            Log.d((String)"SM_SDK_DEBUG", (String)this.mError.getDescription());
            this.handleError(this.mError);
        }
        this.mProgressDialog = ProgressDialog.show((Context)this, null, (CharSequence)this.getString(R.string.loading_status));
        this.mURL = intent.getStringExtra(KEY_SM_SPAGE_URL);
        this.setContentView(R.layout.activity_smfeedback);
        this.mWebView = (WebView)this.findViewById(R.id.sm_feedback_webview);
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.setWebViewClient((WebViewClient)new SMWebviewClient());
        this.mWebView.loadDataWithBaseURL(this.mURL, this.mSPageHTML, null, "UTF-8", null);
    }

    protected void onDestroy() {
        this.unregisterReceiver(this.connectivityMonitor);
        super.onDestroy();
    }

    public void onBackPressed() {
        this.mError = SMError.sdkClientErrorFromCode(SMError.ErrorType.ERROR_CODE_USER_CANCELED, null);
        Log.d((String)"SM_SDK_DEBUG", (String)this.mError.getDescription());
        this.handleError(this.mError);
    }

    public Loader<JSONObject> onCreateRespondentTokenTaskLoader(int id2, Bundle args) {
        return new GetRespondentTokenTaskLoader((Context)this, this.mTokenURL);
    }

    public Loader<JSONObject> onCreateRespondentTaskLoader(int id2, Bundle args) {
        return new GetRespondentTaskLoader((Context)this, this.mToken, this.mMasheryApiKey);
    }

    public void onGetRespondentTokenTaskLoadFinished(Loader<JSONObject> loader, JSONObject data) {
        if (data != null) {
            try {
                this.mToken = data.getString("respondent_token");
                this.mMasheryApiKey = data.getString("mashery_api_key");
                GetRespondentTaskLoader respondentTaskLoader = (GetRespondentTaskLoader)this.getSupportLoaderManager().getLoader(2);
                if (respondentTaskLoader != null) {
                    this.getSupportLoaderManager().initLoader(2, null, (LoaderManager.LoaderCallbacks)new LoaderManager.LoaderCallbacks<JSONObject>(){

                        public Loader<JSONObject> onCreateLoader(int id2, Bundle args) {
                            return SMFeedbackActivity.this.onCreateRespondentTaskLoader(id2, args);
                        }

                        public void onLoadFinished(Loader<JSONObject> loader, JSONObject data) {
                            SMFeedbackActivity.this.onGetRespondentTaskLoadFinished(loader, data);
                        }

                        public void onLoaderReset(Loader<JSONObject> loader) {
                        }
                    });
                }
                this.getSupportLoaderManager().restartLoader(2, null, (LoaderManager.LoaderCallbacks)new LoaderManager.LoaderCallbacks<JSONObject>(){

                    public Loader<JSONObject> onCreateLoader(int id2, Bundle args) {
                        return SMFeedbackActivity.this.onCreateRespondentTaskLoader(id2, args);
                    }

                    public void onLoadFinished(Loader<JSONObject> loader, JSONObject data) {
                        SMFeedbackActivity.this.onGetRespondentTaskLoadFinished(loader, data);
                    }

                    public void onLoaderReset(Loader<JSONObject> loader) {
                    }
                });
            }
            catch (JSONException e) {
                this.mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_TOKEN, (Exception)((Object)e));
                Log.d((String)"SM_SDK_DEBUG", (String)this.mError.getDescription());
                throw this.mError;
            }
        }
    }

    public void onGetRespondentTaskLoadFinished(Loader<JSONObject> loader, JSONObject data) {
        if (data != null) {
            try {
                JSONObject result = data.getJSONObject("data");
                this.handleRespondent(result);
            }
            catch (JSONException e) {
                this.mError = SMError.sdkServerErrorFromCode(SMError.ErrorType.ERROR_CODE_RETRIEVING_RESPONSE, (Exception)((Object)e));
                Log.d((String)"SM_SDK_DEBUG", (String)this.mError.getDescription());
                throw this.mError;
            }
        }
    }

    private void handleRespondent(JSONObject r) {
        Intent intent = new Intent();
        intent.putExtra(SM_RESPONDENT, r.toString());
        this.setResult(-1, intent);
        this.finish();
    }

    private void handleError(SMError e) {
        Intent intent = new Intent();
        intent.putExtra(KEY_SM_ERROR, (Serializable)e);
        if (e != null) {
            intent.putExtra(KEY_SM_DESCRIPTION, e.getDescription());
            intent.putExtra(SM_ERROR_CODE, e.getErrorCode());
        } else {
            intent.putExtra(KEY_SM_DESCRIPTION, "");
            intent.putExtra(SM_ERROR_CODE, -1);
        }
        this.setResult(0, intent);
        this.finish();
    }

    private void getToken() {
        GetRespondentTokenTaskLoader loader = (GetRespondentTokenTaskLoader)this.getSupportLoaderManager().getLoader(2);
        if (loader != null) {
            this.getSupportLoaderManager().initLoader(1, null, (LoaderManager.LoaderCallbacks)new LoaderManager.LoaderCallbacks<JSONObject>(){

                public Loader<JSONObject> onCreateLoader(int id2, Bundle args) {
                    return SMFeedbackActivity.this.onCreateRespondentTokenTaskLoader(id2, args);
                }

                public void onLoadFinished(Loader<JSONObject> loader, JSONObject data) {
                    SMFeedbackActivity.this.onGetRespondentTokenTaskLoadFinished(loader, data);
                }

                public void onLoaderReset(Loader<JSONObject> loader) {
                }
            });
        }
        this.getSupportLoaderManager().restartLoader(1, null, (LoaderManager.LoaderCallbacks)new LoaderManager.LoaderCallbacks<JSONObject>(){

            public Loader<JSONObject> onCreateLoader(int id2, Bundle args) {
                return SMFeedbackActivity.this.onCreateRespondentTokenTaskLoader(id2, args);
            }

            public void onLoadFinished(Loader<JSONObject> loader, JSONObject data) {
                SMFeedbackActivity.this.onGetRespondentTokenTaskLoadFinished(loader, data);
            }

            public void onLoaderReset(Loader<JSONObject> loader) {
            }
        });
    }

    public static class ConnectivityMonitor
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            if (!this.isNetworkConnected(context)) {
                ((SMFeedbackActivity)context).findViewById(R.id.sm_feedback_no_network).setVisibility(0);
                ((SMFeedbackActivity)context).findViewById(R.id.sm_feedback_webview).setVisibility(8);
            } else {
                ((SMFeedbackActivity)context).findViewById(R.id.sm_feedback_no_network).setVisibility(8);
                ((SMFeedbackActivity)context).findViewById(R.id.sm_feedback_webview).setVisibility(0);
            }
        }

        public boolean isNetworkConnected(Context context) {
            ConnectivityManager manager = (ConnectivityManager)((SMFeedbackActivity)context).getApplication().getSystemService("connectivity");
            NetworkInfo activeNetInfo = manager.getActiveNetworkInfo();
            return activeNetInfo != null && activeNetInfo.isConnected();
        }
    }

    protected class SMExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        public SMExceptionHandler(Activity context) {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable exception) {
            SMError cause = (SMError)exception.getCause();
            SMFeedbackActivity.this.handleError(cause);
        }
    }

    private class SMWebviewClient
    extends WebViewClient {
        private SMWebviewClient() {
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            URL resourceURL = null;
            try {
                resourceURL = new URL(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (resourceURL.getPath().startsWith("/r/embed/sdk_token")) {
                view.stopLoading();
                SMFeedbackActivity.this.mTokenURL = url;
                SMFeedbackActivity.this.getToken();
            } else {
                super.onPageStarted(view, url, favicon);
            }
        }

        public void onPageFinished(WebView view, String url) {
            URL resourceURL = null;
            try {
                resourceURL = new URL(url);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            if (resourceURL.getPath().startsWith("/r/")) {
                SMFeedbackActivity.this.mProgressDialog.dismiss();
            }
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (!url.contains("surveymonkey.com/r/")) {
                Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                SMFeedbackActivity.this.startActivity(browserIntent);
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }
    }
}

