/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.view.js;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.supcon.common.view.base.activity.BaseWebViewActivity;
import com.supcon.common.view.util.LogUtil;
import com.supcon.common.view.view.js.BridgeUtil;
import com.supcon.common.view.view.js.BridgeWebView;
import com.supcon.common.view.view.js.Message;
import io.reactivex.Flowable;
import io.reactivex.functions.Consumer;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.concurrent.TimeUnit;

public class BridgeWebViewClient
extends WebViewClient {
    private BridgeWebView webView;
    private boolean isOpenPending = false;
    private boolean isCookieValid = false;
    private BaseWebViewActivity mBaseWebViewActivity;

    public BridgeWebViewClient(BridgeWebView webView) {
        this.webView = webView;
    }

    public void onLoadResource(WebView view, String url) {
        super.onLoadResource(view, url);
        if (this.mBaseWebViewActivity == null) {
            this.mBaseWebViewActivity = (BaseWebViewActivity)view.getContext();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        try {
            url = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (url.startsWith("yy://return/")) {
            this.webView.handlerReturnData(url);
            return true;
        }
        if (url.startsWith("yy://")) {
            this.webView.flushMessageQueue();
            return true;
        }
        LogUtil.d("shouldOverrideUrlLoading url:" + url);
        WebView.HitTestResult hit = this.webView.getHitTestResult();
        int hitType = hit.getType();
        LogUtil.w("hitType:" + hitType);
        if (hitType == 0) {
            if (url.contains("/cas/login")) {
                this.mBaseWebViewActivity.loginValid();
                return true;
            }
            if (url.contains("open-pending")) {
                this.isOpenPending = true;
                return super.shouldOverrideUrlLoading(view, url);
            }
            if (this.isOpenPending) {
                this.mBaseWebViewActivity.setPendingRefresh(false);
                this.newWeb(view.getContext(), url);
                return true;
            }
            if (this.mBaseWebViewActivity.checkUrl(url)) {
                this.mBaseWebViewActivity.back();
                this.mBaseWebViewActivity.setPendingRefresh(false);
                this.sendRefreshEventToParent(view.getContext());
                return true;
            }
            if (this.isCookieValid) {
                view.reload();
                this.isCookieValid = false;
                return true;
            }
            this.newWeb(view.getContext(), url);
            return true;
        }
        if (hitType == 7) {
            this.mBaseWebViewActivity.back();
            return true;
        }
        if (hitType != 9) return super.shouldOverrideUrlLoading(view, url);
        this.mBaseWebViewActivity.loginValid();
        return true;
    }

    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        if (Build.VERSION.SDK_INT >= 24) {
            String url = request.getUrl().toString();
            try {
                url = URLDecoder.decode(url, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
            }
            if (url.startsWith("yy://return/")) {
                this.webView.handlerReturnData(url);
                return true;
            }
            if (url.startsWith("yy://")) {
                this.webView.flushMessageQueue();
                return true;
            }
            return super.shouldOverrideUrlLoading(view, request);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            LogUtil.d("shouldOverrideUrlLoading url:" + request.getUrl());
        }
        return super.shouldOverrideUrlLoading(view, request);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        super.onPageStarted(view, url, favicon);
    }

    public void onPageCommitVisible(WebView view, String url) {
        super.onPageCommitVisible(view, url);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        BridgeUtil.webViewLoadLocalJs(view, "mobile.js");
        BridgeUtil.webViewLoadLocalJs(view, "WebViewJavascriptBridge.js");
        if (this.webView.getStartupMessage() != null) {
            for (Message m : this.webView.getStartupMessage()) {
                this.webView.dispatchMessage(m);
            }
            this.webView.setStartupMessage(null);
        }
    }

    public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
        if (Build.VERSION.SDK_INT >= 21) {
            LogUtil.e("onReceivedHttpError1:" + errorResponse.getReasonPhrase());
            if (!this.isCookieValid && "Unauthorized".equals(errorResponse.getReasonPhrase())) {
                ((BaseWebViewActivity)view.getContext()).unauthorized();
                return;
            }
            if ("Internal Server Error".equals(errorResponse.getReasonPhrase())) {
                this.mBaseWebViewActivity.serverError();
                return;
            }
        }
        super.onReceivedHttpError(view, request, errorResponse);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        LogUtil.e("onReceivedHttpError2:" + errorCode);
    }

    public void onScaleChanged(WebView view, float oldScale, float newScale) {
        super.onScaleChanged(view, oldScale, newScale);
    }

    private void newWeb(Context context, String url) {
        ((BaseWebViewActivity)context).next(url);
    }

    @SuppressLint(value={"CheckResult"})
    private void sendRefreshEventToParent(Context context) {
        Flowable.timer((long)500L, (TimeUnit)TimeUnit.MILLISECONDS).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) throws Exception {
                BridgeWebViewClient.this.mBaseWebViewActivity.sendRefreshEvent();
            }
        });
    }

    private void setCookie(Context context, String url, String cookieContent) {
        CookieManager cm = CookieManager.getInstance();
        CookieSyncManager csm = CookieSyncManager.createInstance((Context)context);
        cm.setAcceptCookie(true);
        cm.setCookie(url, cookieContent);
    }
}

