/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.view;

import android.content.Context;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.Interpolator;
import android.widget.Scroller;

public class CustomSwipeLayout
extends ViewGroup {
    private Mode mTouchMode = Mode.RESET;
    private ViewGroup mMainView;
    private ViewGroup mSideView;
    private ScrollRunnable mScrollRunnable;
    private int mScrollOffset = 0;
    private int mMaxScrollOffset;
    private boolean mInLayout;
    private boolean mIsLaidOut = false;
    private static final Interpolator sInterpolator = new Interpolator(){

        public float getInterpolation(float t) {
            return (t -= 1.0f) * t * t * t * t + 1.0f;
        }
    };

    public CustomSwipeLayout(Context context) {
        this(context, null);
    }

    public CustomSwipeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mScrollRunnable = new ScrollRunnable(context);
    }

    public boolean isOpen() {
        return this.mScrollOffset != 0;
    }

    Mode getTouchMode() {
        return this.mTouchMode;
    }

    void setTouchMode(Mode mode) {
        switch (this.mTouchMode) {
            case FLING: {
                this.mScrollRunnable.abort();
                break;
            }
        }
        this.mTouchMode = mode;
    }

    public void open() {
        if (this.mScrollOffset != -this.mMaxScrollOffset) {
            if (this.mTouchMode == Mode.FLING && this.mScrollRunnable.isScrollToLeft()) {
                return;
            }
            if (this.mTouchMode == Mode.FLING) {
                this.mScrollRunnable.abort();
            }
            this.mScrollRunnable.startScroll(this.mScrollOffset, -this.mMaxScrollOffset);
        }
    }

    public void close() {
        if (this.mScrollOffset != 0) {
            if (this.mTouchMode == Mode.FLING && !this.mScrollRunnable.isScrollToLeft()) {
                return;
            }
            if (this.mTouchMode == Mode.FLING) {
                this.mScrollRunnable.abort();
            }
            this.mScrollRunnable.startScroll(this.mScrollOffset, 0);
        }
    }

    void fling(int xVel) {
        this.mScrollRunnable.startFling(this.mScrollOffset, xVel);
    }

    void revise() {
        if (this.mScrollOffset < -this.mMaxScrollOffset / 2) {
            this.open();
        } else {
            this.close();
        }
    }

    boolean trackMotionScroll(int deltaX) {
        if (deltaX == 0) {
            return false;
        }
        boolean over = false;
        int newLeft = this.mScrollOffset + deltaX;
        if (deltaX > 0 && newLeft > 0 || deltaX < 0 && newLeft < -this.mMaxScrollOffset) {
            over = true;
            newLeft = Math.min(newLeft, 0);
            newLeft = Math.max(newLeft, -this.mMaxScrollOffset);
        }
        this.offsetChildrenLeftAndRight(newLeft - this.mScrollOffset);
        this.mScrollOffset = newLeft;
        return over;
    }

    private boolean ensureChildren() {
        int childCount = this.getChildCount();
        if (childCount != 2) {
            return false;
        }
        View childView = this.getChildAt(0);
        if (!(childView instanceof ViewGroup)) {
            return false;
        }
        this.mMainView = (ViewGroup)childView;
        childView = this.getChildAt(1);
        if (!(childView instanceof ViewGroup)) {
            return false;
        }
        this.mSideView = (ViewGroup)childView;
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!this.ensureChildren()) {
            throw new RuntimeException("CustomSwipeLayout \u7684\u5b50\u89c6\u56fe\u4e0d\u7b26\u5408\u89c4\u5b9a");
        }
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        ViewGroup.MarginLayoutParams lp = null;
        int horizontalPadding = this.getPaddingLeft() + this.getPaddingRight();
        int verticalPadding = this.getPaddingTop() + this.getPaddingBottom();
        lp = (ViewGroup.MarginLayoutParams)this.mMainView.getLayoutParams();
        int horizontalMargin = lp.leftMargin + lp.rightMargin;
        int verticalMargin = lp.topMargin + lp.bottomMargin;
        this.measureChildWithMargins((View)this.mMainView, widthMeasureSpec, horizontalMargin + horizontalPadding, heightMeasureSpec, verticalMargin + verticalPadding);
        if (widthMode == Integer.MIN_VALUE) {
            widthSize = Math.min(widthSize, this.mMainView.getMeasuredWidth() + horizontalMargin + horizontalPadding);
        } else if (widthMode == 0) {
            widthSize = this.mMainView.getMeasuredWidth() + horizontalMargin + horizontalPadding;
        }
        if (heightMode == Integer.MIN_VALUE) {
            heightSize = Math.min(heightSize, this.mMainView.getMeasuredHeight() + verticalMargin + verticalPadding);
        } else if (heightMode == 0) {
            heightSize = this.mMainView.getMeasuredHeight() + verticalMargin + verticalPadding;
        }
        this.setMeasuredDimension(widthSize, heightSize);
        lp = (ViewGroup.MarginLayoutParams)this.mSideView.getLayoutParams();
        verticalMargin = lp.topMargin + lp.bottomMargin;
        this.mSideView.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)(this.getMeasuredHeight() - verticalMargin - verticalPadding), (int)0x40000000));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (!this.ensureChildren()) {
            throw new RuntimeException("CustomSwipeLayout \u7684\u5b50\u89c6\u56fe\u4e0d\u7b26\u5408\u89c4\u5b9a");
        }
        this.mInLayout = true;
        int pl = this.getPaddingLeft();
        int pt = this.getPaddingTop();
        int pr = this.getPaddingRight();
        int pb = this.getPaddingBottom();
        ViewGroup.MarginLayoutParams mainLp = (ViewGroup.MarginLayoutParams)this.mMainView.getLayoutParams();
        ViewGroup.MarginLayoutParams sideParams = (ViewGroup.MarginLayoutParams)this.mSideView.getLayoutParams();
        int childLeft = pl + mainLp.leftMargin;
        int childTop = pt + mainLp.topMargin;
        int childRight = this.getWidth() - (pr + mainLp.rightMargin);
        int childBottom = this.getHeight() - (mainLp.bottomMargin + pb);
        this.mMainView.layout(childLeft, childTop, childRight, childBottom);
        childLeft = childRight + sideParams.leftMargin;
        childTop = pt + sideParams.topMargin;
        childRight = childLeft + sideParams.leftMargin + sideParams.rightMargin + this.mSideView.getMeasuredWidth();
        childBottom = this.getHeight() - (sideParams.bottomMargin + pb);
        this.mSideView.layout(childLeft, childTop, childRight, childBottom);
        this.mMaxScrollOffset = this.mSideView.getWidth() + sideParams.leftMargin + sideParams.rightMargin;
        this.mScrollOffset = this.mScrollOffset < -this.mMaxScrollOffset / 2 ? -this.mMaxScrollOffset : 0;
        this.offsetChildrenLeftAndRight(this.mScrollOffset);
        this.mInLayout = false;
        this.mIsLaidOut = true;
    }

    void offsetChildrenLeftAndRight(int delta) {
        ViewCompat.offsetLeftAndRight((View)this.mMainView, (int)delta);
        ViewCompat.offsetLeftAndRight((View)this.mSideView, (int)delta);
    }

    public void requestLayout() {
        if (!this.mInLayout) {
            super.requestLayout();
        }
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.MarginLayoutParams ? p : new ViewGroup.MarginLayoutParams(p);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof ViewGroup.MarginLayoutParams && super.checkLayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attrs);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mScrollOffset != 0 && this.mIsLaidOut) {
            this.offsetChildrenLeftAndRight(-this.mScrollOffset);
            this.mScrollOffset = 0;
        } else {
            this.mScrollOffset = 0;
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mScrollOffset != 0 && this.mIsLaidOut) {
            this.offsetChildrenLeftAndRight(-this.mScrollOffset);
            this.mScrollOffset = 0;
        } else {
            this.mScrollOffset = 0;
        }
        this.removeCallbacks(this.mScrollRunnable);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getActionMasked();
        switch (action) {
            case 0: {
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                View pointView = CustomSwipeLayout.findTopChildUnder(this, x, y);
                if (pointView == null || pointView != this.mMainView || this.mScrollOffset == 0) break;
                return true;
            }
            case 2: 
            case 3: {
                break;
            }
            case 1: {
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                View pointView = CustomSwipeLayout.findTopChildUnder(this, x, y);
                if (pointView == null || pointView != this.mMainView || this.mTouchMode != Mode.TAP || this.mScrollOffset == 0) break;
                return true;
            }
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int action = ev.getActionMasked();
        switch (action) {
            case 0: {
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                View pointView = CustomSwipeLayout.findTopChildUnder(this, x, y);
                if (pointView == null || pointView != this.mMainView || this.mScrollOffset == 0) break;
                return true;
            }
            case 2: 
            case 3: {
                break;
            }
            case 1: {
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                View pointView = CustomSwipeLayout.findTopChildUnder(this, x, y);
                if (pointView == null || pointView != this.mMainView || this.mTouchMode != Mode.TAP || this.mScrollOffset == 0) break;
                this.close();
                return true;
            }
        }
        return false;
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.getVisibility() != 0) {
            this.mScrollOffset = 0;
            this.invalidate();
        }
    }

    static View findTopChildUnder(ViewGroup parent, int x, int y) {
        int childCount = parent.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            View child = parent.getChildAt(i);
            if (x < child.getLeft() || x >= child.getRight() || y < child.getTop() || y >= child.getBottom()) continue;
            return child;
        }
        return null;
    }

    public static void closeAllItems(RecyclerView recyclerView) {
        for (int i = 0; i < recyclerView.getChildCount(); ++i) {
            CustomSwipeLayout customSwipeLayout;
            View child = recyclerView.getChildAt(i);
            if (!(child instanceof CustomSwipeLayout) || !(customSwipeLayout = (CustomSwipeLayout)child).isOpen()) continue;
            customSwipeLayout.close();
        }
    }

    public static class OnSwipeItemTouchListener
    implements RecyclerView.OnItemTouchListener {
        private CustomSwipeLayout mCaptureItem;
        private float mLastMotionX;
        private float mLastMotionY;
        private VelocityTracker mVelocityTracker;
        private int mActivePointerId;
        private int mTouchSlop;
        private int mMaximumVelocity;
        private boolean mDealByParent;
        private boolean mIsProbeParent;

        public OnSwipeItemTouchListener(Context context) {
            ViewConfiguration configuration = ViewConfiguration.get((Context)context);
            this.mTouchSlop = configuration.getScaledTouchSlop();
            this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
            this.mActivePointerId = -1;
            this.mDealByParent = false;
            this.mIsProbeParent = false;
        }

        public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent ev) {
            if (this.mIsProbeParent) {
                return false;
            }
            boolean intercept = false;
            int action = ev.getActionMasked();
            if (this.mVelocityTracker == null) {
                this.mVelocityTracker = VelocityTracker.obtain();
            }
            this.mVelocityTracker.addMovement(ev);
            switch (action) {
                case 0: {
                    this.mActivePointerId = ev.getPointerId(0);
                    float x = ev.getX();
                    float y = ev.getY();
                    this.mLastMotionX = x;
                    this.mLastMotionY = y;
                    boolean pointOther = false;
                    CustomSwipeLayout pointItem = null;
                    View pointView = CustomSwipeLayout.findTopChildUnder((ViewGroup)rv, (int)x, (int)y);
                    if (pointView == null || !(pointView instanceof CustomSwipeLayout)) {
                        pointOther = true;
                    } else {
                        pointItem = (CustomSwipeLayout)pointView;
                    }
                    if (!(pointOther || this.mCaptureItem != null && this.mCaptureItem == pointItem)) {
                        pointOther = true;
                    }
                    if (!pointOther) {
                        ViewParent parent;
                        Mode touchMode = this.mCaptureItem.getTouchMode();
                        boolean disallowIntercept = false;
                        if (touchMode == Mode.FLING) {
                            this.mCaptureItem.setTouchMode(Mode.DRAG);
                            disallowIntercept = true;
                            intercept = true;
                        } else {
                            this.mCaptureItem.setTouchMode(Mode.TAP);
                            if (this.mCaptureItem.isOpen()) {
                                disallowIntercept = true;
                            }
                        }
                        if (disallowIntercept && (parent = rv.getParent()) != null) {
                            parent.requestDisallowInterceptTouchEvent(true);
                        }
                    } else {
                        if (this.mCaptureItem != null && this.mCaptureItem.isOpen()) {
                            this.mCaptureItem.close();
                            this.mCaptureItem = null;
                            intercept = true;
                        }
                        if (pointItem != null) {
                            this.mCaptureItem = pointItem;
                            this.mCaptureItem.setTouchMode(Mode.TAP);
                        } else {
                            this.mCaptureItem = null;
                        }
                    }
                    this.mIsProbeParent = true;
                    this.mDealByParent = rv.onInterceptTouchEvent(ev);
                    this.mIsProbeParent = false;
                    if (!this.mDealByParent) break;
                    intercept = false;
                    break;
                }
                case 5: {
                    int actionIndex = ev.getActionIndex();
                    this.mActivePointerId = ev.getPointerId(actionIndex);
                    this.mLastMotionX = ev.getX(actionIndex);
                    this.mLastMotionY = ev.getY(actionIndex);
                    break;
                }
                case 6: {
                    int actionIndex = ev.getActionIndex();
                    int pointerId = ev.getPointerId(actionIndex);
                    if (pointerId != this.mActivePointerId) break;
                    int newIndex = actionIndex == 0 ? 1 : 0;
                    this.mActivePointerId = ev.getPointerId(newIndex);
                    this.mLastMotionX = ev.getX(newIndex);
                    this.mLastMotionY = ev.getY(newIndex);
                    break;
                }
                case 2: {
                    int activePointerIndex = ev.findPointerIndex(this.mActivePointerId);
                    if (activePointerIndex == -1) break;
                    if (this.mDealByParent) {
                        if (this.mCaptureItem != null && this.mCaptureItem.isOpen()) {
                            this.mCaptureItem.close();
                        }
                        return false;
                    }
                    int x = (int)(ev.getX(activePointerIndex) + 0.5f);
                    int y = (int)((float)((int)ev.getY(activePointerIndex)) + 0.5f);
                    int deltaX = (int)((float)x - this.mLastMotionX);
                    int deltaY = (int)((float)y - this.mLastMotionY);
                    int xDiff = Math.abs(deltaX);
                    int yDiff = Math.abs(deltaY);
                    if (this.mCaptureItem == null || this.mDealByParent) break;
                    Mode touchMode = this.mCaptureItem.getTouchMode();
                    if (touchMode == Mode.TAP) {
                        if (xDiff > this.mTouchSlop && xDiff > yDiff) {
                            this.mCaptureItem.setTouchMode(Mode.DRAG);
                            ViewParent parent = rv.getParent();
                            parent.requestDisallowInterceptTouchEvent(true);
                            deltaX = deltaX > 0 ? deltaX - this.mTouchSlop : deltaX + this.mTouchSlop;
                        } else {
                            this.mIsProbeParent = true;
                            boolean isParentConsume = rv.onInterceptTouchEvent(ev);
                            this.mIsProbeParent = false;
                            if (isParentConsume) {
                                this.mDealByParent = true;
                                this.mCaptureItem.close();
                            }
                        }
                    }
                    if ((touchMode = this.mCaptureItem.getTouchMode()) != Mode.DRAG) break;
                    intercept = true;
                    this.mLastMotionX = x;
                    this.mLastMotionY = y;
                    this.mCaptureItem.trackMotionScroll(deltaX);
                    break;
                }
                case 1: {
                    Mode touchMode;
                    if (this.mCaptureItem != null && (touchMode = this.mCaptureItem.getTouchMode()) == Mode.DRAG) {
                        VelocityTracker velocityTracker = this.mVelocityTracker;
                        velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                        int xVel = (int)velocityTracker.getXVelocity(this.mActivePointerId);
                        this.mCaptureItem.fling(xVel);
                        intercept = true;
                    }
                    this.cancel();
                    break;
                }
                case 3: {
                    if (this.mCaptureItem != null) {
                        this.mCaptureItem.revise();
                    }
                    this.cancel();
                }
            }
            return intercept;
        }

        public void onTouchEvent(RecyclerView rv, MotionEvent ev) {
            int action = ev.getActionMasked();
            int actionIndex = ev.getActionIndex();
            if (this.mVelocityTracker == null) {
                this.mVelocityTracker = VelocityTracker.obtain();
            }
            this.mVelocityTracker.addMovement(ev);
            switch (action) {
                case 5: {
                    this.mActivePointerId = ev.getPointerId(actionIndex);
                    this.mLastMotionX = ev.getX(actionIndex);
                    this.mLastMotionY = ev.getY(actionIndex);
                    break;
                }
                case 6: {
                    int pointerId = ev.getPointerId(actionIndex);
                    if (pointerId != this.mActivePointerId) break;
                    int newIndex = actionIndex == 0 ? 1 : 0;
                    this.mActivePointerId = ev.getPointerId(newIndex);
                    this.mLastMotionX = ev.getX(newIndex);
                    this.mLastMotionY = ev.getY(newIndex);
                    break;
                }
                case 2: {
                    int activePointerIndex = ev.findPointerIndex(this.mActivePointerId);
                    if (activePointerIndex == -1) break;
                    float x = ev.getX(activePointerIndex);
                    float y = (int)ev.getY(activePointerIndex);
                    int deltaX = (int)(x - this.mLastMotionX);
                    if (this.mCaptureItem == null || this.mCaptureItem.getTouchMode() != Mode.DRAG) break;
                    this.mLastMotionX = x;
                    this.mLastMotionY = y;
                    this.mCaptureItem.trackMotionScroll(deltaX);
                    break;
                }
                case 1: {
                    Mode touchMode;
                    if (this.mCaptureItem != null && (touchMode = this.mCaptureItem.getTouchMode()) == Mode.DRAG) {
                        VelocityTracker velocityTracker = this.mVelocityTracker;
                        velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                        int xVel = (int)velocityTracker.getXVelocity(this.mActivePointerId);
                        this.mCaptureItem.fling(xVel);
                    }
                    this.cancel();
                    break;
                }
                case 3: {
                    if (this.mCaptureItem != null) {
                        this.mCaptureItem.revise();
                    }
                    this.cancel();
                }
            }
        }

        public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        }

        void cancel() {
            this.mDealByParent = false;
            this.mActivePointerId = -1;
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
    }

    class ScrollRunnable
    implements Runnable {
        private static final int FLING_DURATION = 200;
        private Scroller mScroller;
        private boolean mAbort;
        private int mMinVelocity;
        private boolean mScrollToLeft;

        ScrollRunnable(Context context) {
            this.mScroller = new Scroller(context, sInterpolator);
            this.mAbort = false;
            this.mScrollToLeft = false;
            ViewConfiguration configuration = ViewConfiguration.get((Context)context);
            this.mMinVelocity = configuration.getScaledMinimumFlingVelocity();
        }

        void startScroll(int startX, int endX) {
            if (startX != endX) {
                CustomSwipeLayout.this.setTouchMode(Mode.FLING);
                this.mAbort = false;
                this.mScrollToLeft = endX < startX;
                this.mScroller.startScroll(startX, 0, endX - startX, 0, 400);
                ViewCompat.postOnAnimation((View)CustomSwipeLayout.this, (Runnable)this);
            }
        }

        void startFling(int startX, int xVel) {
            if (xVel > this.mMinVelocity && startX != 0) {
                this.startScroll(startX, 0);
                return;
            }
            if (xVel < -this.mMinVelocity && startX != -CustomSwipeLayout.this.mMaxScrollOffset) {
                this.startScroll(startX, -CustomSwipeLayout.this.mMaxScrollOffset);
                return;
            }
            this.startScroll(startX, startX > -CustomSwipeLayout.this.mMaxScrollOffset / 2 ? 0 : -CustomSwipeLayout.this.mMaxScrollOffset);
        }

        void abort() {
            if (!this.mAbort) {
                this.mAbort = true;
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                    CustomSwipeLayout.this.removeCallbacks(this);
                }
            }
        }

        boolean isScrollToLeft() {
            return this.mScrollToLeft;
        }

        @Override
        public void run() {
            if (!this.mAbort) {
                boolean more = this.mScroller.computeScrollOffset();
                int curX = this.mScroller.getCurrX();
                boolean atEdge = CustomSwipeLayout.this.trackMotionScroll(curX - CustomSwipeLayout.this.mScrollOffset);
                if (more && !atEdge) {
                    ViewCompat.postOnAnimation((View)CustomSwipeLayout.this, (Runnable)this);
                    return;
                }
                if (atEdge) {
                    CustomSwipeLayout.this.removeCallbacks(this);
                    if (!this.mScroller.isFinished()) {
                        this.mScroller.abortAnimation();
                    }
                    CustomSwipeLayout.this.setTouchMode(Mode.RESET);
                }
                if (!more) {
                    CustomSwipeLayout.this.setTouchMode(Mode.RESET);
                    if (CustomSwipeLayout.this.mScrollOffset != 0) {
                        if (Math.abs(CustomSwipeLayout.this.mScrollOffset) > CustomSwipeLayout.this.mMaxScrollOffset / 2) {
                            CustomSwipeLayout.this.mScrollOffset = -CustomSwipeLayout.this.mMaxScrollOffset;
                        } else {
                            CustomSwipeLayout.this.mScrollOffset = 0;
                        }
                        ViewCompat.postOnAnimation((View)CustomSwipeLayout.this, (Runnable)this);
                    }
                }
            }
        }
    }

    static enum Mode {
        RESET,
        DRAG,
        FLING,
        TAP;

    }
}

