/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.fragment;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.supcon.common.view.base.IData;
import com.supcon.common.view.util.LoaderErrorMsgHelper;
import com.supcon.common.view.util.LogUtil;
import com.supcon.common.view.util.ViewBinder;
import com.supcon.common.view.view.loader.base.LoaderController;
import com.supcon.common.view.view.loader.base.OnLoaderFinishListener;
import java.util.Map;

public abstract class BaseFragment
extends Fragment
implements IData {
    protected View rootView;
    protected Context context;
    protected LoaderController loaderController;

    protected abstract int getLayoutID();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.context = this.getActivity();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.rootView = inflater.inflate(this.getLayoutID(), container, false);
        this.onInit();
        this.initView();
        this.initListener();
        this.initData();
        return this.rootView;
    }

    protected void onInit() {
        this.loaderController = new LoaderController(this.getContext(), this.rootView);
        ViewBinder.bindTag(this, this.rootView);
    }

    public View getRootView() {
        return this.rootView;
    }

    public void onStart() {
        super.onStart();
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
    }

    protected void initView() {
    }

    protected void initListener() {
        ViewBinder.bindCustomView(this, this.rootView);
        ViewBinder.bindListener(this, this.rootView);
    }

    protected void initData() {
    }

    public void onDestroy() {
        super.onDestroy();
        this.loaderController.onDestroy();
    }

    protected void finalize() throws Throwable {
        LogUtil.d("finalize() " + this.toString());
        super.finalize();
    }

    protected void showErrorMsg(String msg) {
        LoaderErrorMsgHelper.showErrorMsg(this.loaderController, msg);
    }

    public void onLoading(String msg) {
        this.loaderController.showLoader(msg);
    }

    public void onLoading() {
        this.onLoading("");
    }

    public void onLoadSuccess(String msg) {
        this.onLoadSuccessAndExit(msg, null);
    }

    public void onLoadSuccessAndExit(String msg, OnLoaderFinishListener listener) {
        this.loaderController.showMsgAndclose(msg, true, 500L, listener);
    }

    public void onLoadFailed(String msg) {
        this.showErrorMsg(msg);
    }

    public void closeLoader() {
        this.loaderController.closeLoader();
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean checkBeforeSubmit(Map<String, Object> map) {
        return this.doSave(map);
    }

    @Override
    public boolean doSave(Map<String, Object> map) {
        return true;
    }

    @Override
    public boolean isModified() {
        return false;
    }
}

