/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.controller;

import android.content.Context;
import android.content.Intent;
import android.view.View;
import android.view.ViewGroup;
import com.supcon.common.view.R;
import com.supcon.common.view.base.controller.IRefreshController;
import com.supcon.common.view.listener.OnRefreshListener;
import com.supcon.common.view.ptr.PtrClassicDefaultHeader;
import com.supcon.common.view.ptr.PtrDefaultHandler;
import com.supcon.common.view.ptr.PtrFrameLayout;
import com.supcon.common.view.ptr.PtrHandler;
import com.supcon.common.view.ptr.header.MaterialHeader;
import com.supcon.common.view.util.DisplayUtil;

public class RefreshController<TContentView extends View>
implements PtrHandler,
IRefreshController {
    protected PtrFrameLayout refreshFrameLayout;
    protected TContentView contentView;
    private OnRefreshListener onRefreshListener;
    private boolean isAutoPullDownRefresh = true;
    protected Context mContext;
    private PtrClassicDefaultHeader mPtrClassicHeader;

    @Override
    public void setOnRefreshListener(OnRefreshListener onRefreshListener) {
        this.onRefreshListener = onRefreshListener;
    }

    public RefreshController(Context context, View view) {
        this.mContext = context;
        this.refreshFrameLayout = (PtrFrameLayout)view;
        this.contentView = this.refreshFrameLayout.findViewById(R.id.contentView);
    }

    @Override
    public void setPullDownRefreshEnabled(boolean enabled) {
        this.refreshFrameLayout.setEnabled(enabled);
    }

    @Override
    public void setAutoPullDownRefresh(boolean autoPullDownRefresh) {
        this.isAutoPullDownRefresh = autoPullDownRefresh;
    }

    @Override
    public void onInit() {
    }

    @Override
    public void initView() {
        if (this.refreshFrameLayout != null) {
            this.refreshFrameLayout.setHeaderView(this.getHeaderView());
            this.refreshFrameLayout.setPtrHandler(this);
            this.refreshFrameLayout.setResistance(1.7f);
            this.refreshFrameLayout.setRatioOfHeaderHeightToRefresh(1.2f);
            this.refreshFrameLayout.setDurationToClose(300);
            this.refreshFrameLayout.setDurationToCloseHeader(300);
            this.refreshFrameLayout.setPullToRefresh(false);
            this.refreshFrameLayout.setKeepHeaderWhenRefresh(true);
        }
    }

    @Override
    public void initListener() {
    }

    @Override
    public void initData() {
        if (this.isAutoPullDownRefresh) {
            this.refreshBegin();
        }
    }

    @Override
    public boolean checkCanDoRefresh(PtrFrameLayout frame, View content, View header) {
        return PtrDefaultHandler.checkContentCanBePulledDown(frame, this.contentView, header);
    }

    @Override
    public void onRefreshBegin(PtrFrameLayout frame) {
        this.onRefreshBegin();
    }

    protected void onRefreshBegin() {
        if (this.onRefreshListener != null) {
            this.onRefreshListener.onRefresh();
        }
    }

    @Override
    public void refreshBegin() {
        if (this.refreshFrameLayout != null) {
            this.refreshFrameLayout.postDelayed(new Runnable(){

                @Override
                public void run() {
                    RefreshController.this.refreshFrameLayout.autoRefresh(true, 500);
                }
            }, 200L);
        }
    }

    @Override
    public void refreshComplete() {
        if (this.refreshFrameLayout != null) {
            this.refreshFrameLayout.refreshComplete();
        }
    }

    public void refreshError(Throwable ex) {
        this.refreshComplete();
    }

    protected View getHeaderView() {
        MaterialHeader header = new MaterialHeader(this.mContext);
        int[] colors = this.mContext.getResources().getIntArray(R.array.google_colors);
        header.setColorSchemeColors(colors);
        header.setLayoutParams((ViewGroup.LayoutParams)new PtrFrameLayout.LayoutParams(-1, -2));
        header.setPadding(0, DisplayUtil.dip2px(5.0f, this.mContext), 0, DisplayUtil.dip2px(5.0f, this.mContext));
        header.setPtrFrameLayout(this.refreshFrameLayout);
        this.refreshFrameLayout.addPtrUIHandler(header);
        this.refreshFrameLayout.setPinContent(true);
        return header;
    }

    @Override
    public void setHeader(View header) {
        this.refreshFrameLayout.setHeaderView(header);
    }

    @Override
    public void setPinContent(boolean isPinContent) {
        this.refreshFrameLayout.setPinContent(isPinContent);
    }

    public TContentView getContentView() {
        return this.contentView;
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onResume() {
    }

    @Override
    public void onPause() {
    }

    @Override
    public void onDestroy() {
    }

    @Override
    public void onRetry() {
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
    }
}

