/*
 * Decompiled with CFR 0.152.
 */
package com.supcon.common.view.base.activity;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import com.supcon.common.view.R;
import com.supcon.common.view.base.IData;
import com.supcon.common.view.util.KeyboardUtil;
import com.supcon.common.view.util.LoaderErrorMsgHelper;
import com.supcon.common.view.util.StatusBarUtils;
import com.supcon.common.view.util.ViewBinder;
import com.supcon.common.view.view.loader.base.LoaderController;
import com.supcon.common.view.view.loader.base.OnLoaderFinishListener;
import com.supcon.common.view.view.swipeback.SwipeBackController;
import java.util.Map;

public abstract class BaseActivity
extends AppCompatActivity
implements IData,
SwipeBackController.Delegate {
    protected View rootView;
    protected Context context;
    protected LoaderController loaderController;
    protected SwipeBackController swipeBackController;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.context = this;
        this.rootView = LayoutInflater.from((Context)this).inflate(this.getLayoutID(), null);
        this.setContentView(this.rootView);
        this.onInit();
        this.initView();
        this.initListener();
        this.initData();
    }

    protected void onInit() {
        this.loaderController = new LoaderController((Context)this, this.rootView);
        ViewBinder.bindTag((Activity)this);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    protected void onPause() {
        super.onPause();
    }

    protected void onStart() {
        super.onStart();
    }

    public View getRootView() {
        return this.rootView;
    }

    protected abstract int getLayoutID();

    protected void initView() {
        this.initSwipeBackController();
    }

    protected void initListener() {
        ViewBinder.bindCustomView(this, this.rootView);
        ViewBinder.bindListener(this, this.rootView);
    }

    protected void initData() {
    }

    public void back() {
        this.finish();
    }

    public void onBackPressed() {
        if (this.swipeBackController.isSliding()) {
            return;
        }
        this.back();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.loaderController.onDestroy();
    }

    public void onLoading(String msg) {
        this.loaderController.showLoader(msg);
    }

    public void onLoading() {
        this.onLoading("");
    }

    public void onLoadSuccess() {
        this.onLoadSuccess("");
    }

    public void onLoadSuccess(String msg) {
        this.onLoadSuccessAndExit(msg, null);
    }

    public void onLoadSuccessAndExit(String msg, OnLoaderFinishListener listener) {
        this.loaderController.showMsgAndclose(msg, true, 500L, listener);
    }

    public void onLoadFailed(String msg) {
        this.showErrorMsg(msg);
    }

    public void closeLoader() {
        this.loaderController.closeLoader();
    }

    protected void showErrorMsg(String msg) {
        LoaderErrorMsgHelper.showErrorMsg(this.loaderController, msg);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return super.onTouchEvent(event);
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean checkBeforeSubmit(Map<String, Object> map) {
        return this.doSave(map);
    }

    @Override
    public boolean doSave(Map<String, Object> map) {
        return true;
    }

    @Override
    public boolean isModified() {
        return false;
    }

    public void setStatusBarColor(int colorResId) {
        StatusBarUtils.setWindowStatusBarColor((Activity)this, colorResId);
    }

    @Override
    public boolean isSwipeBackEnable() {
        return this.swipeBackController != null && this.swipeBackController.isSwipeBackEnable();
    }

    public void setSwipeBackEnable(boolean swipeBackEnable) {
        if (this.swipeBackController != null) {
            this.swipeBackController.setSwipeBackEnable(swipeBackEnable);
        }
    }

    private void initSwipeBackController() {
        this.swipeBackController = new SwipeBackController((Activity)this, this);
        this.swipeBackController.setSwipeBackEnable(true);
        this.swipeBackController.setIsOnlyTrackingLeftEdge(true);
        this.swipeBackController.setIsWeChatStyle(true);
        this.swipeBackController.setShadowResId(R.drawable.bg_sbl_shadow);
        this.swipeBackController.setIsNeedShowShadow(true);
        this.swipeBackController.setIsShadowAlphaGradient(true);
        this.swipeBackController.setSwipeBackThreshold(0.3f);
        this.swipeBackController.setIsNavigationBarOverlap(false);
    }

    @Override
    public boolean isSupportSwipeBack() {
        return true;
    }

    @Override
    public void onSwipeBackSlide(float slideOffset) {
    }

    @Override
    public void onSwipeBackCancel() {
    }

    @Override
    public void onSwipeBackStop(int errorCode) {
        if (errorCode == 2) {
            this.onBackPressed();
        }
    }

    @Override
    public void onSwipeBackExecuted() {
        KeyboardUtil.closeKeyboard((Activity)this);
        this.back();
        this.executeBackwardAnim();
    }

    public void executeBackwardAnim() {
        this.overridePendingTransition(0, 0);
    }
}

