/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream.buffer.sax;

import com.sun.xml.stream.buffer.AbstractProcessor;
import com.sun.xml.stream.buffer.AttributesHolder;
import com.sun.xml.stream.buffer.XMLStreamBuffer;
import com.sun.xml.stream.buffer.sax.DefaultWithLexicalHandler;
import java.io.IOException;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class SAXBufferProcessor
extends AbstractProcessor
implements XMLReader {
    protected EntityResolver _entityResolver;
    protected DTDHandler _dtdHandler;
    protected ContentHandler _contentHandler;
    protected ErrorHandler _errorHandler;
    protected LexicalHandler _lexicalHandler;
    protected boolean _namespacePrefixesFeature = false;
    protected AttributesHolder _attributes;
    protected String[] _namespacePrefixes = new String[16];
    protected int _namespacePrefixesIndex;
    protected int[] _namespaceAttributesStack = new int[16];
    protected int _namespaceAttributesStackIndex;

    public SAXBufferProcessor() {
        DefaultWithLexicalHandler handler = new DefaultWithLexicalHandler();
        this._entityResolver = handler;
        this._dtdHandler = handler;
        this._contentHandler = handler;
        this._errorHandler = handler;
        this._lexicalHandler = handler;
        this._attributes = new AttributesHolder();
    }

    public SAXBufferProcessor(XMLStreamBuffer buffer) {
        this();
        this.setXMLStreamBuffer(buffer);
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/features/namespaces")) {
            return true;
        }
        if (name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            return this._namespacePrefixesFeature;
        }
        if (name.equals("http://xml.org/sax/features/external-general-entities")) {
            return true;
        }
        if (name.equals("http://xml.org/sax/features/external-parameter-entities")) {
            return true;
        }
        if (name.equals("http://xml.org/sax/features/string-interning")) {
            return this._stringInterningFeature;
        }
        throw new SAXNotRecognizedException("Feature not supported: " + name);
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/features/namespaces")) {
            if (!value) {
                throw new SAXNotSupportedException(name + ":" + value);
            }
        } else if (name.equals("http://xml.org/sax/features/namespace-prefixes")) {
            this._namespacePrefixesFeature = value;
        } else if (!name.equals("http://xml.org/sax/features/external-general-entities") && !name.equals("http://xml.org/sax/features/external-parameter-entities")) {
            if (name.equals("http://xml.org/sax/features/string-interning")) {
                if (value != this._stringInterningFeature) {
                    throw new SAXNotSupportedException(name + ":" + value);
                }
            } else {
                throw new SAXNotRecognizedException("Feature not supported: " + name);
            }
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            return this.getLexicalHandler();
        }
        throw new SAXNotRecognizedException("Property not recognized: " + name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals("http://xml.org/sax/properties/lexical-handler")) {
            if (!(value instanceof LexicalHandler)) {
                throw new SAXNotSupportedException("http://xml.org/sax/properties/lexical-handler");
            }
        } else {
            throw new SAXNotRecognizedException("Property not recognized: " + name);
        }
        this.setLexicalHandler((LexicalHandler)value);
    }

    public void setEntityResolver(EntityResolver resolver) {
        this._entityResolver = resolver;
    }

    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    public void setDTDHandler(DTDHandler handler) {
        this._dtdHandler = handler;
    }

    public DTDHandler getDTDHandler() {
        return this._dtdHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this._contentHandler = handler;
    }

    public ContentHandler getContentHandler() {
        return this._contentHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this._errorHandler = handler;
    }

    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this._lexicalHandler = handler;
    }

    public LexicalHandler getLexicalHandler() {
        return this._lexicalHandler;
    }

    public void parse(InputSource input) throws IOException, SAXException {
        this.process();
    }

    public void parse(String systemId) throws IOException, SAXException {
        this.process();
    }

    public final void process(XMLStreamBuffer buffer) throws SAXException {
        this.setXMLStreamBuffer(buffer);
        this.process();
    }

    public void setXMLStreamBuffer(XMLStreamBuffer buffer) {
        this.setBuffer(buffer);
    }

    public final void process() throws SAXException {
        int item = this.readStructure();
        switch (_eiiStateTable[item]) {
            case 1: {
                this.processDocument();
                break;
            }
            case 17: {
                return;
            }
            case 3: {
                this.processElement(this.readStructureString(), this.readStructureString(), this.readStructureString());
                break;
            }
            case 4: {
                String prefix = this.readStructureString();
                String uri = this.readStructureString();
                String localName = this.readStructureString();
                this.processElement(uri, localName, this.getQName(prefix, localName));
                break;
            }
            case 5: {
                String uri = this.readStructureString();
                String localName = this.readStructureString();
                this.processElement(uri, localName, localName);
                break;
            }
            case 6: {
                String localName = this.readStructureString();
                this.processElement("", localName, localName);
                break;
            }
            default: {
                throw this.reportFatalError("Illegal state for DIIs: " + item);
            }
        }
    }

    private SAXParseException reportFatalError(String msg) throws SAXException {
        SAXParseException spe = new SAXParseException(msg, null);
        if (this._errorHandler != null) {
            this._errorHandler.fatalError(spe);
        }
        return spe;
    }

    private void processDocument() throws SAXException {
        int item;
        this._contentHandler.startDocument();
        boolean firstElementHasOccured = false;
        do {
            item = this.readStructure();
            switch (_eiiStateTable[item]) {
                case 3: {
                    firstElementHasOccured = true;
                    this.processElement(this.readStructureString(), this.readStructureString(), this.readStructureString());
                    break;
                }
                case 4: {
                    firstElementHasOccured = true;
                    String prefix = this.readStructureString();
                    String uri = this.readStructureString();
                    String localName = this.readStructureString();
                    this.processElement(uri, localName, this.getQName(prefix, localName));
                    break;
                }
                case 5: {
                    firstElementHasOccured = true;
                    String uri = this.readStructureString();
                    String localName = this.readStructureString();
                    this.processElement(uri, localName, localName);
                    break;
                }
                case 6: {
                    firstElementHasOccured = true;
                    String localName = this.readStructureString();
                    this.processElement("", localName, localName);
                    break;
                }
                case 12: {
                    int length = this.readStructure();
                    int start = this.readContentCharactersBuffer(length);
                    this.processComment(this._contentCharactersBuffer, start, length);
                    break;
                }
                case 13: {
                    int length = this.readStructure() << 8 | this.readStructure();
                    int start = this.readContentCharactersBuffer(length);
                    this.processComment(this._contentCharactersBuffer, start, length);
                    break;
                }
                case 14: {
                    char[] ch = this.readContentCharactersCopy();
                    this.processComment(ch, 0, ch.length);
                    break;
                }
                case 15: {
                    this.processComment(this.readContentString());
                    break;
                }
                case 16: {
                    this.processProcessingInstruction(this.readStructureString(), this.readStructureString());
                    break;
                }
                case 17: {
                    break;
                }
                default: {
                    throw this.reportFatalError("Illegal state for child of DII: " + item);
                }
            }
        } while (item != 0 || !firstElementHasOccured);
        block21: while (item != 0) {
            item = this.readStructure();
            switch (_eiiStateTable[item]) {
                case 12: {
                    int length = this.readStructure();
                    int start = this.readContentCharactersBuffer(length);
                    this.processComment(this._contentCharactersBuffer, start, length);
                    continue block21;
                }
                case 13: {
                    int length = this.readStructure() << 8 | this.readStructure();
                    int start = this.readContentCharactersBuffer(length);
                    this.processComment(this._contentCharactersBuffer, start, length);
                    continue block21;
                }
                case 14: {
                    char[] ch = this.readContentCharactersCopy();
                    this.processComment(ch, 0, ch.length);
                    continue block21;
                }
                case 15: {
                    this.processComment(this.readContentString());
                    continue block21;
                }
                case 16: {
                    this.processProcessingInstruction(this.readStructureString(), this.readStructureString());
                    continue block21;
                }
                case 17: {
                    continue block21;
                }
            }
            throw this.reportFatalError("Illegal state for child of DII: " + item);
        }
        this._contentHandler.endDocument();
    }

    private void processElement(String uri, String localName, String qName) throws SAXException {
        boolean hasAttributes = false;
        boolean hasNamespaceAttributes = false;
        int item = this.peekStructure();
        if ((item & 0xF0) == 64) {
            hasNamespaceAttributes = true;
            item = this.processNamespaceAttributes(item);
        }
        if ((item & 0xF0) == 48) {
            hasAttributes = true;
            this.processAttributes(item);
        }
        this._contentHandler.startElement(uri, localName, qName, this._attributes);
        if (hasAttributes) {
            this._attributes.clear();
        }
        do {
            item = _eiiStateTable[this.readStructure()];
            switch (item) {
                case 3: {
                    this.processElement(this.readStructureString(), this.readStructureString(), this.readStructureString());
                    break;
                }
                case 4: {
                    String p = this.readStructureString();
                    String u = this.readStructureString();
                    String ln = this.readStructureString();
                    this.processElement(u, ln, this.getQName(p, ln));
                    break;
                }
                case 5: {
                    String u = this.readStructureString();
                    String ln = this.readStructureString();
                    this.processElement(u, ln, ln);
                    break;
                }
                case 6: {
                    String ln = this.readStructureString();
                    this.processElement("", ln, ln);
                    break;
                }
                case 7: {
                    int length = this.readStructure();
                    int start = this.readContentCharactersBuffer(length);
                    this._contentHandler.characters(this._contentCharactersBuffer, start, length);
                    break;
                }
                case 8: {
                    int length = this.readStructure() << 8 | this.readStructure();
                    int start = this.readContentCharactersBuffer(length);
                    this._contentHandler.characters(this._contentCharactersBuffer, start, length);
                    break;
                }
                case 9: {
                    char[] ch = this.readContentCharactersCopy();
                    this._contentHandler.characters(ch, 0, ch.length);
                    break;
                }
                case 10: {
                    String s = this.readContentString();
                    this._contentHandler.characters(s.toCharArray(), 0, s.length());
                    break;
                }
                case 11: {
                    CharSequence c = (CharSequence)this.readContentObject();
                    String s = ((Object)c).toString();
                    this._contentHandler.characters(s.toCharArray(), 0, s.length());
                    break;
                }
                case 12: {
                    int length = this.readStructure();
                    int start = this.readContentCharactersBuffer(length);
                    this.processComment(this._contentCharactersBuffer, start, length);
                    break;
                }
                case 13: {
                    int length = this.readStructure() << 8 | this.readStructure();
                    int start = this.readContentCharactersBuffer(length);
                    this.processComment(this._contentCharactersBuffer, start, length);
                    break;
                }
                case 14: {
                    char[] ch = this.readContentCharactersCopy();
                    this.processComment(ch, 0, ch.length);
                    break;
                }
                case 104: {
                    this.processComment(this.readContentString());
                    break;
                }
                case 16: {
                    this.processProcessingInstruction(this.readStructureString(), this.readStructureString());
                    break;
                }
                case 17: {
                    break;
                }
                default: {
                    throw this.reportFatalError("Illegal state for child of EII: " + item);
                }
            }
        } while (item != 17);
        this._contentHandler.endElement(uri, localName, qName);
        if (hasNamespaceAttributes) {
            this.processEndPrefixMapping();
        }
    }

    private void processEndPrefixMapping() throws SAXException {
        int end = this._namespaceAttributesStack[--this._namespaceAttributesStackIndex];
        int start = this._namespaceAttributesStackIndex > 0 ? this._namespaceAttributesStack[this._namespaceAttributesStackIndex] : 0;
        for (int i = end - 1; i >= start; --i) {
            this._contentHandler.endPrefixMapping(this._namespacePrefixes[i]);
        }
        this._namespacePrefixesIndex = start;
    }

    private int processNamespaceAttributes(int item) throws SAXException {
        do {
            switch (_niiStateTable[item]) {
                case 1: {
                    this.processNamespaceAttribute("", "");
                    break;
                }
                case 2: {
                    this.processNamespaceAttribute(this.readStructureString(), "");
                    break;
                }
                case 3: {
                    this.processNamespaceAttribute(this.readStructureString(), this.readStructureString());
                    break;
                }
                case 4: {
                    this.processNamespaceAttribute("", this.readStructureString());
                    break;
                }
                default: {
                    throw this.reportFatalError("Illegal state: " + item);
                }
            }
            this.readStructure();
        } while (((item = this.peekStructure()) & 0xF0) == 64);
        this.cacheNamespacePrefixIndex();
        return item;
    }

    private void processAttributes(int item) throws SAXException {
        do {
            switch (_aiiStateTable[item]) {
                case 1: {
                    this._attributes.addAttributeWithQName(this.readStructureString(), this.readStructureString(), this.readStructureString(), this.readStructureString(), this.readContentString());
                    break;
                }
                case 2: {
                    String p = this.readStructureString();
                    String u = this.readStructureString();
                    String ln = this.readStructureString();
                    this._attributes.addAttributeWithQName(u, ln, this.getQName(p, ln), this.readStructureString(), this.readContentString());
                    break;
                }
                case 3: {
                    String u = this.readStructureString();
                    String ln = this.readStructureString();
                    this._attributes.addAttributeWithQName(u, ln, ln, this.readStructureString(), this.readContentString());
                    break;
                }
                case 4: {
                    String ln = this.readStructureString();
                    this._attributes.addAttributeWithQName("", ln, ln, this.readStructureString(), this.readContentString());
                    break;
                }
                default: {
                    throw this.reportFatalError("Illegal state: " + item);
                }
            }
            this.readStructure();
        } while (((item = this.peekStructure()) & 0xF0) == 48);
    }

    private void processNamespaceAttribute(String prefix, String uri) throws SAXException {
        this._contentHandler.startPrefixMapping(prefix, uri);
        if (this._namespacePrefixesFeature) {
            if (prefix != "") {
                this._attributes.addAttributeWithQName("http://www.w3.org/2000/xmlns/", prefix, this.getQName("xmlns", prefix), "CDATA", uri);
            } else {
                this._attributes.addAttributeWithQName("http://www.w3.org/2000/xmlns/", "xmlns", "xmlns", "CDATA", uri);
            }
        }
        this.cacheNamespacePrefix(prefix);
    }

    private void cacheNamespacePrefix(String prefix) {
        if (this._namespacePrefixesIndex == this._namespacePrefixes.length) {
            String[] namespaceAttributes = new String[this._namespacePrefixesIndex * 3 / 2 + 1];
            System.arraycopy(this._namespacePrefixes, 0, namespaceAttributes, 0, this._namespacePrefixesIndex);
            this._namespacePrefixes = namespaceAttributes;
        }
        this._namespacePrefixes[this._namespacePrefixesIndex++] = prefix;
    }

    private void cacheNamespacePrefixIndex() {
        if (this._namespaceAttributesStackIndex == this._namespaceAttributesStack.length) {
            int[] namespaceAttributesStack = new int[this._namespaceAttributesStackIndex * 3 / 2 + 1];
            System.arraycopy(this._namespaceAttributesStack, 0, namespaceAttributesStack, 0, this._namespaceAttributesStackIndex);
            this._namespaceAttributesStack = namespaceAttributesStack;
        }
        this._namespaceAttributesStack[this._namespaceAttributesStackIndex++] = this._namespacePrefixesIndex;
    }

    private void processComment(String s) throws SAXException {
        this.processComment(s.toCharArray(), 0, s.length());
    }

    private void processComment(char[] ch, int start, int length) throws SAXException {
        this._lexicalHandler.comment(ch, start, length);
    }

    private void processProcessingInstruction(String target, String data) throws SAXException {
        this._contentHandler.processingInstruction(target, data);
    }
}

