/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.types;

import com.sun.xml.fastinfoset.algorithm.BuiltInEncodingAlgorithm;
import com.sun.xml.fastinfoset.algorithm.BuiltInEncodingAlgorithmFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum XSDataType {
    _UNSPECIFIED_,
    ANYTYPE,
    ANYSIMPLETYPE,
    DURATION("0123456789-:TZ "),
    DATETIME("0123456789-:TZ "),
    TIME("0123456789-:TZ "),
    DATE("0123456789-:TZ "),
    GYEARMONTH("0123456789-:TZ "),
    GYEAR("0123456789-:TZ "),
    GMONTHDAY("0123456789-:TZ "),
    GDAY("0123456789-:TZ "),
    GMONTH("0123456789-:TZ "),
    STRING,
    NORMALIZEDSTRING,
    TOKEN,
    LANGUAGE,
    NAME,
    NCNAME,
    ID,
    IDREF,
    IDREFS,
    ENTITY,
    ENTITIES,
    NMTOKEN,
    NMTOKENS,
    BOOLEAN(5, (BuiltInEncodingAlgorithm)BuiltInEncodingAlgorithmFactory.booleanEncodingAlgorithm),
    BASE64BINARY(1, (BuiltInEncodingAlgorithm)BuiltInEncodingAlgorithmFactory.base64EncodingAlgorithm),
    HEXBINARY(0, (BuiltInEncodingAlgorithm)BuiltInEncodingAlgorithmFactory.hexadecimalEncodingAlgorithm),
    FLOAT(6, (BuiltInEncodingAlgorithm)BuiltInEncodingAlgorithmFactory.floatEncodingAlgorithm),
    DECIMAL("0123456789-+.E "),
    INTEGER("0123456789-+.E "),
    NONPOSITIVEINTEGER("0123456789-+.E "),
    NEGATIVEINTEGER("0123456789-+.E "),
    LONG(4, (BuiltInEncodingAlgorithm)BuiltInEncodingAlgorithmFactory.longEncodingAlgorithm),
    INT(3, (BuiltInEncodingAlgorithm)BuiltInEncodingAlgorithmFactory.intEncodingAlgorithm),
    SHORT(2, (BuiltInEncodingAlgorithm)BuiltInEncodingAlgorithmFactory.shortEncodingAlgorithm),
    BYTE,
    NONNEGATIVEINTEGER("0123456789-+.E "),
    UNSIGNEDLONG(4, (BuiltInEncodingAlgorithm)BuiltInEncodingAlgorithmFactory.longEncodingAlgorithm),
    UNSIGNEDINT(3, (BuiltInEncodingAlgorithm)BuiltInEncodingAlgorithmFactory.intEncodingAlgorithm),
    UNSIGNEDSHORT(2, (BuiltInEncodingAlgorithm)BuiltInEncodingAlgorithmFactory.shortEncodingAlgorithm),
    UNSIGNEDBYTE,
    POSITIVEINTEGER("0123456789-+.E "),
    DOUBLE(7, (BuiltInEncodingAlgorithm)BuiltInEncodingAlgorithmFactory.doubleEncodingAlgorithm),
    ANYURI,
    QNAME,
    NOTATION;

    public final int encodingAlgorithmId;
    public final BuiltInEncodingAlgorithm encodingAlgorithm;
    public final String alphabet;

    private XSDataType() {
        this.encodingAlgorithmId = -1;
        this.encodingAlgorithm = null;
        this.alphabet = null;
    }

    private XSDataType(int id, BuiltInEncodingAlgorithm algorithm) {
        this.encodingAlgorithmId = id;
        this.encodingAlgorithm = algorithm;
        this.alphabet = null;
    }

    private XSDataType(String s) {
        this.encodingAlgorithmId = -1;
        this.encodingAlgorithm = null;
        this.alphabet = s;
    }

    public static XSDataType create(String s) {
        try {
            return XSDataType.valueOf(s.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return _UNSPECIFIED_;
        }
    }
}

