/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.thread;

import com.sun.jini.constants.TimeConstants;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class RetryTask
implements TaskManager.Task,
TimeConstants {
    private TaskManager manager;
    private RetryTime retry;
    private boolean cancelled;
    private boolean complete;
    private WakeupManager.Ticket ticket;
    private long startTime;
    private int attempt;
    private WakeupManager wakeup;
    private static final long[] delays;
    private static final Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public RetryTask(TaskManager manager, WakeupManager wakeupManager) {
        this.manager = manager;
        this.wakeup = wakeupManager;
        this.reset();
    }

    public abstract boolean tryOnce();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        RetryTask retryTask = this;
        synchronized (retryTask) {
            if (this.cancelled) {
                return;
            }
        }
        boolean success = this.tryOnce();
        RetryTask retryTask2 = this;
        synchronized (retryTask2) {
            if (!success) {
                ++this.attempt;
                long at = this.retryTime();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "retry of {0} in {1} ms", new Object[]{this, new Long(at - System.currentTimeMillis())});
                }
                if (this.retry == null) {
                    this.retry = new RetryTime();
                }
                this.ticket = this.wakeup.schedule(at, this.retry);
            } else {
                this.complete = true;
                this.notifyAll();
            }
        }
    }

    public long retryTime() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError((Object)"thread does not hold lock");
        }
        int index = this.attempt < delays.length ? this.attempt : delays.length - 1;
        return delays[index] + System.currentTimeMillis();
    }

    public synchronized long startTime() {
        return this.startTime;
    }

    public synchronized int attempt() {
        return this.attempt;
    }

    public synchronized void cancel() {
        this.cancelled = true;
        if (this.ticket != null) {
            this.wakeup.cancel(this.ticket);
        }
        this.notifyAll();
    }

    public synchronized boolean cancelled() {
        return this.cancelled;
    }

    public synchronized boolean complete() {
        return this.complete;
    }

    public synchronized boolean waitFor() throws InterruptedException {
        while (!this.cancelled && !this.complete) {
            this.wait();
        }
        return this.complete;
    }

    public synchronized void reset() {
        this.cancel();
        this.startTime = System.currentTimeMillis();
        this.cancelled = false;
        this.complete = false;
        this.ticket = null;
        this.attempt = 0;
    }

    static {
        $assertionsDisabled = !RetryTask.class.desiredAssertionStatus();
        delays = new long[]{0L, 1000L, 5000L, 10000L, 60000L, 60000L, 300000L};
        logger = Logger.getLogger("com.sun.jini.thread.RetryTask");
    }

    private class RetryTime
    implements Runnable {
        private RetryTime() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            RetryTask retryTask = RetryTask.this;
            synchronized (retryTask) {
                RetryTask.this.ticket = null;
            }
            RetryTask.this.manager.add(RetryTask.this);
        }
    }
}

