/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.samples.atomserver.resources;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;

public class FileStore {
    public static final FileStore FS = new FileStore();

    public String getNextId() {
        return UUID.randomUUID().toString();
    }

    public boolean exists(String path) {
        return new File(path).exists();
    }

    public InputStream getFileContents(String path) {
        try {
            return new BufferedInputStream(new FileInputStream(path));
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public OutputStream getFileOutputStream(String path) throws IOException {
        File f = new File(path);
        f.getParentFile().mkdirs();
        return new BufferedOutputStream(new FileOutputStream(f));
    }

    public void deleteFile(String path) {
        new File(path).delete();
    }

    public void deleteDirectory(String path) {
        File dir = new File(path);
        if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
        dir.delete();
    }
}

