/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.test.framework.spi.container.inmemory;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.container.filter.LoggingFilter;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.WebApplicationFactory;
import com.sun.jersey.test.framework.AppDescriptor;
import com.sun.jersey.test.framework.LowLevelAppDescriptor;
import com.sun.jersey.test.framework.impl.container.inmemory.TestResourceClientHandler;
import com.sun.jersey.test.framework.spi.container.TestContainer;
import com.sun.jersey.test.framework.spi.container.TestContainerFactory;
import java.net.URI;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.core.UriBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryTestContainerFactory
implements TestContainerFactory {
    public Class<LowLevelAppDescriptor> supports() {
        return LowLevelAppDescriptor.class;
    }

    @Override
    public TestContainer create(URI baseUri, AppDescriptor ad) {
        if (!(ad instanceof LowLevelAppDescriptor)) {
            throw new IllegalArgumentException("The application descriptor must be an instance of LowLevelAppDescriptor");
        }
        return new InMemoryTestContainer(baseUri, (LowLevelAppDescriptor)ad);
    }

    private static class InMemoryTestContainer
    implements TestContainer {
        private static final Logger LOGGER = Logger.getLogger(InMemoryTestContainer.class.getName());
        final URI baseUri;
        final ResourceConfig resourceConfig;
        final WebApplication webApp;

        private InMemoryTestContainer(URI baseUri, LowLevelAppDescriptor ad) {
            this.baseUri = UriBuilder.fromUri((URI)baseUri).build(new Object[0]);
            LOGGER.info("Creating low level InMemory test container configured at the base URI " + this.baseUri);
            this.resourceConfig = ad.getResourceConfig();
            this.resourceConfig.getProperties().put("com.sun.jersey.spi.container.ContainerRequestFilters", LoggingFilter.class.getName());
            this.resourceConfig.getProperties().put("com.sun.jersey.spi.container.ContainerResponseFilters", LoggingFilter.class.getName());
            this.webApp = this.initiateWebApplication(this.resourceConfig);
        }

        public Client getClient() {
            DefaultClientConfig clientConfig = null;
            Set providerSingletons = this.resourceConfig.getProviderSingletons();
            if (providerSingletons.size() > 0) {
                clientConfig = new DefaultClientConfig();
                for (Object providerSingleton : providerSingletons) {
                    clientConfig.getSingletons().add(providerSingleton);
                }
            }
            Client client = clientConfig == null ? new Client((ClientHandler)new TestResourceClientHandler(this.baseUri, this.webApp)) : new Client((ClientHandler)new TestResourceClientHandler(this.baseUri, this.webApp), (ClientConfig)clientConfig);
            return client;
        }

        public URI getBaseUri() {
            return this.baseUri;
        }

        public void start() {
            if (!this.webApp.isInitiated()) {
                LOGGER.info("Starting low level InMemory test container");
                this.webApp.initiate(this.resourceConfig);
            }
        }

        public void stop() {
            if (this.webApp.isInitiated()) {
                LOGGER.info("Stopping low level InMemory test container");
                this.webApp.destroy();
            }
        }

        private WebApplication initiateWebApplication(ResourceConfig rc) {
            WebApplication webapp = WebApplicationFactory.createWebApplication();
            return webapp;
        }
    }
}

