/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.istack.maven;

import com.oracle.istack.maven.CommonLogger;
import com.oracle.istack.maven.ImportPropertiesMojo;
import com.oracle.istack.maven.ManualWagonProvider;
import com.oracle.istack.maven.PropertyResolver;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Repository;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.internal.MavenServiceLocator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.connector.wagon.WagonProvider;
import org.sonatype.aether.connector.wagon.WagonRepositoryConnectorFactory;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.spi.connector.RepositoryConnectorFactory;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="import-properties")
public class ImportPropertiesExtension
extends AbstractMavenLifecycleParticipant {
    @Requirement
    private org.codehaus.plexus.logging.Logger logger;
    private Properties projectProperties = null;

    public void afterProjectsRead(MavenSession session) {
        MavenProject project = session.getCurrentProject();
        try {
            this.projectProperties = project.getProperties();
            MavenProject bomProject = project;
            while (!bomProject.getArtifactId().endsWith("-bom")) {
                bomProject = bomProject.getParent();
            }
            if (!bomProject.getArtifactId().endsWith("-bom")) {
                this.logger.warn("No BOM found in project hierarchy.");
                return;
            }
            this.logger.warn("Found BOM project: " + bomProject.getArtifactId());
            MavenServiceLocator locator = new MavenServiceLocator();
            locator.setServices(WagonProvider.class, (Object[])new WagonProvider[]{new ManualWagonProvider()});
            locator.addService(RepositoryConnectorFactory.class, WagonRepositoryConnectorFactory.class);
            RepositorySystem repoSystem = (RepositorySystem)locator.getService(RepositorySystem.class);
            List repos = project.getRepositories();
            ArrayList<RemoteRepository> remoteRepos = new ArrayList<RemoteRepository>();
            for (Repository r : repos) {
                RemoteRepository rr = new RemoteRepository(r.getId(), null, r.getUrl());
                remoteRepos.add(rr);
            }
            bomProject.getRepositories();
            PropertyResolver resolver = new PropertyResolver(new CommonLogger(this.logger), this.projectProperties, session.getRepositorySession(), repoSystem, remoteRepos);
            resolver.resolveProperties(bomProject);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ImportPropertiesMojo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ImportPropertiesMojo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (XmlPullParserException ex) {
            Logger.getLogger(ImportPropertiesMojo.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

