/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.log4j.queue;

import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;

public class CostBoundedConcurrentQueue<T> {
    private LinkedBlockingQueue<T> queue;
    private CostAssigner<T> costAssigner;
    private long capacity = 0L;
    private AtomicLong cost = new AtomicLong(0L);

    public CostBoundedConcurrentQueue(long capacity, CostAssigner<T> costAssigner) {
        this.queue = new LinkedBlockingQueue();
        this.costAssigner = costAssigner;
        this.capacity = capacity;
    }

    public long cost() {
        return this.cost.get();
    }

    public int size() {
        return this.queue.size();
    }

    public int drainTo(Collection<T> collection) {
        assert (collection.isEmpty());
        int elementsDrained = this.queue.drainTo(collection);
        for (T e : collection) {
            this.cost.addAndGet(-this.costAssigner.cost(e));
        }
        return elementsDrained;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(T e) {
        long eCost = this.costAssigner.cost(e);
        CostBoundedConcurrentQueue costBoundedConcurrentQueue = this;
        synchronized (costBoundedConcurrentQueue) {
            if (eCost + this.cost.get() > this.capacity) {
                return false;
            }
            this.cost.addAndGet(eCost);
        }
        return this.queue.add(e);
    }

    public T poll() {
        T e = this.queue.poll();
        if (e != null) {
            this.cost.addAndGet(-this.costAssigner.cost(e));
        }
        return e;
    }

    public static interface CostAssigner<T> {
        public long cost(T var1);
    }
}

