/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.log4j.queue;

import com.sumologic.log4j.queue.BufferWithEviction;
import com.sumologic.log4j.queue.CostBoundedConcurrentQueue;
import java.util.Collection;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class BufferWithFifoEviction<T>
extends BufferWithEviction<T> {
    private static final Logger logger = StatusLogger.getLogger();
    private CostBoundedConcurrentQueue<T> queue;
    private CostBoundedConcurrentQueue.CostAssigner<T> costAssigner;

    public BufferWithFifoEviction(long capacity, CostBoundedConcurrentQueue.CostAssigner<T> costAssigner) {
        super(capacity);
        if (costAssigner == null) {
            throw new IllegalArgumentException("CostAssigner cannot be null");
        }
        if (capacity <= 0L) {
            throw new IllegalArgumentException("Capacity must be at least 1");
        }
        this.queue = new CostBoundedConcurrentQueue<T>(capacity, costAssigner);
        this.costAssigner = costAssigner;
    }

    @Override
    protected T evict() {
        return this.queue.poll();
    }

    @Override
    protected boolean evict(long cost) {
        int numEvicted = 0;
        if (cost > this.getCapacity()) {
            return false;
        }
        long targetCost = this.getCapacity() - cost;
        do {
            ++numEvicted;
            this.evict();
        } while (this.queue.cost() > targetCost);
        if (numEvicted > 0) {
            logger.warn("Evicted " + numEvicted + " messages from buffer");
        }
        return true;
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public int drainTo(Collection<T> collection) {
        return this.queue.drainTo(collection);
    }

    @Override
    public synchronized boolean add(T element) {
        boolean wasSuccessful = this.queue.offer(element);
        if (!wasSuccessful) {
            this.evict(this.costAssigner.cost(element));
            return this.queue.offer(element);
        }
        return true;
    }
}

