/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.log4j.http;

public class ProxySettings {
    public static final String NTLM_AUTH = "ntlm";
    public static final String BASIC_AUTH = "basic";
    private String hostname = null;
    private Integer port = null;
    private String authType = null;
    private String username = null;
    private String password = null;
    private String domain = null;

    public ProxySettings(String hostname, Integer port, String authType, String username, String password, String domain) {
        this.hostname = hostname;
        this.port = port;
        this.authType = authType;
        this.username = username;
        this.password = password;
        this.domain = domain;
        this.normalize();
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
        this.normalize();
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
        this.normalize();
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
        this.normalize();
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
        this.normalize();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
        this.normalize();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
        this.normalize();
    }

    private void normalize() {
        if (this.username != null && this.authType == null) {
            this.authType = BASIC_AUTH;
        }
    }

    public void validate() {
        if (this.hostname != null) {
            if (this.port == null) {
                throw new IllegalArgumentException("port property must be set");
            }
            if (this.authType != null && (this.username == null || this.password == null)) {
                throw new IllegalArgumentException("username and password properties must be set if authType property is set");
            }
            if (NTLM_AUTH.equals(this.authType) && this.domain == null) {
                throw new IllegalArgumentException("domain property must be set if authType property is ntlm");
            }
            if (this.authType != null && !NTLM_AUTH.equals(this.authType) && !BASIC_AUTH.equals(this.authType)) {
                throw new IllegalArgumentException("authType type not supported: " + this.authType);
            }
        }
    }
}

