/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.log4j.http;

import com.sumologic.log4j.http.ProxySettings;
import java.net.InetAddress;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public class HttpProxySettingsCreator {
    private static final Logger logger = StatusLogger.getLogger();
    private ProxySettings proxySettings;

    public HttpProxySettingsCreator(ProxySettings proxySettings) {
        this.proxySettings = proxySettings;
    }

    private String hostname() {
        String host = "localhost";
        try {
            host = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            logger.error("Unable to obtain local hostname. Defaulting to localhost", (Throwable)e);
        }
        return host;
    }

    private CredentialsProvider createCredentialsProvider() {
        String username = this.proxySettings.getUsername();
        String password = this.proxySettings.getPassword();
        String domain = this.proxySettings.getDomain();
        if ("basic".equals(this.proxySettings.getAuthType())) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(this.proxySettings.getHostname(), this.proxySettings.getPort().intValue()), (Credentials)new UsernamePasswordCredentials(username, password));
            return credsProvider;
        }
        if ("ntlm".equals(this.proxySettings.getAuthType())) {
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(this.proxySettings.getHostname(), this.proxySettings.getPort().intValue()), (Credentials)new NTCredentials(username, password, this.hostname(), domain));
            return credsProvider;
        }
        throw new IllegalStateException("proxyAuth " + this.proxySettings.getAuthType() + " not supported!");
    }

    public void configureProxySettings(HttpClientBuilder builder) {
        this.proxySettings.validate();
        String proxyHost = this.proxySettings.getHostname();
        int proxyPort = this.proxySettings.getPort();
        String proxyAuth = this.proxySettings.getAuthType();
        if (proxyHost != null) {
            HttpHost host = new HttpHost(proxyHost, proxyPort);
            builder.setProxy(host);
            if (proxyAuth != null) {
                CredentialsProvider credsProvider = this.createCredentialsProvider();
                builder.setDefaultCredentialsProvider(credsProvider);
            }
        }
    }
}

