/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.log4j.aggregation;

import com.sumologic.log4j.http.SumoBufferFlushingTask;
import com.sumologic.log4j.http.SumoHttpSender;
import com.sumologic.log4j.queue.BufferWithEviction;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SumoBufferFlusher {
    private SumoBufferFlushingTask flushingTask;
    private ScheduledFuture future;
    private ScheduledExecutorService executor;
    private long flushingAccuracy;

    public SumoBufferFlusher(long flushingAccuracy, long messagesPerRequest, long maxFlushInterval, String sourceName, SumoHttpSender sender, BufferWithEviction<String> buffer) {
        this.flushingAccuracy = flushingAccuracy;
        this.flushingTask = new SumoBufferFlushingTask(buffer);
        this.flushingTask.setMessagesPerRequest(messagesPerRequest);
        this.flushingTask.setMaxFlushInterval(maxFlushInterval);
        this.flushingTask.setName(sourceName);
        this.flushingTask.setSender(sender);
    }

    public void start() {
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName("SumoBufferFlusherThread");
                thread.setDaemon(true);
                return thread;
            }
        });
        this.future = this.executor.scheduleAtFixedRate(this.flushingTask, 0L, this.flushingAccuracy, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }
}

