/*
 * Decompiled with CFR 0.152.
 */
package com.sumologic.log4j.aggregation;

import com.sumologic.log4j.queue.BufferWithEviction;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BufferFlushingTask<In, Out>
implements Runnable {
    private static final Logger logger = StatusLogger.getLogger();
    private long timeOfLastFlush = System.currentTimeMillis();
    private BufferWithEviction<In> messageQueue;

    private boolean needsFlushing() {
        long currentTime = System.currentTimeMillis();
        long dateOfNextFlush = this.timeOfLastFlush + this.getMaxFlushInterval();
        return (long)this.messageQueue.size() >= this.getMessagesPerRequest() || currentTime >= dateOfNextFlush;
    }

    private void flushAndSend() {
        ArrayList messages = new ArrayList(this.messageQueue.size());
        this.messageQueue.drainTo(messages);
        if (messages.size() > 0) {
            logger.debug(String.format("%s - Flushing and sending out %d messages (%d messages left)", new Date(), messages.size(), this.messageQueue.size()));
            Out body = this.aggregate(messages);
            this.sendOut(body, this.getName());
            this.timeOfLastFlush = System.currentTimeMillis();
        }
    }

    protected abstract long getMaxFlushInterval();

    protected abstract long getMessagesPerRequest();

    protected abstract String getName();

    protected BufferFlushingTask(BufferWithEviction<In> messageQueue) {
        this.messageQueue = messageQueue;
    }

    protected abstract Out aggregate(List<In> var1);

    protected abstract void sendOut(Out var1, String var2);

    @Override
    public void run() {
        if (this.needsFlushing()) {
            try {
                this.flushAndSend();
            }
            catch (Exception e) {
                logger.warn("Exception while attempting to flush and send", (Throwable)e);
            }
        }
    }
}

