/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.v2.core;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.stripe.StripeClient;
import com.stripe.StripeContext;
import com.stripe.events.UnknownEventNotification;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeObject;
import com.stripe.model.v2.EventNotificationClassLookup;
import com.stripe.model.v2.core.Event;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiResource;
import com.stripe.net.RawRequestOptions;
import com.stripe.net.StripeResponse;
import java.time.Instant;
import lombok.Generated;

public abstract class EventNotification {
    @SerializedName(value="id")
    public String id;
    @SerializedName(value="type")
    public String type;
    @SerializedName(value="created")
    public Instant created;
    @SerializedName(value="livemode")
    public Boolean livemode;
    @SerializedName(value="context")
    public StripeContext context;
    @SerializedName(value="reason")
    public Reason reason;
    protected transient StripeClient client;

    public static EventNotification fromJson(String payload, StripeClient client) {
        JsonObject jsonObject = ((JsonObject)ApiResource.GSON.fromJson(payload, JsonObject.class)).getAsJsonObject();
        Class<? extends EventNotification> cls = EventNotificationClassLookup.eventClassLookup.get(jsonObject.get("type").getAsString());
        if (cls == null) {
            cls = UnknownEventNotification.class;
        }
        EventNotification e = (EventNotification)ApiResource.GSON.fromJson(payload, cls);
        e.client = client;
        return e;
    }

    private RawRequestOptions getRequestOptions() {
        if (this.context == null) {
            return null;
        }
        return new RawRequestOptions.RawRequestOptionsBuilder().setStripeContext(this.context.toString()).build();
    }

    protected Event fetchEvent() throws StripeException {
        StripeResponse response = this.client.rawRequest(ApiResource.RequestMethod.GET, String.format("/v2/core/events/%s", this.id), null, this.getRequestOptions());
        return (Event)this.client.deserialize((String)response.body(), ApiMode.V2);
    }

    protected StripeObject fetchRelatedObject(Event.RelatedObject relatedObject) throws StripeException {
        if (relatedObject == null) {
            return null;
        }
        String relativeUrl = relatedObject.getUrl();
        StripeResponse response = this.client.rawRequest(ApiResource.RequestMethod.GET, relativeUrl, null, this.getRequestOptions());
        return this.client.deserialize((String)response.body(), ApiMode.getMode(relativeUrl));
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Instant getCreated() {
        return this.created;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public StripeContext getContext() {
        return this.context;
    }

    @Generated
    public Reason getReason() {
        return this.reason;
    }

    public static class Reason {
        @SerializedName(value="request")
        Request request;
        @SerializedName(value="type")
        String type;

        @Generated
        public Request getRequest() {
            return this.request;
        }

        @Generated
        public String getType() {
            return this.type;
        }
    }

    public static class Request {
        @SerializedName(value="id")
        String id;
        @SerializedName(value="idempotency_key")
        String idempotencyKey;

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getIdempotencyKey() {
            return this.idempotencyKey;
        }
    }
}

