/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CaseInsensitiveMap<V>
extends AbstractMap<String, V>
implements Map<String, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 107333939521129358L;
    private Map<String, Map.Entry<String, V>> store = new HashMap<String, Map.Entry<String, V>>();

    public static <V> CaseInsensitiveMap<V> of(Map<String, V> map) {
        if (map == null) {
            return null;
        }
        CaseInsensitiveMap<V> ciMap = new CaseInsensitiveMap<V>();
        ciMap.putAll(map);
        return ciMap;
    }

    @Override
    public boolean containsKey(Object key) {
        String keyLower = CaseInsensitiveMap.convertKey(key);
        return this.store.containsKey(keyLower);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public V get(Object key) {
        String keyLower = CaseInsensitiveMap.convertKey(key);
        Map.Entry<String, V> entry = this.store.get(keyLower);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    @Override
    public V put(String key, V value) {
        String keyLower = CaseInsensitiveMap.convertKey(key);
        this.store.put(keyLower, new AbstractMap.SimpleEntry<String, V>(key, value));
        return value;
    }

    @Override
    public V remove(Object key) {
        String keyLower = CaseInsensitiveMap.convertKey(key);
        Map.Entry<String, V> entry = this.store.remove(keyLower);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.store.values().stream().map(entry -> (String)entry.getKey()).collect(Collectors.toSet());
    }

    @Override
    public Collection<V> values() {
        return this.store.values().stream().map(entry -> entry.getValue()).collect(Collectors.toList());
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.store.values().stream().collect(Collectors.toSet());
    }

    private static String convertKey(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof String) {
            return ((String)key).toLowerCase();
        }
        throw new IllegalArgumentException("key must be a String");
    }
}

