/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.issuing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.issuing.PersonalizationDesign;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.PersonalizationDesignCreateParams;
import com.stripe.param.issuing.PersonalizationDesignListParams;
import com.stripe.param.issuing.PersonalizationDesignRetrieveParams;
import com.stripe.param.issuing.PersonalizationDesignUpdateParams;
import java.lang.reflect.Type;

public final class PersonalizationDesignService
extends ApiService {
    public PersonalizationDesignService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<PersonalizationDesign> list(PersonalizationDesignListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<PersonalizationDesign> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<PersonalizationDesign> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<PersonalizationDesign> list(PersonalizationDesignListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/personalization_designs";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<PersonalizationDesign>>(){}.getType());
    }

    public PersonalizationDesign create(PersonalizationDesignCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public PersonalizationDesign create(PersonalizationDesignCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/personalization_designs";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PersonalizationDesign)this.request(request, (Type)((Object)PersonalizationDesign.class));
    }

    public PersonalizationDesign retrieve(String personalizationDesign, PersonalizationDesignRetrieveParams params) throws StripeException {
        return this.retrieve(personalizationDesign, params, null);
    }

    public PersonalizationDesign retrieve(String personalizationDesign, RequestOptions options) throws StripeException {
        return this.retrieve(personalizationDesign, null, options);
    }

    public PersonalizationDesign retrieve(String personalizationDesign) throws StripeException {
        return this.retrieve(personalizationDesign, null, null);
    }

    public PersonalizationDesign retrieve(String personalizationDesign, PersonalizationDesignRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/personalization_designs/%s", ApiResource.urlEncodeId(personalizationDesign));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (PersonalizationDesign)this.request(request, (Type)((Object)PersonalizationDesign.class));
    }

    public PersonalizationDesign update(String personalizationDesign, PersonalizationDesignUpdateParams params) throws StripeException {
        return this.update(personalizationDesign, params, null);
    }

    public PersonalizationDesign update(String personalizationDesign, RequestOptions options) throws StripeException {
        return this.update(personalizationDesign, null, options);
    }

    public PersonalizationDesign update(String personalizationDesign) throws StripeException {
        return this.update(personalizationDesign, null, null);
    }

    public PersonalizationDesign update(String personalizationDesign, PersonalizationDesignUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/personalization_designs/%s", ApiResource.urlEncodeId(personalizationDesign));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PersonalizationDesign)this.request(request, (Type)((Object)PersonalizationDesign.class));
    }
}

