/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.forwarding;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.forwarding.Request;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.forwarding.RequestCreateParams;
import com.stripe.param.forwarding.RequestListParams;
import com.stripe.param.forwarding.RequestRetrieveParams;
import java.lang.reflect.Type;

public final class RequestService
extends ApiService {
    public RequestService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Request> list(RequestListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Request> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Request> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Request> list(RequestListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/forwarding/requests";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Request>>(){}.getType());
    }

    public Request create(RequestCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Request create(RequestCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/forwarding/requests";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Request)this.request(request, (Type)((Object)Request.class));
    }

    public Request retrieve(String id, RequestRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public Request retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public Request retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public Request retrieve(String id, RequestRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/forwarding/requests/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Request)this.request(request, (Type)((Object)Request.class));
    }
}

