/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.WebhookEndpointCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.WebhookEndpointCreateParams;
import com.stripe.param.WebhookEndpointListParams;
import com.stripe.param.WebhookEndpointRetrieveParams;
import com.stripe.param.WebhookEndpointUpdateParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class WebhookEndpoint
extends ApiResource
implements HasId,
MetadataStore<WebhookEndpoint> {
    @SerializedName(value="api_version")
    String apiVersion;
    @SerializedName(value="application")
    String application;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="enabled_events")
    List<String> enabledEvents;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="secret")
    String secret;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="url")
    String url;

    public static WebhookEndpoint create(Map<String, Object> params) throws StripeException {
        return WebhookEndpoint.create(params, (RequestOptions)null);
    }

    public static WebhookEndpoint create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/webhook_endpoints";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (WebhookEndpoint)WebhookEndpoint.getGlobalResponseGetter().request(request, (Type)((Object)WebhookEndpoint.class));
    }

    public static WebhookEndpoint create(WebhookEndpointCreateParams params) throws StripeException {
        return WebhookEndpoint.create(params, (RequestOptions)null);
    }

    public static WebhookEndpoint create(WebhookEndpointCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/webhook_endpoints";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (WebhookEndpoint)WebhookEndpoint.getGlobalResponseGetter().request(request, (Type)((Object)WebhookEndpoint.class));
    }

    public WebhookEndpoint delete() throws StripeException {
        return this.delete(null, null);
    }

    public WebhookEndpoint delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public WebhookEndpoint delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public WebhookEndpoint delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/webhook_endpoints/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, params, options);
        return (WebhookEndpoint)this.getResponseGetter().request(request, (Type)((Object)WebhookEndpoint.class));
    }

    public static WebhookEndpointCollection list(Map<String, Object> params) throws StripeException {
        return WebhookEndpoint.list(params, (RequestOptions)null);
    }

    public static WebhookEndpointCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/webhook_endpoints";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (WebhookEndpointCollection)WebhookEndpoint.getGlobalResponseGetter().request(request, (Type)((Object)WebhookEndpointCollection.class));
    }

    public static WebhookEndpointCollection list(WebhookEndpointListParams params) throws StripeException {
        return WebhookEndpoint.list(params, (RequestOptions)null);
    }

    public static WebhookEndpointCollection list(WebhookEndpointListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/webhook_endpoints";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (WebhookEndpointCollection)WebhookEndpoint.getGlobalResponseGetter().request(request, (Type)((Object)WebhookEndpointCollection.class));
    }

    public static WebhookEndpoint retrieve(String webhookEndpoint) throws StripeException {
        return WebhookEndpoint.retrieve(webhookEndpoint, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static WebhookEndpoint retrieve(String webhookEndpoint, RequestOptions options) throws StripeException {
        return WebhookEndpoint.retrieve(webhookEndpoint, (Map<String, Object>)null, options);
    }

    public static WebhookEndpoint retrieve(String webhookEndpoint, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/webhook_endpoints/%s", ApiResource.urlEncodeId(webhookEndpoint));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (WebhookEndpoint)WebhookEndpoint.getGlobalResponseGetter().request(request, (Type)((Object)WebhookEndpoint.class));
    }

    public static WebhookEndpoint retrieve(String webhookEndpoint, WebhookEndpointRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/webhook_endpoints/%s", ApiResource.urlEncodeId(webhookEndpoint));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (WebhookEndpoint)WebhookEndpoint.getGlobalResponseGetter().request(request, (Type)((Object)WebhookEndpoint.class));
    }

    public WebhookEndpoint update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public WebhookEndpoint update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/webhook_endpoints/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (WebhookEndpoint)this.getResponseGetter().request(request, (Type)((Object)WebhookEndpoint.class));
    }

    public WebhookEndpoint update(WebhookEndpointUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public WebhookEndpoint update(WebhookEndpointUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/webhook_endpoints/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (WebhookEndpoint)this.getResponseGetter().request(request, (Type)((Object)WebhookEndpoint.class));
    }

    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<String> getEnabledEvents() {
        return this.enabledEvents;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getSecret() {
        return this.secret;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Generated
    public void setApplication(String application) {
        this.application = application;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setEnabledEvents(List<String> enabledEvents) {
        this.enabledEvents = enabledEvents;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setSecret(String secret) {
        this.secret = secret;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebhookEndpoint)) {
            return false;
        }
        WebhookEndpoint other = (WebhookEndpoint)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$enabledEvents = this.getEnabledEvents();
        List<String> other$enabledEvents = other.getEnabledEvents();
        if (this$enabledEvents == null ? other$enabledEvents != null : !((Object)this$enabledEvents).equals(other$enabledEvents)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$secret = this.getSecret();
        String other$secret = other.getSecret();
        if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WebhookEndpoint;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $enabledEvents = this.getEnabledEvents();
        result = result * 59 + ($enabledEvents == null ? 43 : ((Object)$enabledEvents).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $secret = this.getSecret();
        result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

