/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.TransferReversal;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.TransferReversalCollectionCreateParams;
import com.stripe.param.TransferReversalCollectionListParams;
import com.stripe.param.TransferReversalCollectionRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;

public class TransferReversalCollection
extends StripeCollection<TransferReversal> {
    public TransferReversal create(Map<String, Object> params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public TransferReversal create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (TransferReversal)this.getResponseGetter().request(request, (Type)((Object)TransferReversal.class));
    }

    public TransferReversal create(TransferReversalCollectionCreateParams params) throws StripeException {
        return this.create(params, (RequestOptions)null);
    }

    public TransferReversal create(TransferReversalCollectionCreateParams params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (TransferReversal)this.getResponseGetter().request(request, (Type)((Object)TransferReversal.class));
    }

    public TransferReversalCollection list(Map<String, Object> params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public TransferReversalCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (TransferReversalCollection)this.getResponseGetter().request(request, (Type)((Object)TransferReversalCollection.class));
    }

    public TransferReversalCollection list(TransferReversalCollectionListParams params) throws StripeException {
        return this.list(params, (RequestOptions)null);
    }

    public TransferReversalCollection list(TransferReversalCollectionListParams params, RequestOptions options) throws StripeException {
        String path = this.getUrl();
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (TransferReversalCollection)this.getResponseGetter().request(request, (Type)((Object)TransferReversalCollection.class));
    }

    public TransferReversal retrieve(String id) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public TransferReversal retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, (Map<String, Object>)null, options);
    }

    public TransferReversal retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("%s/%s", this.getUrl(), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (TransferReversal)this.getResponseGetter().request(request, (Type)((Object)TransferReversal.class));
    }

    public TransferReversal retrieve(String id, TransferReversalCollectionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("%s/%s", this.getUrl(), ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (TransferReversal)this.getResponseGetter().request(request, (Type)((Object)TransferReversal.class));
    }
}

