/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BalanceTransactionSource;
import com.stripe.model.Charge;
import com.stripe.model.DisputeCollection;
import com.stripe.model.ExpandableField;
import com.stripe.model.File;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentIntent;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiMode;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.DisputeCloseParams;
import com.stripe.param.DisputeListParams;
import com.stripe.param.DisputeRetrieveParams;
import com.stripe.param.DisputeUpdateParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Dispute
extends ApiResource
implements MetadataStore<Dispute>,
BalanceTransactionSource {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="balance_transactions")
    List<BalanceTransaction> balanceTransactions;
    @SerializedName(value="charge")
    ExpandableField<Charge> charge;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="evidence")
    Evidence evidence;
    @SerializedName(value="evidence_details")
    EvidenceDetails evidenceDetails;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="is_charge_refundable")
    Boolean isChargeRefundable;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="network_reason_code")
    String networkReasonCode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payment_intent")
    ExpandableField<PaymentIntent> paymentIntent;
    @SerializedName(value="payment_method_details")
    PaymentMethodDetails paymentMethodDetails;
    @SerializedName(value="reason")
    String reason;
    @SerializedName(value="status")
    String status;

    public String getCharge() {
        return this.charge != null ? this.charge.getId() : null;
    }

    public void setCharge(String id) {
        this.charge = ApiResource.setExpandableFieldId(id, this.charge);
    }

    public Charge getChargeObject() {
        return this.charge != null ? this.charge.getExpanded() : null;
    }

    public void setChargeObject(Charge expandableObject) {
        this.charge = new ExpandableField<Charge>(expandableObject.getId(), expandableObject);
    }

    public String getPaymentIntent() {
        return this.paymentIntent != null ? this.paymentIntent.getId() : null;
    }

    public void setPaymentIntent(String id) {
        this.paymentIntent = ApiResource.setExpandableFieldId(id, this.paymentIntent);
    }

    public PaymentIntent getPaymentIntentObject() {
        return this.paymentIntent != null ? this.paymentIntent.getExpanded() : null;
    }

    public void setPaymentIntentObject(PaymentIntent expandableObject) {
        this.paymentIntent = new ExpandableField<PaymentIntent>(expandableObject.getId(), expandableObject);
    }

    public Dispute close() throws StripeException {
        return this.close((Map<String, Object>)null, (RequestOptions)null);
    }

    public Dispute close(RequestOptions options) throws StripeException {
        return this.close((Map<String, Object>)null, options);
    }

    public Dispute close(Map<String, Object> params) throws StripeException {
        return this.close(params, (RequestOptions)null);
    }

    public Dispute close(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/disputes/%s/close", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Dispute)this.getResponseGetter().request(request, (Type)((Object)Dispute.class));
    }

    public Dispute close(DisputeCloseParams params) throws StripeException {
        return this.close(params, (RequestOptions)null);
    }

    public Dispute close(DisputeCloseParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/disputes/%s/close", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Dispute)this.getResponseGetter().request(request, (Type)((Object)Dispute.class));
    }

    public static DisputeCollection list(Map<String, Object> params) throws StripeException {
        return Dispute.list(params, (RequestOptions)null);
    }

    public static DisputeCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/disputes";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (DisputeCollection)Dispute.getGlobalResponseGetter().request(request, (Type)((Object)DisputeCollection.class));
    }

    public static DisputeCollection list(DisputeListParams params) throws StripeException {
        return Dispute.list(params, (RequestOptions)null);
    }

    public static DisputeCollection list(DisputeListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/disputes";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (DisputeCollection)Dispute.getGlobalResponseGetter().request(request, (Type)((Object)DisputeCollection.class));
    }

    public static Dispute retrieve(String dispute) throws StripeException {
        return Dispute.retrieve(dispute, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Dispute retrieve(String dispute, RequestOptions options) throws StripeException {
        return Dispute.retrieve(dispute, (Map<String, Object>)null, options);
    }

    public static Dispute retrieve(String dispute, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/disputes/%s", ApiResource.urlEncodeId(dispute));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options, ApiMode.V1);
        return (Dispute)Dispute.getGlobalResponseGetter().request(request, (Type)((Object)Dispute.class));
    }

    public static Dispute retrieve(String dispute, DisputeRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/disputes/%s", ApiResource.urlEncodeId(dispute));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Dispute)Dispute.getGlobalResponseGetter().request(request, (Type)((Object)Dispute.class));
    }

    public Dispute update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Dispute update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/disputes/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options, ApiMode.V1);
        return (Dispute)this.getResponseGetter().request(request, (Type)((Object)Dispute.class));
    }

    public Dispute update(DisputeUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Dispute update(DisputeUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/disputes/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options, ApiMode.V1);
        return (Dispute)this.getResponseGetter().request(request, (Type)((Object)Dispute.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.charge, responseGetter);
        this.trySetResponseGetter(this.evidence, responseGetter);
        this.trySetResponseGetter(this.evidenceDetails, responseGetter);
        this.trySetResponseGetter(this.paymentIntent, responseGetter);
        this.trySetResponseGetter(this.paymentMethodDetails, responseGetter);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public List<BalanceTransaction> getBalanceTransactions() {
        return this.balanceTransactions;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Evidence getEvidence() {
        return this.evidence;
    }

    @Generated
    public EvidenceDetails getEvidenceDetails() {
        return this.evidenceDetails;
    }

    @Generated
    public Boolean getIsChargeRefundable() {
        return this.isChargeRefundable;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getNetworkReasonCode() {
        return this.networkReasonCode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PaymentMethodDetails getPaymentMethodDetails() {
        return this.paymentMethodDetails;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setBalanceTransactions(List<BalanceTransaction> balanceTransactions) {
        this.balanceTransactions = balanceTransactions;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setEvidence(Evidence evidence) {
        this.evidence = evidence;
    }

    @Generated
    public void setEvidenceDetails(EvidenceDetails evidenceDetails) {
        this.evidenceDetails = evidenceDetails;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIsChargeRefundable(Boolean isChargeRefundable) {
        this.isChargeRefundable = isChargeRefundable;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNetworkReasonCode(String networkReasonCode) {
        this.networkReasonCode = networkReasonCode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentMethodDetails(PaymentMethodDetails paymentMethodDetails) {
        this.paymentMethodDetails = paymentMethodDetails;
    }

    @Generated
    public void setReason(String reason) {
        this.reason = reason;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dispute)) {
            return false;
        }
        Dispute other = (Dispute)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$isChargeRefundable = this.getIsChargeRefundable();
        Boolean other$isChargeRefundable = other.getIsChargeRefundable();
        if (this$isChargeRefundable == null ? other$isChargeRefundable != null : !((Object)this$isChargeRefundable).equals(other$isChargeRefundable)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        List<BalanceTransaction> this$balanceTransactions = this.getBalanceTransactions();
        List<BalanceTransaction> other$balanceTransactions = other.getBalanceTransactions();
        if (this$balanceTransactions == null ? other$balanceTransactions != null : !((Object)this$balanceTransactions).equals(other$balanceTransactions)) {
            return false;
        }
        String this$charge = this.getCharge();
        String other$charge = other.getCharge();
        if (this$charge == null ? other$charge != null : !this$charge.equals(other$charge)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        Evidence this$evidence = this.getEvidence();
        Evidence other$evidence = other.getEvidence();
        if (this$evidence == null ? other$evidence != null : !((Object)this$evidence).equals(other$evidence)) {
            return false;
        }
        EvidenceDetails this$evidenceDetails = this.getEvidenceDetails();
        EvidenceDetails other$evidenceDetails = other.getEvidenceDetails();
        if (this$evidenceDetails == null ? other$evidenceDetails != null : !((Object)this$evidenceDetails).equals(other$evidenceDetails)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$networkReasonCode = this.getNetworkReasonCode();
        String other$networkReasonCode = other.getNetworkReasonCode();
        if (this$networkReasonCode == null ? other$networkReasonCode != null : !this$networkReasonCode.equals(other$networkReasonCode)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$paymentIntent = this.getPaymentIntent();
        String other$paymentIntent = other.getPaymentIntent();
        if (this$paymentIntent == null ? other$paymentIntent != null : !this$paymentIntent.equals(other$paymentIntent)) {
            return false;
        }
        PaymentMethodDetails this$paymentMethodDetails = this.getPaymentMethodDetails();
        PaymentMethodDetails other$paymentMethodDetails = other.getPaymentMethodDetails();
        if (this$paymentMethodDetails == null ? other$paymentMethodDetails != null : !((Object)this$paymentMethodDetails).equals(other$paymentMethodDetails)) {
            return false;
        }
        String this$reason = this.getReason();
        String other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !this$reason.equals(other$reason)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Dispute;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $isChargeRefundable = this.getIsChargeRefundable();
        result = result * 59 + ($isChargeRefundable == null ? 43 : ((Object)$isChargeRefundable).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        List<BalanceTransaction> $balanceTransactions = this.getBalanceTransactions();
        result = result * 59 + ($balanceTransactions == null ? 43 : ((Object)$balanceTransactions).hashCode());
        String $charge = this.getCharge();
        result = result * 59 + ($charge == null ? 43 : $charge.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        Evidence $evidence = this.getEvidence();
        result = result * 59 + ($evidence == null ? 43 : ((Object)$evidence).hashCode());
        EvidenceDetails $evidenceDetails = this.getEvidenceDetails();
        result = result * 59 + ($evidenceDetails == null ? 43 : ((Object)$evidenceDetails).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $networkReasonCode = this.getNetworkReasonCode();
        result = result * 59 + ($networkReasonCode == null ? 43 : $networkReasonCode.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $paymentIntent = this.getPaymentIntent();
        result = result * 59 + ($paymentIntent == null ? 43 : $paymentIntent.hashCode());
        PaymentMethodDetails $paymentMethodDetails = this.getPaymentMethodDetails();
        result = result * 59 + ($paymentMethodDetails == null ? 43 : ((Object)$paymentMethodDetails).hashCode());
        String $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : $reason.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Evidence
    extends StripeObject {
        @SerializedName(value="access_activity_log")
        String accessActivityLog;
        @SerializedName(value="billing_address")
        String billingAddress;
        @SerializedName(value="cancellation_policy")
        ExpandableField<File> cancellationPolicy;
        @SerializedName(value="cancellation_policy_disclosure")
        String cancellationPolicyDisclosure;
        @SerializedName(value="cancellation_rebuttal")
        String cancellationRebuttal;
        @SerializedName(value="customer_communication")
        ExpandableField<File> customerCommunication;
        @SerializedName(value="customer_email_address")
        String customerEmailAddress;
        @SerializedName(value="customer_name")
        String customerName;
        @SerializedName(value="customer_purchase_ip")
        String customerPurchaseIp;
        @SerializedName(value="customer_signature")
        ExpandableField<File> customerSignature;
        @SerializedName(value="duplicate_charge_documentation")
        ExpandableField<File> duplicateChargeDocumentation;
        @SerializedName(value="duplicate_charge_explanation")
        String duplicateChargeExplanation;
        @SerializedName(value="duplicate_charge_id")
        String duplicateChargeId;
        @SerializedName(value="product_description")
        String productDescription;
        @SerializedName(value="receipt")
        ExpandableField<File> receipt;
        @SerializedName(value="refund_policy")
        ExpandableField<File> refundPolicy;
        @SerializedName(value="refund_policy_disclosure")
        String refundPolicyDisclosure;
        @SerializedName(value="refund_refusal_explanation")
        String refundRefusalExplanation;
        @SerializedName(value="service_date")
        String serviceDate;
        @SerializedName(value="service_documentation")
        ExpandableField<File> serviceDocumentation;
        @SerializedName(value="shipping_address")
        String shippingAddress;
        @SerializedName(value="shipping_carrier")
        String shippingCarrier;
        @SerializedName(value="shipping_date")
        String shippingDate;
        @SerializedName(value="shipping_documentation")
        ExpandableField<File> shippingDocumentation;
        @SerializedName(value="shipping_tracking_number")
        String shippingTrackingNumber;
        @SerializedName(value="uncategorized_file")
        ExpandableField<File> uncategorizedFile;
        @SerializedName(value="uncategorized_text")
        String uncategorizedText;

        public String getCancellationPolicy() {
            return this.cancellationPolicy != null ? this.cancellationPolicy.getId() : null;
        }

        public void setCancellationPolicy(String id) {
            this.cancellationPolicy = ApiResource.setExpandableFieldId(id, this.cancellationPolicy);
        }

        public File getCancellationPolicyObject() {
            return this.cancellationPolicy != null ? this.cancellationPolicy.getExpanded() : null;
        }

        public void setCancellationPolicyObject(File expandableObject) {
            this.cancellationPolicy = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        public String getCustomerCommunication() {
            return this.customerCommunication != null ? this.customerCommunication.getId() : null;
        }

        public void setCustomerCommunication(String id) {
            this.customerCommunication = ApiResource.setExpandableFieldId(id, this.customerCommunication);
        }

        public File getCustomerCommunicationObject() {
            return this.customerCommunication != null ? this.customerCommunication.getExpanded() : null;
        }

        public void setCustomerCommunicationObject(File expandableObject) {
            this.customerCommunication = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        public String getCustomerSignature() {
            return this.customerSignature != null ? this.customerSignature.getId() : null;
        }

        public void setCustomerSignature(String id) {
            this.customerSignature = ApiResource.setExpandableFieldId(id, this.customerSignature);
        }

        public File getCustomerSignatureObject() {
            return this.customerSignature != null ? this.customerSignature.getExpanded() : null;
        }

        public void setCustomerSignatureObject(File expandableObject) {
            this.customerSignature = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        public String getDuplicateChargeDocumentation() {
            return this.duplicateChargeDocumentation != null ? this.duplicateChargeDocumentation.getId() : null;
        }

        public void setDuplicateChargeDocumentation(String id) {
            this.duplicateChargeDocumentation = ApiResource.setExpandableFieldId(id, this.duplicateChargeDocumentation);
        }

        public File getDuplicateChargeDocumentationObject() {
            return this.duplicateChargeDocumentation != null ? this.duplicateChargeDocumentation.getExpanded() : null;
        }

        public void setDuplicateChargeDocumentationObject(File expandableObject) {
            this.duplicateChargeDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        public String getReceipt() {
            return this.receipt != null ? this.receipt.getId() : null;
        }

        public void setReceipt(String id) {
            this.receipt = ApiResource.setExpandableFieldId(id, this.receipt);
        }

        public File getReceiptObject() {
            return this.receipt != null ? this.receipt.getExpanded() : null;
        }

        public void setReceiptObject(File expandableObject) {
            this.receipt = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        public String getRefundPolicy() {
            return this.refundPolicy != null ? this.refundPolicy.getId() : null;
        }

        public void setRefundPolicy(String id) {
            this.refundPolicy = ApiResource.setExpandableFieldId(id, this.refundPolicy);
        }

        public File getRefundPolicyObject() {
            return this.refundPolicy != null ? this.refundPolicy.getExpanded() : null;
        }

        public void setRefundPolicyObject(File expandableObject) {
            this.refundPolicy = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        public String getServiceDocumentation() {
            return this.serviceDocumentation != null ? this.serviceDocumentation.getId() : null;
        }

        public void setServiceDocumentation(String id) {
            this.serviceDocumentation = ApiResource.setExpandableFieldId(id, this.serviceDocumentation);
        }

        public File getServiceDocumentationObject() {
            return this.serviceDocumentation != null ? this.serviceDocumentation.getExpanded() : null;
        }

        public void setServiceDocumentationObject(File expandableObject) {
            this.serviceDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        public String getShippingDocumentation() {
            return this.shippingDocumentation != null ? this.shippingDocumentation.getId() : null;
        }

        public void setShippingDocumentation(String id) {
            this.shippingDocumentation = ApiResource.setExpandableFieldId(id, this.shippingDocumentation);
        }

        public File getShippingDocumentationObject() {
            return this.shippingDocumentation != null ? this.shippingDocumentation.getExpanded() : null;
        }

        public void setShippingDocumentationObject(File expandableObject) {
            this.shippingDocumentation = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        public String getUncategorizedFile() {
            return this.uncategorizedFile != null ? this.uncategorizedFile.getId() : null;
        }

        public void setUncategorizedFile(String id) {
            this.uncategorizedFile = ApiResource.setExpandableFieldId(id, this.uncategorizedFile);
        }

        public File getUncategorizedFileObject() {
            return this.uncategorizedFile != null ? this.uncategorizedFile.getExpanded() : null;
        }

        public void setUncategorizedFileObject(File expandableObject) {
            this.uncategorizedFile = new ExpandableField<File>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public String getAccessActivityLog() {
            return this.accessActivityLog;
        }

        @Generated
        public String getBillingAddress() {
            return this.billingAddress;
        }

        @Generated
        public String getCancellationPolicyDisclosure() {
            return this.cancellationPolicyDisclosure;
        }

        @Generated
        public String getCancellationRebuttal() {
            return this.cancellationRebuttal;
        }

        @Generated
        public String getCustomerEmailAddress() {
            return this.customerEmailAddress;
        }

        @Generated
        public String getCustomerName() {
            return this.customerName;
        }

        @Generated
        public String getCustomerPurchaseIp() {
            return this.customerPurchaseIp;
        }

        @Generated
        public String getDuplicateChargeExplanation() {
            return this.duplicateChargeExplanation;
        }

        @Generated
        public String getDuplicateChargeId() {
            return this.duplicateChargeId;
        }

        @Generated
        public String getProductDescription() {
            return this.productDescription;
        }

        @Generated
        public String getRefundPolicyDisclosure() {
            return this.refundPolicyDisclosure;
        }

        @Generated
        public String getRefundRefusalExplanation() {
            return this.refundRefusalExplanation;
        }

        @Generated
        public String getServiceDate() {
            return this.serviceDate;
        }

        @Generated
        public String getShippingAddress() {
            return this.shippingAddress;
        }

        @Generated
        public String getShippingCarrier() {
            return this.shippingCarrier;
        }

        @Generated
        public String getShippingDate() {
            return this.shippingDate;
        }

        @Generated
        public String getShippingTrackingNumber() {
            return this.shippingTrackingNumber;
        }

        @Generated
        public String getUncategorizedText() {
            return this.uncategorizedText;
        }

        @Generated
        public void setAccessActivityLog(String accessActivityLog) {
            this.accessActivityLog = accessActivityLog;
        }

        @Generated
        public void setBillingAddress(String billingAddress) {
            this.billingAddress = billingAddress;
        }

        @Generated
        public void setCancellationPolicyDisclosure(String cancellationPolicyDisclosure) {
            this.cancellationPolicyDisclosure = cancellationPolicyDisclosure;
        }

        @Generated
        public void setCancellationRebuttal(String cancellationRebuttal) {
            this.cancellationRebuttal = cancellationRebuttal;
        }

        @Generated
        public void setCustomerEmailAddress(String customerEmailAddress) {
            this.customerEmailAddress = customerEmailAddress;
        }

        @Generated
        public void setCustomerName(String customerName) {
            this.customerName = customerName;
        }

        @Generated
        public void setCustomerPurchaseIp(String customerPurchaseIp) {
            this.customerPurchaseIp = customerPurchaseIp;
        }

        @Generated
        public void setDuplicateChargeExplanation(String duplicateChargeExplanation) {
            this.duplicateChargeExplanation = duplicateChargeExplanation;
        }

        @Generated
        public void setDuplicateChargeId(String duplicateChargeId) {
            this.duplicateChargeId = duplicateChargeId;
        }

        @Generated
        public void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        @Generated
        public void setRefundPolicyDisclosure(String refundPolicyDisclosure) {
            this.refundPolicyDisclosure = refundPolicyDisclosure;
        }

        @Generated
        public void setRefundRefusalExplanation(String refundRefusalExplanation) {
            this.refundRefusalExplanation = refundRefusalExplanation;
        }

        @Generated
        public void setServiceDate(String serviceDate) {
            this.serviceDate = serviceDate;
        }

        @Generated
        public void setShippingAddress(String shippingAddress) {
            this.shippingAddress = shippingAddress;
        }

        @Generated
        public void setShippingCarrier(String shippingCarrier) {
            this.shippingCarrier = shippingCarrier;
        }

        @Generated
        public void setShippingDate(String shippingDate) {
            this.shippingDate = shippingDate;
        }

        @Generated
        public void setShippingTrackingNumber(String shippingTrackingNumber) {
            this.shippingTrackingNumber = shippingTrackingNumber;
        }

        @Generated
        public void setUncategorizedText(String uncategorizedText) {
            this.uncategorizedText = uncategorizedText;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Evidence)) {
                return false;
            }
            Evidence other = (Evidence)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$accessActivityLog = this.getAccessActivityLog();
            String other$accessActivityLog = other.getAccessActivityLog();
            if (this$accessActivityLog == null ? other$accessActivityLog != null : !this$accessActivityLog.equals(other$accessActivityLog)) {
                return false;
            }
            String this$billingAddress = this.getBillingAddress();
            String other$billingAddress = other.getBillingAddress();
            if (this$billingAddress == null ? other$billingAddress != null : !this$billingAddress.equals(other$billingAddress)) {
                return false;
            }
            String this$cancellationPolicy = this.getCancellationPolicy();
            String other$cancellationPolicy = other.getCancellationPolicy();
            if (this$cancellationPolicy == null ? other$cancellationPolicy != null : !this$cancellationPolicy.equals(other$cancellationPolicy)) {
                return false;
            }
            String this$cancellationPolicyDisclosure = this.getCancellationPolicyDisclosure();
            String other$cancellationPolicyDisclosure = other.getCancellationPolicyDisclosure();
            if (this$cancellationPolicyDisclosure == null ? other$cancellationPolicyDisclosure != null : !this$cancellationPolicyDisclosure.equals(other$cancellationPolicyDisclosure)) {
                return false;
            }
            String this$cancellationRebuttal = this.getCancellationRebuttal();
            String other$cancellationRebuttal = other.getCancellationRebuttal();
            if (this$cancellationRebuttal == null ? other$cancellationRebuttal != null : !this$cancellationRebuttal.equals(other$cancellationRebuttal)) {
                return false;
            }
            String this$customerCommunication = this.getCustomerCommunication();
            String other$customerCommunication = other.getCustomerCommunication();
            if (this$customerCommunication == null ? other$customerCommunication != null : !this$customerCommunication.equals(other$customerCommunication)) {
                return false;
            }
            String this$customerEmailAddress = this.getCustomerEmailAddress();
            String other$customerEmailAddress = other.getCustomerEmailAddress();
            if (this$customerEmailAddress == null ? other$customerEmailAddress != null : !this$customerEmailAddress.equals(other$customerEmailAddress)) {
                return false;
            }
            String this$customerName = this.getCustomerName();
            String other$customerName = other.getCustomerName();
            if (this$customerName == null ? other$customerName != null : !this$customerName.equals(other$customerName)) {
                return false;
            }
            String this$customerPurchaseIp = this.getCustomerPurchaseIp();
            String other$customerPurchaseIp = other.getCustomerPurchaseIp();
            if (this$customerPurchaseIp == null ? other$customerPurchaseIp != null : !this$customerPurchaseIp.equals(other$customerPurchaseIp)) {
                return false;
            }
            String this$customerSignature = this.getCustomerSignature();
            String other$customerSignature = other.getCustomerSignature();
            if (this$customerSignature == null ? other$customerSignature != null : !this$customerSignature.equals(other$customerSignature)) {
                return false;
            }
            String this$duplicateChargeDocumentation = this.getDuplicateChargeDocumentation();
            String other$duplicateChargeDocumentation = other.getDuplicateChargeDocumentation();
            if (this$duplicateChargeDocumentation == null ? other$duplicateChargeDocumentation != null : !this$duplicateChargeDocumentation.equals(other$duplicateChargeDocumentation)) {
                return false;
            }
            String this$duplicateChargeExplanation = this.getDuplicateChargeExplanation();
            String other$duplicateChargeExplanation = other.getDuplicateChargeExplanation();
            if (this$duplicateChargeExplanation == null ? other$duplicateChargeExplanation != null : !this$duplicateChargeExplanation.equals(other$duplicateChargeExplanation)) {
                return false;
            }
            String this$duplicateChargeId = this.getDuplicateChargeId();
            String other$duplicateChargeId = other.getDuplicateChargeId();
            if (this$duplicateChargeId == null ? other$duplicateChargeId != null : !this$duplicateChargeId.equals(other$duplicateChargeId)) {
                return false;
            }
            String this$productDescription = this.getProductDescription();
            String other$productDescription = other.getProductDescription();
            if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) {
                return false;
            }
            String this$receipt = this.getReceipt();
            String other$receipt = other.getReceipt();
            if (this$receipt == null ? other$receipt != null : !this$receipt.equals(other$receipt)) {
                return false;
            }
            String this$refundPolicy = this.getRefundPolicy();
            String other$refundPolicy = other.getRefundPolicy();
            if (this$refundPolicy == null ? other$refundPolicy != null : !this$refundPolicy.equals(other$refundPolicy)) {
                return false;
            }
            String this$refundPolicyDisclosure = this.getRefundPolicyDisclosure();
            String other$refundPolicyDisclosure = other.getRefundPolicyDisclosure();
            if (this$refundPolicyDisclosure == null ? other$refundPolicyDisclosure != null : !this$refundPolicyDisclosure.equals(other$refundPolicyDisclosure)) {
                return false;
            }
            String this$refundRefusalExplanation = this.getRefundRefusalExplanation();
            String other$refundRefusalExplanation = other.getRefundRefusalExplanation();
            if (this$refundRefusalExplanation == null ? other$refundRefusalExplanation != null : !this$refundRefusalExplanation.equals(other$refundRefusalExplanation)) {
                return false;
            }
            String this$serviceDate = this.getServiceDate();
            String other$serviceDate = other.getServiceDate();
            if (this$serviceDate == null ? other$serviceDate != null : !this$serviceDate.equals(other$serviceDate)) {
                return false;
            }
            String this$serviceDocumentation = this.getServiceDocumentation();
            String other$serviceDocumentation = other.getServiceDocumentation();
            if (this$serviceDocumentation == null ? other$serviceDocumentation != null : !this$serviceDocumentation.equals(other$serviceDocumentation)) {
                return false;
            }
            String this$shippingAddress = this.getShippingAddress();
            String other$shippingAddress = other.getShippingAddress();
            if (this$shippingAddress == null ? other$shippingAddress != null : !this$shippingAddress.equals(other$shippingAddress)) {
                return false;
            }
            String this$shippingCarrier = this.getShippingCarrier();
            String other$shippingCarrier = other.getShippingCarrier();
            if (this$shippingCarrier == null ? other$shippingCarrier != null : !this$shippingCarrier.equals(other$shippingCarrier)) {
                return false;
            }
            String this$shippingDate = this.getShippingDate();
            String other$shippingDate = other.getShippingDate();
            if (this$shippingDate == null ? other$shippingDate != null : !this$shippingDate.equals(other$shippingDate)) {
                return false;
            }
            String this$shippingDocumentation = this.getShippingDocumentation();
            String other$shippingDocumentation = other.getShippingDocumentation();
            if (this$shippingDocumentation == null ? other$shippingDocumentation != null : !this$shippingDocumentation.equals(other$shippingDocumentation)) {
                return false;
            }
            String this$shippingTrackingNumber = this.getShippingTrackingNumber();
            String other$shippingTrackingNumber = other.getShippingTrackingNumber();
            if (this$shippingTrackingNumber == null ? other$shippingTrackingNumber != null : !this$shippingTrackingNumber.equals(other$shippingTrackingNumber)) {
                return false;
            }
            String this$uncategorizedFile = this.getUncategorizedFile();
            String other$uncategorizedFile = other.getUncategorizedFile();
            if (this$uncategorizedFile == null ? other$uncategorizedFile != null : !this$uncategorizedFile.equals(other$uncategorizedFile)) {
                return false;
            }
            String this$uncategorizedText = this.getUncategorizedText();
            String other$uncategorizedText = other.getUncategorizedText();
            return !(this$uncategorizedText == null ? other$uncategorizedText != null : !this$uncategorizedText.equals(other$uncategorizedText));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Evidence;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accessActivityLog = this.getAccessActivityLog();
            result = result * 59 + ($accessActivityLog == null ? 43 : $accessActivityLog.hashCode());
            String $billingAddress = this.getBillingAddress();
            result = result * 59 + ($billingAddress == null ? 43 : $billingAddress.hashCode());
            String $cancellationPolicy = this.getCancellationPolicy();
            result = result * 59 + ($cancellationPolicy == null ? 43 : $cancellationPolicy.hashCode());
            String $cancellationPolicyDisclosure = this.getCancellationPolicyDisclosure();
            result = result * 59 + ($cancellationPolicyDisclosure == null ? 43 : $cancellationPolicyDisclosure.hashCode());
            String $cancellationRebuttal = this.getCancellationRebuttal();
            result = result * 59 + ($cancellationRebuttal == null ? 43 : $cancellationRebuttal.hashCode());
            String $customerCommunication = this.getCustomerCommunication();
            result = result * 59 + ($customerCommunication == null ? 43 : $customerCommunication.hashCode());
            String $customerEmailAddress = this.getCustomerEmailAddress();
            result = result * 59 + ($customerEmailAddress == null ? 43 : $customerEmailAddress.hashCode());
            String $customerName = this.getCustomerName();
            result = result * 59 + ($customerName == null ? 43 : $customerName.hashCode());
            String $customerPurchaseIp = this.getCustomerPurchaseIp();
            result = result * 59 + ($customerPurchaseIp == null ? 43 : $customerPurchaseIp.hashCode());
            String $customerSignature = this.getCustomerSignature();
            result = result * 59 + ($customerSignature == null ? 43 : $customerSignature.hashCode());
            String $duplicateChargeDocumentation = this.getDuplicateChargeDocumentation();
            result = result * 59 + ($duplicateChargeDocumentation == null ? 43 : $duplicateChargeDocumentation.hashCode());
            String $duplicateChargeExplanation = this.getDuplicateChargeExplanation();
            result = result * 59 + ($duplicateChargeExplanation == null ? 43 : $duplicateChargeExplanation.hashCode());
            String $duplicateChargeId = this.getDuplicateChargeId();
            result = result * 59 + ($duplicateChargeId == null ? 43 : $duplicateChargeId.hashCode());
            String $productDescription = this.getProductDescription();
            result = result * 59 + ($productDescription == null ? 43 : $productDescription.hashCode());
            String $receipt = this.getReceipt();
            result = result * 59 + ($receipt == null ? 43 : $receipt.hashCode());
            String $refundPolicy = this.getRefundPolicy();
            result = result * 59 + ($refundPolicy == null ? 43 : $refundPolicy.hashCode());
            String $refundPolicyDisclosure = this.getRefundPolicyDisclosure();
            result = result * 59 + ($refundPolicyDisclosure == null ? 43 : $refundPolicyDisclosure.hashCode());
            String $refundRefusalExplanation = this.getRefundRefusalExplanation();
            result = result * 59 + ($refundRefusalExplanation == null ? 43 : $refundRefusalExplanation.hashCode());
            String $serviceDate = this.getServiceDate();
            result = result * 59 + ($serviceDate == null ? 43 : $serviceDate.hashCode());
            String $serviceDocumentation = this.getServiceDocumentation();
            result = result * 59 + ($serviceDocumentation == null ? 43 : $serviceDocumentation.hashCode());
            String $shippingAddress = this.getShippingAddress();
            result = result * 59 + ($shippingAddress == null ? 43 : $shippingAddress.hashCode());
            String $shippingCarrier = this.getShippingCarrier();
            result = result * 59 + ($shippingCarrier == null ? 43 : $shippingCarrier.hashCode());
            String $shippingDate = this.getShippingDate();
            result = result * 59 + ($shippingDate == null ? 43 : $shippingDate.hashCode());
            String $shippingDocumentation = this.getShippingDocumentation();
            result = result * 59 + ($shippingDocumentation == null ? 43 : $shippingDocumentation.hashCode());
            String $shippingTrackingNumber = this.getShippingTrackingNumber();
            result = result * 59 + ($shippingTrackingNumber == null ? 43 : $shippingTrackingNumber.hashCode());
            String $uncategorizedFile = this.getUncategorizedFile();
            result = result * 59 + ($uncategorizedFile == null ? 43 : $uncategorizedFile.hashCode());
            String $uncategorizedText = this.getUncategorizedText();
            result = result * 59 + ($uncategorizedText == null ? 43 : $uncategorizedText.hashCode());
            return result;
        }
    }

    public static class EvidenceDetails
    extends StripeObject {
        @SerializedName(value="due_by")
        Long dueBy;
        @SerializedName(value="has_evidence")
        Boolean hasEvidence;
        @SerializedName(value="past_due")
        Boolean pastDue;
        @SerializedName(value="submission_count")
        Long submissionCount;

        @Generated
        public Long getDueBy() {
            return this.dueBy;
        }

        @Generated
        public Boolean getHasEvidence() {
            return this.hasEvidence;
        }

        @Generated
        public Boolean getPastDue() {
            return this.pastDue;
        }

        @Generated
        public Long getSubmissionCount() {
            return this.submissionCount;
        }

        @Generated
        public void setDueBy(Long dueBy) {
            this.dueBy = dueBy;
        }

        @Generated
        public void setHasEvidence(Boolean hasEvidence) {
            this.hasEvidence = hasEvidence;
        }

        @Generated
        public void setPastDue(Boolean pastDue) {
            this.pastDue = pastDue;
        }

        @Generated
        public void setSubmissionCount(Long submissionCount) {
            this.submissionCount = submissionCount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EvidenceDetails)) {
                return false;
            }
            EvidenceDetails other = (EvidenceDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$dueBy = this.getDueBy();
            Long other$dueBy = other.getDueBy();
            if (this$dueBy == null ? other$dueBy != null : !((Object)this$dueBy).equals(other$dueBy)) {
                return false;
            }
            Boolean this$hasEvidence = this.getHasEvidence();
            Boolean other$hasEvidence = other.getHasEvidence();
            if (this$hasEvidence == null ? other$hasEvidence != null : !((Object)this$hasEvidence).equals(other$hasEvidence)) {
                return false;
            }
            Boolean this$pastDue = this.getPastDue();
            Boolean other$pastDue = other.getPastDue();
            if (this$pastDue == null ? other$pastDue != null : !((Object)this$pastDue).equals(other$pastDue)) {
                return false;
            }
            Long this$submissionCount = this.getSubmissionCount();
            Long other$submissionCount = other.getSubmissionCount();
            return !(this$submissionCount == null ? other$submissionCount != null : !((Object)this$submissionCount).equals(other$submissionCount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EvidenceDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $dueBy = this.getDueBy();
            result = result * 59 + ($dueBy == null ? 43 : ((Object)$dueBy).hashCode());
            Boolean $hasEvidence = this.getHasEvidence();
            result = result * 59 + ($hasEvidence == null ? 43 : ((Object)$hasEvidence).hashCode());
            Boolean $pastDue = this.getPastDue();
            result = result * 59 + ($pastDue == null ? 43 : ((Object)$pastDue).hashCode());
            Long $submissionCount = this.getSubmissionCount();
            result = result * 59 + ($submissionCount == null ? 43 : ((Object)$submissionCount).hashCode());
            return result;
        }
    }

    public static class PaymentMethodDetails
    extends StripeObject {
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="paypal")
        Paypal paypal;
        @SerializedName(value="type")
        String type;

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public Paypal getPaypal() {
            return this.paypal;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public void setPaypal(Paypal paypal) {
            this.paypal = paypal;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodDetails)) {
                return false;
            }
            PaymentMethodDetails other = (PaymentMethodDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            Paypal this$paypal = this.getPaypal();
            Paypal other$paypal = other.getPaypal();
            if (this$paypal == null ? other$paypal != null : !((Object)this$paypal).equals(other$paypal)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            Paypal $paypal = this.getPaypal();
            result = result * 59 + ($paypal == null ? 43 : ((Object)$paypal).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Card
        extends StripeObject {
            @SerializedName(value="brand")
            String brand;
            @SerializedName(value="network_reason_code")
            String networkReasonCode;

            @Generated
            public String getBrand() {
                return this.brand;
            }

            @Generated
            public String getNetworkReasonCode() {
                return this.networkReasonCode;
            }

            @Generated
            public void setBrand(String brand) {
                this.brand = brand;
            }

            @Generated
            public void setNetworkReasonCode(String networkReasonCode) {
                this.networkReasonCode = networkReasonCode;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$brand = this.getBrand();
                String other$brand = other.getBrand();
                if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                    return false;
                }
                String this$networkReasonCode = this.getNetworkReasonCode();
                String other$networkReasonCode = other.getNetworkReasonCode();
                return !(this$networkReasonCode == null ? other$networkReasonCode != null : !this$networkReasonCode.equals(other$networkReasonCode));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $brand = this.getBrand();
                result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
                String $networkReasonCode = this.getNetworkReasonCode();
                result = result * 59 + ($networkReasonCode == null ? 43 : $networkReasonCode.hashCode());
                return result;
            }
        }

        public static class Paypal
        extends StripeObject {
            @SerializedName(value="case_id")
            String caseId;
            @SerializedName(value="reason_code")
            String reasonCode;

            @Generated
            public String getCaseId() {
                return this.caseId;
            }

            @Generated
            public String getReasonCode() {
                return this.reasonCode;
            }

            @Generated
            public void setCaseId(String caseId) {
                this.caseId = caseId;
            }

            @Generated
            public void setReasonCode(String reasonCode) {
                this.reasonCode = reasonCode;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paypal)) {
                    return false;
                }
                Paypal other = (Paypal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$caseId = this.getCaseId();
                String other$caseId = other.getCaseId();
                if (this$caseId == null ? other$caseId != null : !this$caseId.equals(other$caseId)) {
                    return false;
                }
                String this$reasonCode = this.getReasonCode();
                String other$reasonCode = other.getReasonCode();
                return !(this$reasonCode == null ? other$reasonCode != null : !this$reasonCode.equals(other$reasonCode));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paypal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $caseId = this.getCaseId();
                result = result * 59 + ($caseId == null ? 43 : $caseId.hashCode());
                String $reasonCode = this.getReasonCode();
                result = result * 59 + ($reasonCode == null ? 43 : $reasonCode.hashCode());
                return result;
            }
        }
    }
}

