/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SubscriptionCreateParams
extends ApiRequestParams {
    @SerializedName(value="add_invoice_items")
    List<AddInvoiceItem> addInvoiceItems;
    @SerializedName(value="application_fee_percent")
    BigDecimal applicationFeePercent;
    @SerializedName(value="automatic_tax")
    AutomaticTax automaticTax;
    @SerializedName(value="backdate_start_date")
    Long backdateStartDate;
    @SerializedName(value="billing_cycle_anchor")
    Long billingCycleAnchor;
    @SerializedName(value="billing_thresholds")
    Object billingThresholds;
    @SerializedName(value="cancel_at")
    Long cancelAt;
    @SerializedName(value="cancel_at_period_end")
    Boolean cancelAtPeriodEnd;
    @SerializedName(value="collection_method")
    CollectionMethod collectionMethod;
    @SerializedName(value="coupon")
    String coupon;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="days_until_due")
    Long daysUntilDue;
    @SerializedName(value="default_payment_method")
    String defaultPaymentMethod;
    @SerializedName(value="default_source")
    String defaultSource;
    @SerializedName(value="default_tax_rates")
    Object defaultTaxRates;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="items")
    List<Item> items;
    @SerializedName(value="metadata")
    Object metadata;
    @SerializedName(value="off_session")
    Boolean offSession;
    @SerializedName(value="on_behalf_of")
    Object onBehalfOf;
    @SerializedName(value="payment_behavior")
    PaymentBehavior paymentBehavior;
    @SerializedName(value="payment_settings")
    PaymentSettings paymentSettings;
    @SerializedName(value="pending_invoice_item_interval")
    Object pendingInvoiceItemInterval;
    @SerializedName(value="promotion_code")
    String promotionCode;
    @SerializedName(value="proration_behavior")
    ProrationBehavior prorationBehavior;
    @SerializedName(value="transfer_data")
    TransferData transferData;
    @SerializedName(value="trial_end")
    Object trialEnd;
    @SerializedName(value="trial_from_plan")
    Boolean trialFromPlan;
    @SerializedName(value="trial_period_days")
    Long trialPeriodDays;
    @SerializedName(value="trial_settings")
    TrialSettings trialSettings;

    private SubscriptionCreateParams(List<AddInvoiceItem> addInvoiceItems, BigDecimal applicationFeePercent, AutomaticTax automaticTax, Long backdateStartDate, Long billingCycleAnchor, Object billingThresholds, Long cancelAt, Boolean cancelAtPeriodEnd, CollectionMethod collectionMethod, String coupon, String currency, String customer, Long daysUntilDue, String defaultPaymentMethod, String defaultSource, Object defaultTaxRates, String description, List<String> expand, Map<String, Object> extraParams, List<Item> items, Object metadata, Boolean offSession, Object onBehalfOf, PaymentBehavior paymentBehavior, PaymentSettings paymentSettings, Object pendingInvoiceItemInterval, String promotionCode, ProrationBehavior prorationBehavior, TransferData transferData, Object trialEnd, Boolean trialFromPlan, Long trialPeriodDays, TrialSettings trialSettings) {
        this.addInvoiceItems = addInvoiceItems;
        this.applicationFeePercent = applicationFeePercent;
        this.automaticTax = automaticTax;
        this.backdateStartDate = backdateStartDate;
        this.billingCycleAnchor = billingCycleAnchor;
        this.billingThresholds = billingThresholds;
        this.cancelAt = cancelAt;
        this.cancelAtPeriodEnd = cancelAtPeriodEnd;
        this.collectionMethod = collectionMethod;
        this.coupon = coupon;
        this.currency = currency;
        this.customer = customer;
        this.daysUntilDue = daysUntilDue;
        this.defaultPaymentMethod = defaultPaymentMethod;
        this.defaultSource = defaultSource;
        this.defaultTaxRates = defaultTaxRates;
        this.description = description;
        this.expand = expand;
        this.extraParams = extraParams;
        this.items = items;
        this.metadata = metadata;
        this.offSession = offSession;
        this.onBehalfOf = onBehalfOf;
        this.paymentBehavior = paymentBehavior;
        this.paymentSettings = paymentSettings;
        this.pendingInvoiceItemInterval = pendingInvoiceItemInterval;
        this.promotionCode = promotionCode;
        this.prorationBehavior = prorationBehavior;
        this.transferData = transferData;
        this.trialEnd = trialEnd;
        this.trialFromPlan = trialFromPlan;
        this.trialPeriodDays = trialPeriodDays;
        this.trialSettings = trialSettings;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public List<AddInvoiceItem> getAddInvoiceItems() {
        return this.addInvoiceItems;
    }

    @Generated
    public BigDecimal getApplicationFeePercent() {
        return this.applicationFeePercent;
    }

    @Generated
    public AutomaticTax getAutomaticTax() {
        return this.automaticTax;
    }

    @Generated
    public Long getBackdateStartDate() {
        return this.backdateStartDate;
    }

    @Generated
    public Long getBillingCycleAnchor() {
        return this.billingCycleAnchor;
    }

    @Generated
    public Object getBillingThresholds() {
        return this.billingThresholds;
    }

    @Generated
    public Long getCancelAt() {
        return this.cancelAt;
    }

    @Generated
    public Boolean getCancelAtPeriodEnd() {
        return this.cancelAtPeriodEnd;
    }

    @Generated
    public CollectionMethod getCollectionMethod() {
        return this.collectionMethod;
    }

    @Generated
    public String getCoupon() {
        return this.coupon;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public Long getDaysUntilDue() {
        return this.daysUntilDue;
    }

    @Generated
    public String getDefaultPaymentMethod() {
        return this.defaultPaymentMethod;
    }

    @Generated
    public String getDefaultSource() {
        return this.defaultSource;
    }

    @Generated
    public Object getDefaultTaxRates() {
        return this.defaultTaxRates;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public List<Item> getItems() {
        return this.items;
    }

    @Generated
    public Object getMetadata() {
        return this.metadata;
    }

    @Generated
    public Boolean getOffSession() {
        return this.offSession;
    }

    @Generated
    public Object getOnBehalfOf() {
        return this.onBehalfOf;
    }

    @Generated
    public PaymentBehavior getPaymentBehavior() {
        return this.paymentBehavior;
    }

    @Generated
    public PaymentSettings getPaymentSettings() {
        return this.paymentSettings;
    }

    @Generated
    public Object getPendingInvoiceItemInterval() {
        return this.pendingInvoiceItemInterval;
    }

    @Generated
    public String getPromotionCode() {
        return this.promotionCode;
    }

    @Generated
    public ProrationBehavior getProrationBehavior() {
        return this.prorationBehavior;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    @Generated
    public Object getTrialEnd() {
        return this.trialEnd;
    }

    @Generated
    public Boolean getTrialFromPlan() {
        return this.trialFromPlan;
    }

    @Generated
    public Long getTrialPeriodDays() {
        return this.trialPeriodDays;
    }

    @Generated
    public TrialSettings getTrialSettings() {
        return this.trialSettings;
    }

    public static class AutomaticTax {
        @SerializedName(value="enabled")
        Boolean enabled;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private AutomaticTax(Boolean enabled, Map<String, Object> extraParams) {
            this.enabled = enabled;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class Builder {
            private Boolean enabled;
            private Map<String, Object> extraParams;

            public AutomaticTax build() {
                return new AutomaticTax(this.enabled, this.extraParams);
            }

            public Builder setEnabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static enum CollectionMethod implements ApiRequestParams.EnumParam
    {
        CHARGE_AUTOMATICALLY("charge_automatically"),
        SEND_INVOICE("send_invoice");

        private final String value;

        private CollectionMethod(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum PaymentBehavior implements ApiRequestParams.EnumParam
    {
        ALLOW_INCOMPLETE("allow_incomplete"),
        DEFAULT_INCOMPLETE("default_incomplete"),
        ERROR_IF_INCOMPLETE("error_if_incomplete"),
        PENDING_IF_INCOMPLETE("pending_if_incomplete");

        private final String value;

        private PaymentBehavior(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class PaymentSettings {
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="payment_method_options")
        PaymentMethodOptions paymentMethodOptions;
        @SerializedName(value="payment_method_types")
        Object paymentMethodTypes;
        @SerializedName(value="save_default_payment_method")
        SaveDefaultPaymentMethod saveDefaultPaymentMethod;

        private PaymentSettings(Map<String, Object> extraParams, PaymentMethodOptions paymentMethodOptions, Object paymentMethodTypes, SaveDefaultPaymentMethod saveDefaultPaymentMethod) {
            this.extraParams = extraParams;
            this.paymentMethodOptions = paymentMethodOptions;
            this.paymentMethodTypes = paymentMethodTypes;
            this.saveDefaultPaymentMethod = saveDefaultPaymentMethod;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public PaymentMethodOptions getPaymentMethodOptions() {
            return this.paymentMethodOptions;
        }

        @Generated
        public Object getPaymentMethodTypes() {
            return this.paymentMethodTypes;
        }

        @Generated
        public SaveDefaultPaymentMethod getSaveDefaultPaymentMethod() {
            return this.saveDefaultPaymentMethod;
        }

        public static class PaymentMethodOptions {
            @SerializedName(value="acss_debit")
            Object acssDebit;
            @SerializedName(value="bancontact")
            Object bancontact;
            @SerializedName(value="card")
            Object card;
            @SerializedName(value="customer_balance")
            Object customerBalance;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="konbini")
            Object konbini;
            @SerializedName(value="us_bank_account")
            Object usBankAccount;

            private PaymentMethodOptions(Object acssDebit, Object bancontact, Object card, Object customerBalance, Map<String, Object> extraParams, Object konbini, Object usBankAccount) {
                this.acssDebit = acssDebit;
                this.bancontact = bancontact;
                this.card = card;
                this.customerBalance = customerBalance;
                this.extraParams = extraParams;
                this.konbini = konbini;
                this.usBankAccount = usBankAccount;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getAcssDebit() {
                return this.acssDebit;
            }

            @Generated
            public Object getBancontact() {
                return this.bancontact;
            }

            @Generated
            public Object getCard() {
                return this.card;
            }

            @Generated
            public Object getCustomerBalance() {
                return this.customerBalance;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getKonbini() {
                return this.konbini;
            }

            @Generated
            public Object getUsBankAccount() {
                return this.usBankAccount;
            }

            public static class Builder {
                private Object acssDebit;
                private Object bancontact;
                private Object card;
                private Object customerBalance;
                private Map<String, Object> extraParams;
                private Object konbini;
                private Object usBankAccount;

                public PaymentMethodOptions build() {
                    return new PaymentMethodOptions(this.acssDebit, this.bancontact, this.card, this.customerBalance, this.extraParams, this.konbini, this.usBankAccount);
                }

                public Builder setAcssDebit(AcssDebit acssDebit) {
                    this.acssDebit = acssDebit;
                    return this;
                }

                public Builder setAcssDebit(EmptyParam acssDebit) {
                    this.acssDebit = acssDebit;
                    return this;
                }

                public Builder setBancontact(Bancontact bancontact) {
                    this.bancontact = bancontact;
                    return this;
                }

                public Builder setBancontact(EmptyParam bancontact) {
                    this.bancontact = bancontact;
                    return this;
                }

                public Builder setCard(Card card) {
                    this.card = card;
                    return this;
                }

                public Builder setCard(EmptyParam card) {
                    this.card = card;
                    return this;
                }

                public Builder setCustomerBalance(CustomerBalance customerBalance) {
                    this.customerBalance = customerBalance;
                    return this;
                }

                public Builder setCustomerBalance(EmptyParam customerBalance) {
                    this.customerBalance = customerBalance;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setKonbini(Konbini konbini) {
                    this.konbini = konbini;
                    return this;
                }

                public Builder setKonbini(EmptyParam konbini) {
                    this.konbini = konbini;
                    return this;
                }

                public Builder setUsBankAccount(UsBankAccount usBankAccount) {
                    this.usBankAccount = usBankAccount;
                    return this;
                }

                public Builder setUsBankAccount(EmptyParam usBankAccount) {
                    this.usBankAccount = usBankAccount;
                    return this;
                }
            }

            public static class UsBankAccount {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="financial_connections")
                FinancialConnections financialConnections;
                @SerializedName(value="verification_method")
                VerificationMethod verificationMethod;

                private UsBankAccount(Map<String, Object> extraParams, FinancialConnections financialConnections, VerificationMethod verificationMethod) {
                    this.extraParams = extraParams;
                    this.financialConnections = financialConnections;
                    this.verificationMethod = verificationMethod;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public FinancialConnections getFinancialConnections() {
                    return this.financialConnections;
                }

                @Generated
                public VerificationMethod getVerificationMethod() {
                    return this.verificationMethod;
                }

                public static class FinancialConnections {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="permissions")
                    List<Permission> permissions;

                    private FinancialConnections(Map<String, Object> extraParams, List<Permission> permissions) {
                        this.extraParams = extraParams;
                        this.permissions = permissions;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public List<Permission> getPermissions() {
                        return this.permissions;
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private List<Permission> permissions;

                        public FinancialConnections build() {
                            return new FinancialConnections(this.extraParams, this.permissions);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder addPermission(Permission element) {
                            if (this.permissions == null) {
                                this.permissions = new ArrayList<Permission>();
                            }
                            this.permissions.add(element);
                            return this;
                        }

                        public Builder addAllPermission(List<Permission> elements) {
                            if (this.permissions == null) {
                                this.permissions = new ArrayList<Permission>();
                            }
                            this.permissions.addAll(elements);
                            return this;
                        }
                    }

                    public static enum Permission implements ApiRequestParams.EnumParam
                    {
                        BALANCES("balances"),
                        OWNERSHIP("ownership"),
                        PAYMENT_METHOD("payment_method"),
                        TRANSACTIONS("transactions");

                        private final String value;

                        private Permission(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }
                }

                public static enum VerificationMethod implements ApiRequestParams.EnumParam
                {
                    AUTOMATIC("automatic"),
                    INSTANT("instant"),
                    MICRODEPOSITS("microdeposits");

                    private final String value;

                    private VerificationMethod(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private FinancialConnections financialConnections;
                    private VerificationMethod verificationMethod;

                    public UsBankAccount build() {
                        return new UsBankAccount(this.extraParams, this.financialConnections, this.verificationMethod);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setFinancialConnections(FinancialConnections financialConnections) {
                        this.financialConnections = financialConnections;
                        return this;
                    }

                    public Builder setVerificationMethod(VerificationMethod verificationMethod) {
                        this.verificationMethod = verificationMethod;
                        return this;
                    }
                }
            }

            public static class Konbini {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private Konbini(Map<String, Object> extraParams) {
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;

                    public Konbini build() {
                        return new Konbini(this.extraParams);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }

            public static class CustomerBalance {
                @SerializedName(value="bank_transfer")
                BankTransfer bankTransfer;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="funding_type")
                String fundingType;

                private CustomerBalance(BankTransfer bankTransfer, Map<String, Object> extraParams, String fundingType) {
                    this.bankTransfer = bankTransfer;
                    this.extraParams = extraParams;
                    this.fundingType = fundingType;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public BankTransfer getBankTransfer() {
                    return this.bankTransfer;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getFundingType() {
                    return this.fundingType;
                }

                public static class BankTransfer {
                    @SerializedName(value="eu_bank_transfer")
                    EuBankTransfer euBankTransfer;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="type")
                    String type;

                    private BankTransfer(EuBankTransfer euBankTransfer, Map<String, Object> extraParams, String type) {
                        this.euBankTransfer = euBankTransfer;
                        this.extraParams = extraParams;
                        this.type = type;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public EuBankTransfer getEuBankTransfer() {
                        return this.euBankTransfer;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public String getType() {
                        return this.type;
                    }

                    public static class EuBankTransfer {
                        @SerializedName(value="country")
                        String country;
                        @SerializedName(value="_stripe_java_extra_param_key")
                        Map<String, Object> extraParams;

                        private EuBankTransfer(String country, Map<String, Object> extraParams) {
                            this.country = country;
                            this.extraParams = extraParams;
                        }

                        public static Builder builder() {
                            return new Builder();
                        }

                        @Generated
                        public String getCountry() {
                            return this.country;
                        }

                        @Generated
                        public Map<String, Object> getExtraParams() {
                            return this.extraParams;
                        }

                        public static class Builder {
                            private String country;
                            private Map<String, Object> extraParams;

                            public EuBankTransfer build() {
                                return new EuBankTransfer(this.country, this.extraParams);
                            }

                            public Builder setCountry(String country) {
                                this.country = country;
                                return this;
                            }

                            public Builder putExtraParam(String key, Object value) {
                                if (this.extraParams == null) {
                                    this.extraParams = new HashMap<String, Object>();
                                }
                                this.extraParams.put(key, value);
                                return this;
                            }

                            public Builder putAllExtraParam(Map<String, Object> map) {
                                if (this.extraParams == null) {
                                    this.extraParams = new HashMap<String, Object>();
                                }
                                this.extraParams.putAll(map);
                                return this;
                            }
                        }
                    }

                    public static class Builder {
                        private EuBankTransfer euBankTransfer;
                        private Map<String, Object> extraParams;
                        private String type;

                        public BankTransfer build() {
                            return new BankTransfer(this.euBankTransfer, this.extraParams, this.type);
                        }

                        public Builder setEuBankTransfer(EuBankTransfer euBankTransfer) {
                            this.euBankTransfer = euBankTransfer;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setType(String type) {
                            this.type = type;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private BankTransfer bankTransfer;
                    private Map<String, Object> extraParams;
                    private String fundingType;

                    public CustomerBalance build() {
                        return new CustomerBalance(this.bankTransfer, this.extraParams, this.fundingType);
                    }

                    public Builder setBankTransfer(BankTransfer bankTransfer) {
                        this.bankTransfer = bankTransfer;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setFundingType(String fundingType) {
                        this.fundingType = fundingType;
                        return this;
                    }
                }
            }

            public static class Card {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="mandate_options")
                MandateOptions mandateOptions;
                @SerializedName(value="network")
                Network network;
                @SerializedName(value="request_three_d_secure")
                RequestThreeDSecure requestThreeDSecure;

                private Card(Map<String, Object> extraParams, MandateOptions mandateOptions, Network network, RequestThreeDSecure requestThreeDSecure) {
                    this.extraParams = extraParams;
                    this.mandateOptions = mandateOptions;
                    this.network = network;
                    this.requestThreeDSecure = requestThreeDSecure;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public MandateOptions getMandateOptions() {
                    return this.mandateOptions;
                }

                @Generated
                public Network getNetwork() {
                    return this.network;
                }

                @Generated
                public RequestThreeDSecure getRequestThreeDSecure() {
                    return this.requestThreeDSecure;
                }

                public static class MandateOptions {
                    @SerializedName(value="amount")
                    Long amount;
                    @SerializedName(value="amount_type")
                    AmountType amountType;
                    @SerializedName(value="description")
                    String description;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;

                    private MandateOptions(Long amount, AmountType amountType, String description, Map<String, Object> extraParams) {
                        this.amount = amount;
                        this.amountType = amountType;
                        this.description = description;
                        this.extraParams = extraParams;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Long getAmount() {
                        return this.amount;
                    }

                    @Generated
                    public AmountType getAmountType() {
                        return this.amountType;
                    }

                    @Generated
                    public String getDescription() {
                        return this.description;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    public static enum AmountType implements ApiRequestParams.EnumParam
                    {
                        FIXED("fixed"),
                        MAXIMUM("maximum");

                        private final String value;

                        private AmountType(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Long amount;
                        private AmountType amountType;
                        private String description;
                        private Map<String, Object> extraParams;

                        public MandateOptions build() {
                            return new MandateOptions(this.amount, this.amountType, this.description, this.extraParams);
                        }

                        public Builder setAmount(Long amount) {
                            this.amount = amount;
                            return this;
                        }

                        public Builder setAmountType(AmountType amountType) {
                            this.amountType = amountType;
                            return this;
                        }

                        public Builder setDescription(String description) {
                            this.description = description;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }
                    }
                }

                public static enum Network implements ApiRequestParams.EnumParam
                {
                    AMEX("amex"),
                    CARTES_BANCAIRES("cartes_bancaires"),
                    DINERS("diners"),
                    DISCOVER("discover"),
                    EFTPOS_AU("eftpos_au"),
                    INTERAC("interac"),
                    JCB("jcb"),
                    MASTERCARD("mastercard"),
                    UNIONPAY("unionpay"),
                    UNKNOWN("unknown"),
                    VISA("visa");

                    private final String value;

                    private Network(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static enum RequestThreeDSecure implements ApiRequestParams.EnumParam
                {
                    ANY("any"),
                    AUTOMATIC("automatic");

                    private final String value;

                    private RequestThreeDSecure(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private MandateOptions mandateOptions;
                    private Network network;
                    private RequestThreeDSecure requestThreeDSecure;

                    public Card build() {
                        return new Card(this.extraParams, this.mandateOptions, this.network, this.requestThreeDSecure);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMandateOptions(MandateOptions mandateOptions) {
                        this.mandateOptions = mandateOptions;
                        return this;
                    }

                    public Builder setNetwork(Network network) {
                        this.network = network;
                        return this;
                    }

                    public Builder setRequestThreeDSecure(RequestThreeDSecure requestThreeDSecure) {
                        this.requestThreeDSecure = requestThreeDSecure;
                        return this;
                    }
                }
            }

            public static class Bancontact {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="preferred_language")
                PreferredLanguage preferredLanguage;

                private Bancontact(Map<String, Object> extraParams, PreferredLanguage preferredLanguage) {
                    this.extraParams = extraParams;
                    this.preferredLanguage = preferredLanguage;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public PreferredLanguage getPreferredLanguage() {
                    return this.preferredLanguage;
                }

                public static enum PreferredLanguage implements ApiRequestParams.EnumParam
                {
                    DE("de"),
                    EN("en"),
                    FR("fr"),
                    NL("nl");

                    private final String value;

                    private PreferredLanguage(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private PreferredLanguage preferredLanguage;

                    public Bancontact build() {
                        return new Bancontact(this.extraParams, this.preferredLanguage);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setPreferredLanguage(PreferredLanguage preferredLanguage) {
                        this.preferredLanguage = preferredLanguage;
                        return this;
                    }
                }
            }

            public static class AcssDebit {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="mandate_options")
                MandateOptions mandateOptions;
                @SerializedName(value="verification_method")
                VerificationMethod verificationMethod;

                private AcssDebit(Map<String, Object> extraParams, MandateOptions mandateOptions, VerificationMethod verificationMethod) {
                    this.extraParams = extraParams;
                    this.mandateOptions = mandateOptions;
                    this.verificationMethod = verificationMethod;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public MandateOptions getMandateOptions() {
                    return this.mandateOptions;
                }

                @Generated
                public VerificationMethod getVerificationMethod() {
                    return this.verificationMethod;
                }

                public static class MandateOptions {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="transaction_type")
                    TransactionType transactionType;

                    private MandateOptions(Map<String, Object> extraParams, TransactionType transactionType) {
                        this.extraParams = extraParams;
                        this.transactionType = transactionType;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public TransactionType getTransactionType() {
                        return this.transactionType;
                    }

                    public static enum TransactionType implements ApiRequestParams.EnumParam
                    {
                        BUSINESS("business"),
                        PERSONAL("personal");

                        private final String value;

                        private TransactionType(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private TransactionType transactionType;

                        public MandateOptions build() {
                            return new MandateOptions(this.extraParams, this.transactionType);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setTransactionType(TransactionType transactionType) {
                            this.transactionType = transactionType;
                            return this;
                        }
                    }
                }

                public static enum VerificationMethod implements ApiRequestParams.EnumParam
                {
                    AUTOMATIC("automatic"),
                    INSTANT("instant"),
                    MICRODEPOSITS("microdeposits");

                    private final String value;

                    private VerificationMethod(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private MandateOptions mandateOptions;
                    private VerificationMethod verificationMethod;

                    public AcssDebit build() {
                        return new AcssDebit(this.extraParams, this.mandateOptions, this.verificationMethod);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMandateOptions(MandateOptions mandateOptions) {
                        this.mandateOptions = mandateOptions;
                        return this;
                    }

                    public Builder setVerificationMethod(VerificationMethod verificationMethod) {
                        this.verificationMethod = verificationMethod;
                        return this;
                    }
                }
            }
        }

        public static enum SaveDefaultPaymentMethod implements ApiRequestParams.EnumParam
        {
            OFF("off"),
            ON_SUBSCRIPTION("on_subscription");

            private final String value;

            private SaveDefaultPaymentMethod(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private Map<String, Object> extraParams;
            private PaymentMethodOptions paymentMethodOptions;
            private Object paymentMethodTypes;
            private SaveDefaultPaymentMethod saveDefaultPaymentMethod;

            public PaymentSettings build() {
                return new PaymentSettings(this.extraParams, this.paymentMethodOptions, this.paymentMethodTypes, this.saveDefaultPaymentMethod);
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
                this.paymentMethodOptions = paymentMethodOptions;
                return this;
            }

            public Builder addPaymentMethodType(PaymentMethodType element) {
                if (this.paymentMethodTypes == null || this.paymentMethodTypes instanceof EmptyParam) {
                    this.paymentMethodTypes = new ArrayList();
                }
                ((List)this.paymentMethodTypes).add(element);
                return this;
            }

            public Builder addAllPaymentMethodType(List<PaymentMethodType> elements) {
                if (this.paymentMethodTypes == null || this.paymentMethodTypes instanceof EmptyParam) {
                    this.paymentMethodTypes = new ArrayList();
                }
                ((List)this.paymentMethodTypes).addAll(elements);
                return this;
            }

            public Builder setPaymentMethodTypes(EmptyParam paymentMethodTypes) {
                this.paymentMethodTypes = paymentMethodTypes;
                return this;
            }

            public Builder setPaymentMethodTypes(List<PaymentMethodType> paymentMethodTypes) {
                this.paymentMethodTypes = paymentMethodTypes;
                return this;
            }

            public Builder setSaveDefaultPaymentMethod(SaveDefaultPaymentMethod saveDefaultPaymentMethod) {
                this.saveDefaultPaymentMethod = saveDefaultPaymentMethod;
                return this;
            }
        }

        public static enum PaymentMethodType implements ApiRequestParams.EnumParam
        {
            ACH_CREDIT_TRANSFER("ach_credit_transfer"),
            ACH_DEBIT("ach_debit"),
            ACSS_DEBIT("acss_debit"),
            AU_BECS_DEBIT("au_becs_debit"),
            BACS_DEBIT("bacs_debit"),
            BANCONTACT("bancontact"),
            BOLETO("boleto"),
            CARD("card"),
            CASHAPP("cashapp"),
            CUSTOMER_BALANCE("customer_balance"),
            FPX("fpx"),
            GIROPAY("giropay"),
            GRABPAY("grabpay"),
            IDEAL("ideal"),
            KONBINI("konbini"),
            LINK("link"),
            PAYNOW("paynow"),
            PAYPAL("paypal"),
            PROMPTPAY("promptpay"),
            SEPA_CREDIT_TRANSFER("sepa_credit_transfer"),
            SEPA_DEBIT("sepa_debit"),
            SOFORT("sofort"),
            US_BANK_ACCOUNT("us_bank_account"),
            WECHAT_PAY("wechat_pay");

            private final String value;

            private PaymentMethodType(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }
    }

    public static enum ProrationBehavior implements ApiRequestParams.EnumParam
    {
        ALWAYS_INVOICE("always_invoice"),
        CREATE_PRORATIONS("create_prorations"),
        NONE("none");

        private final String value;

        private ProrationBehavior(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class TransferData {
        @SerializedName(value="amount_percent")
        BigDecimal amountPercent;
        @SerializedName(value="destination")
        String destination;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private TransferData(BigDecimal amountPercent, String destination, Map<String, Object> extraParams) {
            this.amountPercent = amountPercent;
            this.destination = destination;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public BigDecimal getAmountPercent() {
            return this.amountPercent;
        }

        @Generated
        public String getDestination() {
            return this.destination;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class Builder {
            private BigDecimal amountPercent;
            private String destination;
            private Map<String, Object> extraParams;

            public TransferData build() {
                return new TransferData(this.amountPercent, this.destination, this.extraParams);
            }

            public Builder setAmountPercent(BigDecimal amountPercent) {
                this.amountPercent = amountPercent;
                return this;
            }

            public Builder setDestination(String destination) {
                this.destination = destination;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class TrialSettings {
        @SerializedName(value="end_behavior")
        EndBehavior endBehavior;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private TrialSettings(EndBehavior endBehavior, Map<String, Object> extraParams) {
            this.endBehavior = endBehavior;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public EndBehavior getEndBehavior() {
            return this.endBehavior;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        public static class EndBehavior {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="missing_payment_method")
            MissingPaymentMethod missingPaymentMethod;

            private EndBehavior(Map<String, Object> extraParams, MissingPaymentMethod missingPaymentMethod) {
                this.extraParams = extraParams;
                this.missingPaymentMethod = missingPaymentMethod;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public MissingPaymentMethod getMissingPaymentMethod() {
                return this.missingPaymentMethod;
            }

            public static enum MissingPaymentMethod implements ApiRequestParams.EnumParam
            {
                CANCEL("cancel"),
                CREATE_INVOICE("create_invoice"),
                PAUSE("pause");

                private final String value;

                private MissingPaymentMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private MissingPaymentMethod missingPaymentMethod;

                public EndBehavior build() {
                    return new EndBehavior(this.extraParams, this.missingPaymentMethod);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setMissingPaymentMethod(MissingPaymentMethod missingPaymentMethod) {
                    this.missingPaymentMethod = missingPaymentMethod;
                    return this;
                }
            }
        }

        public static class Builder {
            private EndBehavior endBehavior;
            private Map<String, Object> extraParams;

            public TrialSettings build() {
                return new TrialSettings(this.endBehavior, this.extraParams);
            }

            public Builder setEndBehavior(EndBehavior endBehavior) {
                this.endBehavior = endBehavior;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static class Builder {
        private List<AddInvoiceItem> addInvoiceItems;
        private BigDecimal applicationFeePercent;
        private AutomaticTax automaticTax;
        private Long backdateStartDate;
        private Long billingCycleAnchor;
        private Object billingThresholds;
        private Long cancelAt;
        private Boolean cancelAtPeriodEnd;
        private CollectionMethod collectionMethod;
        private String coupon;
        private String currency;
        private String customer;
        private Long daysUntilDue;
        private String defaultPaymentMethod;
        private String defaultSource;
        private Object defaultTaxRates;
        private String description;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private List<Item> items;
        private Object metadata;
        private Boolean offSession;
        private Object onBehalfOf;
        private PaymentBehavior paymentBehavior;
        private PaymentSettings paymentSettings;
        private Object pendingInvoiceItemInterval;
        private String promotionCode;
        private ProrationBehavior prorationBehavior;
        private TransferData transferData;
        private Object trialEnd;
        private Boolean trialFromPlan;
        private Long trialPeriodDays;
        private TrialSettings trialSettings;

        public SubscriptionCreateParams build() {
            return new SubscriptionCreateParams(this.addInvoiceItems, this.applicationFeePercent, this.automaticTax, this.backdateStartDate, this.billingCycleAnchor, this.billingThresholds, this.cancelAt, this.cancelAtPeriodEnd, this.collectionMethod, this.coupon, this.currency, this.customer, this.daysUntilDue, this.defaultPaymentMethod, this.defaultSource, this.defaultTaxRates, this.description, this.expand, this.extraParams, this.items, this.metadata, this.offSession, this.onBehalfOf, this.paymentBehavior, this.paymentSettings, this.pendingInvoiceItemInterval, this.promotionCode, this.prorationBehavior, this.transferData, this.trialEnd, this.trialFromPlan, this.trialPeriodDays, this.trialSettings);
        }

        public Builder addAddInvoiceItem(AddInvoiceItem element) {
            if (this.addInvoiceItems == null) {
                this.addInvoiceItems = new ArrayList<AddInvoiceItem>();
            }
            this.addInvoiceItems.add(element);
            return this;
        }

        public Builder addAllAddInvoiceItem(List<AddInvoiceItem> elements) {
            if (this.addInvoiceItems == null) {
                this.addInvoiceItems = new ArrayList<AddInvoiceItem>();
            }
            this.addInvoiceItems.addAll(elements);
            return this;
        }

        public Builder setApplicationFeePercent(BigDecimal applicationFeePercent) {
            this.applicationFeePercent = applicationFeePercent;
            return this;
        }

        public Builder setAutomaticTax(AutomaticTax automaticTax) {
            this.automaticTax = automaticTax;
            return this;
        }

        public Builder setBackdateStartDate(Long backdateStartDate) {
            this.backdateStartDate = backdateStartDate;
            return this;
        }

        public Builder setBillingCycleAnchor(Long billingCycleAnchor) {
            this.billingCycleAnchor = billingCycleAnchor;
            return this;
        }

        public Builder setBillingThresholds(BillingThresholds billingThresholds) {
            this.billingThresholds = billingThresholds;
            return this;
        }

        public Builder setBillingThresholds(EmptyParam billingThresholds) {
            this.billingThresholds = billingThresholds;
            return this;
        }

        public Builder setCancelAt(Long cancelAt) {
            this.cancelAt = cancelAt;
            return this;
        }

        public Builder setCancelAtPeriodEnd(Boolean cancelAtPeriodEnd) {
            this.cancelAtPeriodEnd = cancelAtPeriodEnd;
            return this;
        }

        public Builder setCollectionMethod(CollectionMethod collectionMethod) {
            this.collectionMethod = collectionMethod;
            return this;
        }

        public Builder setCoupon(String coupon) {
            this.coupon = coupon;
            return this;
        }

        public Builder setCurrency(String currency) {
            this.currency = currency;
            return this;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setDaysUntilDue(Long daysUntilDue) {
            this.daysUntilDue = daysUntilDue;
            return this;
        }

        public Builder setDefaultPaymentMethod(String defaultPaymentMethod) {
            this.defaultPaymentMethod = defaultPaymentMethod;
            return this;
        }

        public Builder setDefaultSource(String defaultSource) {
            this.defaultSource = defaultSource;
            return this;
        }

        public Builder addDefaultTaxRate(String element) {
            if (this.defaultTaxRates == null || this.defaultTaxRates instanceof EmptyParam) {
                this.defaultTaxRates = new ArrayList();
            }
            ((List)this.defaultTaxRates).add(element);
            return this;
        }

        public Builder addAllDefaultTaxRate(List<String> elements) {
            if (this.defaultTaxRates == null || this.defaultTaxRates instanceof EmptyParam) {
                this.defaultTaxRates = new ArrayList();
            }
            ((List)this.defaultTaxRates).addAll(elements);
            return this;
        }

        public Builder setDefaultTaxRates(EmptyParam defaultTaxRates) {
            this.defaultTaxRates = defaultTaxRates;
            return this;
        }

        public Builder setDefaultTaxRates(List<String> defaultTaxRates) {
            this.defaultTaxRates = defaultTaxRates;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder addItem(Item element) {
            if (this.items == null) {
                this.items = new ArrayList<Item>();
            }
            this.items.add(element);
            return this;
        }

        public Builder addAllItem(List<Item> elements) {
            if (this.items == null) {
                this.items = new ArrayList<Item>();
            }
            this.items.addAll(elements);
            return this;
        }

        public Builder putMetadata(String key, String value) {
            if (this.metadata == null || this.metadata instanceof EmptyParam) {
                this.metadata = new HashMap();
            }
            ((Map)this.metadata).put(key, value);
            return this;
        }

        public Builder putAllMetadata(Map<String, String> map) {
            if (this.metadata == null || this.metadata instanceof EmptyParam) {
                this.metadata = new HashMap();
            }
            ((Map)this.metadata).putAll(map);
            return this;
        }

        public Builder setMetadata(EmptyParam metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setOffSession(Boolean offSession) {
            this.offSession = offSession;
            return this;
        }

        public Builder setOnBehalfOf(String onBehalfOf) {
            this.onBehalfOf = onBehalfOf;
            return this;
        }

        public Builder setOnBehalfOf(EmptyParam onBehalfOf) {
            this.onBehalfOf = onBehalfOf;
            return this;
        }

        public Builder setPaymentBehavior(PaymentBehavior paymentBehavior) {
            this.paymentBehavior = paymentBehavior;
            return this;
        }

        public Builder setPaymentSettings(PaymentSettings paymentSettings) {
            this.paymentSettings = paymentSettings;
            return this;
        }

        public Builder setPendingInvoiceItemInterval(PendingInvoiceItemInterval pendingInvoiceItemInterval) {
            this.pendingInvoiceItemInterval = pendingInvoiceItemInterval;
            return this;
        }

        public Builder setPendingInvoiceItemInterval(EmptyParam pendingInvoiceItemInterval) {
            this.pendingInvoiceItemInterval = pendingInvoiceItemInterval;
            return this;
        }

        public Builder setPromotionCode(String promotionCode) {
            this.promotionCode = promotionCode;
            return this;
        }

        public Builder setProrationBehavior(ProrationBehavior prorationBehavior) {
            this.prorationBehavior = prorationBehavior;
            return this;
        }

        public Builder setTransferData(TransferData transferData) {
            this.transferData = transferData;
            return this;
        }

        public Builder setTrialEnd(TrialEnd trialEnd) {
            this.trialEnd = trialEnd;
            return this;
        }

        public Builder setTrialEnd(Long trialEnd) {
            this.trialEnd = trialEnd;
            return this;
        }

        public Builder setTrialFromPlan(Boolean trialFromPlan) {
            this.trialFromPlan = trialFromPlan;
            return this;
        }

        public Builder setTrialPeriodDays(Long trialPeriodDays) {
            this.trialPeriodDays = trialPeriodDays;
            return this;
        }

        public Builder setTrialSettings(TrialSettings trialSettings) {
            this.trialSettings = trialSettings;
            return this;
        }
    }

    public static enum TrialEnd implements ApiRequestParams.EnumParam
    {
        NOW("now");

        private final String value;

        private TrialEnd(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class PendingInvoiceItemInterval {
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="interval")
        Interval interval;
        @SerializedName(value="interval_count")
        Long intervalCount;

        private PendingInvoiceItemInterval(Map<String, Object> extraParams, Interval interval, Long intervalCount) {
            this.extraParams = extraParams;
            this.interval = interval;
            this.intervalCount = intervalCount;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Interval getInterval() {
            return this.interval;
        }

        @Generated
        public Long getIntervalCount() {
            return this.intervalCount;
        }

        public static enum Interval implements ApiRequestParams.EnumParam
        {
            DAY("day"),
            MONTH("month"),
            WEEK("week"),
            YEAR("year");

            private final String value;

            private Interval(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private Map<String, Object> extraParams;
            private Interval interval;
            private Long intervalCount;

            public PendingInvoiceItemInterval build() {
                return new PendingInvoiceItemInterval(this.extraParams, this.interval, this.intervalCount);
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setInterval(Interval interval) {
                this.interval = interval;
                return this;
            }

            public Builder setIntervalCount(Long intervalCount) {
                this.intervalCount = intervalCount;
                return this;
            }
        }
    }

    public static class Item {
        @SerializedName(value="billing_thresholds")
        Object billingThresholds;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="plan")
        String plan;
        @SerializedName(value="price")
        String price;
        @SerializedName(value="price_data")
        PriceData priceData;
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="tax_rates")
        Object taxRates;

        private Item(Object billingThresholds, Map<String, Object> extraParams, Map<String, String> metadata, String plan, String price, PriceData priceData, Long quantity, Object taxRates) {
            this.billingThresholds = billingThresholds;
            this.extraParams = extraParams;
            this.metadata = metadata;
            this.plan = plan;
            this.price = price;
            this.priceData = priceData;
            this.quantity = quantity;
            this.taxRates = taxRates;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Object getBillingThresholds() {
            return this.billingThresholds;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public String getPlan() {
            return this.plan;
        }

        @Generated
        public String getPrice() {
            return this.price;
        }

        @Generated
        public PriceData getPriceData() {
            return this.priceData;
        }

        @Generated
        public Long getQuantity() {
            return this.quantity;
        }

        @Generated
        public Object getTaxRates() {
            return this.taxRates;
        }

        public static class PriceData {
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="product")
            String product;
            @SerializedName(value="recurring")
            Recurring recurring;
            @SerializedName(value="tax_behavior")
            TaxBehavior taxBehavior;
            @SerializedName(value="unit_amount")
            Long unitAmount;
            @SerializedName(value="unit_amount_decimal")
            BigDecimal unitAmountDecimal;

            private PriceData(String currency, Map<String, Object> extraParams, String product, Recurring recurring, TaxBehavior taxBehavior, Long unitAmount, BigDecimal unitAmountDecimal) {
                this.currency = currency;
                this.extraParams = extraParams;
                this.product = product;
                this.recurring = recurring;
                this.taxBehavior = taxBehavior;
                this.unitAmount = unitAmount;
                this.unitAmountDecimal = unitAmountDecimal;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getProduct() {
                return this.product;
            }

            @Generated
            public Recurring getRecurring() {
                return this.recurring;
            }

            @Generated
            public TaxBehavior getTaxBehavior() {
                return this.taxBehavior;
            }

            @Generated
            public Long getUnitAmount() {
                return this.unitAmount;
            }

            @Generated
            public BigDecimal getUnitAmountDecimal() {
                return this.unitAmountDecimal;
            }

            public static class Recurring {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="interval")
                Interval interval;
                @SerializedName(value="interval_count")
                Long intervalCount;

                private Recurring(Map<String, Object> extraParams, Interval interval, Long intervalCount) {
                    this.extraParams = extraParams;
                    this.interval = interval;
                    this.intervalCount = intervalCount;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Interval getInterval() {
                    return this.interval;
                }

                @Generated
                public Long getIntervalCount() {
                    return this.intervalCount;
                }

                public static enum Interval implements ApiRequestParams.EnumParam
                {
                    DAY("day"),
                    MONTH("month"),
                    WEEK("week"),
                    YEAR("year");

                    private final String value;

                    private Interval(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Interval interval;
                    private Long intervalCount;

                    public Recurring build() {
                        return new Recurring(this.extraParams, this.interval, this.intervalCount);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setInterval(Interval interval) {
                        this.interval = interval;
                        return this;
                    }

                    public Builder setIntervalCount(Long intervalCount) {
                        this.intervalCount = intervalCount;
                        return this;
                    }
                }
            }

            public static enum TaxBehavior implements ApiRequestParams.EnumParam
            {
                EXCLUSIVE("exclusive"),
                INCLUSIVE("inclusive"),
                UNSPECIFIED("unspecified");

                private final String value;

                private TaxBehavior(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private String currency;
                private Map<String, Object> extraParams;
                private String product;
                private Recurring recurring;
                private TaxBehavior taxBehavior;
                private Long unitAmount;
                private BigDecimal unitAmountDecimal;

                public PriceData build() {
                    return new PriceData(this.currency, this.extraParams, this.product, this.recurring, this.taxBehavior, this.unitAmount, this.unitAmountDecimal);
                }

                public Builder setCurrency(String currency) {
                    this.currency = currency;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setProduct(String product) {
                    this.product = product;
                    return this;
                }

                public Builder setRecurring(Recurring recurring) {
                    this.recurring = recurring;
                    return this;
                }

                public Builder setTaxBehavior(TaxBehavior taxBehavior) {
                    this.taxBehavior = taxBehavior;
                    return this;
                }

                public Builder setUnitAmount(Long unitAmount) {
                    this.unitAmount = unitAmount;
                    return this;
                }

                public Builder setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
                    this.unitAmountDecimal = unitAmountDecimal;
                    return this;
                }
            }
        }

        public static class Builder {
            private Object billingThresholds;
            private Map<String, Object> extraParams;
            private Map<String, String> metadata;
            private String plan;
            private String price;
            private PriceData priceData;
            private Long quantity;
            private Object taxRates;

            public Item build() {
                return new Item(this.billingThresholds, this.extraParams, this.metadata, this.plan, this.price, this.priceData, this.quantity, this.taxRates);
            }

            public Builder setBillingThresholds(BillingThresholds billingThresholds) {
                this.billingThresholds = billingThresholds;
                return this;
            }

            public Builder setBillingThresholds(EmptyParam billingThresholds) {
                this.billingThresholds = billingThresholds;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setPlan(String plan) {
                this.plan = plan;
                return this;
            }

            public Builder setPrice(String price) {
                this.price = price;
                return this;
            }

            public Builder setPriceData(PriceData priceData) {
                this.priceData = priceData;
                return this;
            }

            public Builder setQuantity(Long quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder addTaxRate(String element) {
                if (this.taxRates == null || this.taxRates instanceof EmptyParam) {
                    this.taxRates = new ArrayList();
                }
                ((List)this.taxRates).add(element);
                return this;
            }

            public Builder addAllTaxRate(List<String> elements) {
                if (this.taxRates == null || this.taxRates instanceof EmptyParam) {
                    this.taxRates = new ArrayList();
                }
                ((List)this.taxRates).addAll(elements);
                return this;
            }

            public Builder setTaxRates(EmptyParam taxRates) {
                this.taxRates = taxRates;
                return this;
            }

            public Builder setTaxRates(List<String> taxRates) {
                this.taxRates = taxRates;
                return this;
            }
        }

        public static class BillingThresholds {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="usage_gte")
            Long usageGte;

            private BillingThresholds(Map<String, Object> extraParams, Long usageGte) {
                this.extraParams = extraParams;
                this.usageGte = usageGte;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Long getUsageGte() {
                return this.usageGte;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Long usageGte;

                public BillingThresholds build() {
                    return new BillingThresholds(this.extraParams, this.usageGte);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setUsageGte(Long usageGte) {
                    this.usageGte = usageGte;
                    return this;
                }
            }
        }
    }

    public static class BillingThresholds {
        @SerializedName(value="amount_gte")
        Long amountGte;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="reset_billing_cycle_anchor")
        Boolean resetBillingCycleAnchor;

        private BillingThresholds(Long amountGte, Map<String, Object> extraParams, Boolean resetBillingCycleAnchor) {
            this.amountGte = amountGte;
            this.extraParams = extraParams;
            this.resetBillingCycleAnchor = resetBillingCycleAnchor;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Long getAmountGte() {
            return this.amountGte;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Boolean getResetBillingCycleAnchor() {
            return this.resetBillingCycleAnchor;
        }

        public static class Builder {
            private Long amountGte;
            private Map<String, Object> extraParams;
            private Boolean resetBillingCycleAnchor;

            public BillingThresholds build() {
                return new BillingThresholds(this.amountGte, this.extraParams, this.resetBillingCycleAnchor);
            }

            public Builder setAmountGte(Long amountGte) {
                this.amountGte = amountGte;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setResetBillingCycleAnchor(Boolean resetBillingCycleAnchor) {
                this.resetBillingCycleAnchor = resetBillingCycleAnchor;
                return this;
            }
        }
    }

    public static class AddInvoiceItem {
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="price")
        String price;
        @SerializedName(value="price_data")
        PriceData priceData;
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="tax_rates")
        Object taxRates;

        private AddInvoiceItem(Map<String, Object> extraParams, String price, PriceData priceData, Long quantity, Object taxRates) {
            this.extraParams = extraParams;
            this.price = price;
            this.priceData = priceData;
            this.quantity = quantity;
            this.taxRates = taxRates;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public String getPrice() {
            return this.price;
        }

        @Generated
        public PriceData getPriceData() {
            return this.priceData;
        }

        @Generated
        public Long getQuantity() {
            return this.quantity;
        }

        @Generated
        public Object getTaxRates() {
            return this.taxRates;
        }

        public static class PriceData {
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="product")
            String product;
            @SerializedName(value="tax_behavior")
            TaxBehavior taxBehavior;
            @SerializedName(value="unit_amount")
            Long unitAmount;
            @SerializedName(value="unit_amount_decimal")
            BigDecimal unitAmountDecimal;

            private PriceData(String currency, Map<String, Object> extraParams, String product, TaxBehavior taxBehavior, Long unitAmount, BigDecimal unitAmountDecimal) {
                this.currency = currency;
                this.extraParams = extraParams;
                this.product = product;
                this.taxBehavior = taxBehavior;
                this.unitAmount = unitAmount;
                this.unitAmountDecimal = unitAmountDecimal;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getProduct() {
                return this.product;
            }

            @Generated
            public TaxBehavior getTaxBehavior() {
                return this.taxBehavior;
            }

            @Generated
            public Long getUnitAmount() {
                return this.unitAmount;
            }

            @Generated
            public BigDecimal getUnitAmountDecimal() {
                return this.unitAmountDecimal;
            }

            public static enum TaxBehavior implements ApiRequestParams.EnumParam
            {
                EXCLUSIVE("exclusive"),
                INCLUSIVE("inclusive"),
                UNSPECIFIED("unspecified");

                private final String value;

                private TaxBehavior(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private String currency;
                private Map<String, Object> extraParams;
                private String product;
                private TaxBehavior taxBehavior;
                private Long unitAmount;
                private BigDecimal unitAmountDecimal;

                public PriceData build() {
                    return new PriceData(this.currency, this.extraParams, this.product, this.taxBehavior, this.unitAmount, this.unitAmountDecimal);
                }

                public Builder setCurrency(String currency) {
                    this.currency = currency;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setProduct(String product) {
                    this.product = product;
                    return this;
                }

                public Builder setTaxBehavior(TaxBehavior taxBehavior) {
                    this.taxBehavior = taxBehavior;
                    return this;
                }

                public Builder setUnitAmount(Long unitAmount) {
                    this.unitAmount = unitAmount;
                    return this;
                }

                public Builder setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
                    this.unitAmountDecimal = unitAmountDecimal;
                    return this;
                }
            }
        }

        public static class Builder {
            private Map<String, Object> extraParams;
            private String price;
            private PriceData priceData;
            private Long quantity;
            private Object taxRates;

            public AddInvoiceItem build() {
                return new AddInvoiceItem(this.extraParams, this.price, this.priceData, this.quantity, this.taxRates);
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setPrice(String price) {
                this.price = price;
                return this;
            }

            public Builder setPriceData(PriceData priceData) {
                this.priceData = priceData;
                return this;
            }

            public Builder setQuantity(Long quantity) {
                this.quantity = quantity;
                return this;
            }

            public Builder addTaxRate(String element) {
                if (this.taxRates == null || this.taxRates instanceof EmptyParam) {
                    this.taxRates = new ArrayList();
                }
                ((List)this.taxRates).add(element);
                return this;
            }

            public Builder addAllTaxRate(List<String> elements) {
                if (this.taxRates == null || this.taxRates instanceof EmptyParam) {
                    this.taxRates = new ArrayList();
                }
                ((List)this.taxRates).addAll(elements);
                return this;
            }

            public Builder setTaxRates(EmptyParam taxRates) {
                this.taxRates = taxRates;
                return this;
            }

            public Builder setTaxRates(List<String> taxRates) {
                this.taxRates = taxRates;
                return this;
            }
        }
    }
}

