/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.Stripe;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.File;
import com.stripe.model.FileLinkCollection;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.net.ApiResource;
import com.stripe.net.RequestOptions;
import com.stripe.param.FileLinkCreateParams;
import com.stripe.param.FileLinkListParams;
import com.stripe.param.FileLinkRetrieveParams;
import com.stripe.param.FileLinkUpdateParams;
import java.util.Map;
import lombok.Generated;

public class FileLink
extends ApiResource
implements HasId,
MetadataStore<FileLink> {
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="expired")
    Boolean expired;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="file")
    ExpandableField<File> file;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="url")
    String url;

    public String getFile() {
        return this.file != null ? this.file.getId() : null;
    }

    public void setFile(String id) {
        this.file = ApiResource.setExpandableFieldId(id, this.file);
    }

    public File getFileObject() {
        return this.file != null ? this.file.getExpanded() : null;
    }

    public void setFileObject(File expandableObject) {
        this.file = new ExpandableField<File>(expandableObject.getId(), expandableObject);
    }

    public static FileLink retrieve(String link) throws StripeException {
        return FileLink.retrieve(link, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static FileLink retrieve(String link, RequestOptions options) throws StripeException {
        return FileLink.retrieve(link, (Map<String, Object>)null, options);
    }

    public static FileLink retrieve(String link, Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/file_links/%s", ApiResource.urlEncodeId(link)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FileLink.class, options);
    }

    public static FileLink retrieve(String link, FileLinkRetrieveParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/file_links/%s", ApiResource.urlEncodeId(link)));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, params, FileLink.class, options);
    }

    public static FileLink create(Map<String, Object> params) throws StripeException {
        return FileLink.create(params, (RequestOptions)null);
    }

    public static FileLink create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/file_links");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, FileLink.class, options);
    }

    public static FileLink create(FileLinkCreateParams params) throws StripeException {
        return FileLink.create(params, (RequestOptions)null);
    }

    public static FileLink create(FileLinkCreateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/file_links");
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, FileLink.class, options);
    }

    public FileLink update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public FileLink update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/file_links/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, FileLink.class, options);
    }

    public FileLink update(FileLinkUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public FileLink update(FileLinkUpdateParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), String.format("/v1/file_links/%s", ApiResource.urlEncodeId(this.getId())));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, params, FileLink.class, options);
    }

    public static FileLinkCollection list(Map<String, Object> params) throws StripeException {
        return FileLink.list(params, (RequestOptions)null);
    }

    public static FileLinkCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/file_links");
        return ApiResource.requestCollection(url, params, FileLinkCollection.class, options);
    }

    public static FileLinkCollection list(FileLinkListParams params) throws StripeException {
        return FileLink.list(params, (RequestOptions)null);
    }

    public static FileLinkCollection list(FileLinkListParams params, RequestOptions options) throws StripeException {
        String url = String.format("%s%s", Stripe.getApiBase(), "/v1/file_links");
        return ApiResource.requestCollection(url, params, FileLinkCollection.class, options);
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Boolean getExpired() {
        return this.expired;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setExpired(Boolean expired) {
        this.expired = expired;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileLink)) {
            return false;
        }
        FileLink other = (FileLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$expired = this.getExpired();
        Boolean other$expired = other.getExpired();
        if (this$expired == null ? other$expired != null : !((Object)this$expired).equals(other$expired)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        String this$file = this.getFile();
        String other$file = other.getFile();
        if (this$file == null ? other$file != null : !this$file.equals(other$file)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileLink;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $expired = this.getExpired();
        result = result * 59 + ($expired == null ? 43 : ((Object)$expired).hashCode());
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        String $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : $file.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }
}

