/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model.wallets;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.wallets.Wallet;
import com.stripe.android.utils.ObjectUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public final class MasterpassWallet
extends Wallet {
    private static final String FIELD_BILLING_ADDRESS = "billing_address";
    private static final String FIELD_EMAIL = "email";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_SHIPPING_ADDRESS = "shipping_address";
    @Nullable
    public final Wallet.Address billingAddress;
    @Nullable
    public final String email;
    @Nullable
    public final String name;
    @Nullable
    public final Wallet.Address shippingAddress;
    public static final Parcelable.Creator<MasterpassWallet> CREATOR = new Parcelable.Creator<MasterpassWallet>(){

        public MasterpassWallet createFromParcel(@NonNull Parcel in) {
            return new MasterpassWallet(in);
        }

        public MasterpassWallet[] newArray(int size) {
            return new MasterpassWallet[size];
        }
    };

    private MasterpassWallet(@NonNull Builder builder) {
        super(Wallet.Type.Masterpass, builder);
        this.billingAddress = builder.mBillingAddress;
        this.email = builder.mEmail;
        this.name = builder.mName;
        this.shippingAddress = builder.mShippingAddress;
    }

    @Override
    @NonNull
    Map<String, Object> getWalletTypeMap() {
        HashMap<String, Object> wallet = new HashMap<String, Object>();
        ((AbstractMap)wallet).put(FIELD_BILLING_ADDRESS, this.billingAddress != null ? this.billingAddress.toMap() : null);
        ((AbstractMap)wallet).put(FIELD_EMAIL, this.email);
        ((AbstractMap)wallet).put(FIELD_NAME, this.name);
        ((AbstractMap)wallet).put(FIELD_SHIPPING_ADDRESS, this.shippingAddress != null ? this.shippingAddress.toMap() : null);
        return wallet;
    }

    @NonNull
    static Builder fromJson(@NonNull JSONObject wallet) {
        return new Builder().setBillingAddress(Wallet.Address.fromJson(wallet.optJSONObject(FIELD_BILLING_ADDRESS))).setEmail(StripeJsonUtils.optString(wallet, FIELD_EMAIL)).setName(StripeJsonUtils.optString(wallet, FIELD_NAME)).setShippingAddress(Wallet.Address.fromJson(wallet.optJSONObject(FIELD_SHIPPING_ADDRESS)));
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash((Object[])new Object[]{this.billingAddress, this.email, this.name, this.shippingAddress});
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof MasterpassWallet && this.typedEquals((MasterpassWallet)obj);
    }

    private boolean typedEquals(@NonNull MasterpassWallet wallet) {
        return ObjectUtils.equals((Object)this.billingAddress, (Object)wallet.billingAddress) && ObjectUtils.equals((Object)this.email, (Object)wallet.email) && ObjectUtils.equals((Object)this.name, (Object)wallet.name) && ObjectUtils.equals((Object)this.shippingAddress, (Object)wallet.shippingAddress);
    }

    private MasterpassWallet(@NonNull Parcel in) {
        super(in);
        this.billingAddress = (Wallet.Address)in.readParcelable(Wallet.Address.class.getClassLoader());
        this.email = in.readString();
        this.name = in.readString();
        this.shippingAddress = (Wallet.Address)in.readParcelable(Wallet.Address.class.getClassLoader());
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeParcelable((Parcelable)this.billingAddress, flags);
        dest.writeString(this.email);
        dest.writeString(this.name);
        dest.writeParcelable((Parcelable)this.shippingAddress, flags);
    }

    public static final class Builder
    extends Wallet.Builder<MasterpassWallet> {
        @Nullable
        private Wallet.Address mBillingAddress;
        @Nullable
        private String mEmail;
        @Nullable
        private String mName;
        @Nullable
        private Wallet.Address mShippingAddress;

        @NonNull
        public Builder setBillingAddress(@Nullable Wallet.Address billingAddress) {
            this.mBillingAddress = billingAddress;
            return this;
        }

        @NonNull
        public Builder setEmail(@Nullable String email) {
            this.mEmail = email;
            return this;
        }

        @NonNull
        public Builder setName(@Nullable String name) {
            this.mName = name;
            return this;
        }

        @NonNull
        public Builder setShippingAddress(@Nullable Wallet.Address shippingAddress) {
            this.mShippingAddress = shippingAddress;
            return this;
        }

        @Override
        @NonNull
        public MasterpassWallet build() {
            return new MasterpassWallet(this);
        }
    }
}

