/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.model.Address;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.utils.ObjectUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class SourceOwner
extends StripeModel {
    private static final String VERIFIED = "verified_";
    private static final String FIELD_ADDRESS = "address";
    private static final String FIELD_EMAIL = "email";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_PHONE = "phone";
    private static final String FIELD_VERIFIED_ADDRESS = "verified_address";
    private static final String FIELD_VERIFIED_EMAIL = "verified_email";
    private static final String FIELD_VERIFIED_NAME = "verified_name";
    private static final String FIELD_VERIFIED_PHONE = "verified_phone";
    @Nullable
    private final Address mAddress;
    @Nullable
    private final String mEmail;
    @Nullable
    private final String mName;
    @Nullable
    private final String mPhone;
    @Nullable
    private final Address mVerifiedAddress;
    @Nullable
    private final String mVerifiedEmail;
    @Nullable
    private final String mVerifiedName;
    @Nullable
    private final String mVerifiedPhone;

    private SourceOwner(@Nullable Address address, @Nullable String email, @Nullable String name, @Nullable String phone, @Nullable Address verifiedAddress, @Nullable String verifiedEmail, @Nullable String verifiedName, @Nullable String verifiedPhone) {
        this.mAddress = address;
        this.mEmail = email;
        this.mName = name;
        this.mPhone = phone;
        this.mVerifiedAddress = verifiedAddress;
        this.mVerifiedEmail = verifiedEmail;
        this.mVerifiedName = verifiedName;
        this.mVerifiedPhone = verifiedPhone;
    }

    @Nullable
    public Address getAddress() {
        return this.mAddress;
    }

    @Nullable
    public String getEmail() {
        return this.mEmail;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public String getPhone() {
        return this.mPhone;
    }

    @Nullable
    public Address getVerifiedAddress() {
        return this.mVerifiedAddress;
    }

    @Nullable
    public String getVerifiedEmail() {
        return this.mVerifiedEmail;
    }

    @Nullable
    public String getVerifiedName() {
        return this.mVerifiedName;
    }

    @Nullable
    public String getVerifiedPhone() {
        return this.mVerifiedPhone;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.mAddress != null) {
            ((AbstractMap)map).put(FIELD_ADDRESS, this.mAddress.toMap());
        }
        ((AbstractMap)map).put(FIELD_EMAIL, this.mEmail);
        ((AbstractMap)map).put(FIELD_NAME, this.mName);
        ((AbstractMap)map).put(FIELD_PHONE, this.mPhone);
        if (this.mVerifiedAddress != null) {
            ((AbstractMap)map).put(FIELD_VERIFIED_ADDRESS, this.mVerifiedAddress.toMap());
        }
        ((AbstractMap)map).put(FIELD_VERIFIED_EMAIL, this.mVerifiedEmail);
        ((AbstractMap)map).put(FIELD_VERIFIED_NAME, this.mVerifiedName);
        ((AbstractMap)map).put(FIELD_VERIFIED_PHONE, this.mVerifiedPhone);
        StripeNetworkUtils.removeNullAndEmptyParams(map);
        return map;
    }

    @Nullable
    public static SourceOwner fromString(@Nullable String jsonString) {
        try {
            return SourceOwner.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static SourceOwner fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        JSONObject addressJsonOpt = jsonObject.optJSONObject(FIELD_ADDRESS);
        Address address = addressJsonOpt != null ? Address.fromJson(addressJsonOpt) : null;
        String email = StripeJsonUtils.optString(jsonObject, FIELD_EMAIL);
        String name = StripeJsonUtils.optString(jsonObject, FIELD_NAME);
        String phone = StripeJsonUtils.optString(jsonObject, FIELD_PHONE);
        JSONObject verifiedAddressJsonOpt = jsonObject.optJSONObject(FIELD_VERIFIED_ADDRESS);
        Address verifiedAddress = verifiedAddressJsonOpt != null ? Address.fromJson(verifiedAddressJsonOpt) : null;
        String verifiedEmail = StripeJsonUtils.optString(jsonObject, FIELD_VERIFIED_EMAIL);
        String verifiedName = StripeJsonUtils.optString(jsonObject, FIELD_VERIFIED_NAME);
        String verifiedPhone = StripeJsonUtils.optString(jsonObject, FIELD_VERIFIED_PHONE);
        return new SourceOwner(address, email, name, phone, verifiedAddress, verifiedEmail, verifiedName, verifiedPhone);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof SourceOwner && this.typedEquals((SourceOwner)obj);
    }

    private boolean typedEquals(@NonNull SourceOwner sourceOwner) {
        return ObjectUtils.equals((Object)this.mAddress, (Object)sourceOwner.mAddress) && ObjectUtils.equals((Object)this.mEmail, (Object)sourceOwner.mEmail) && ObjectUtils.equals((Object)this.mName, (Object)sourceOwner.mName) && ObjectUtils.equals((Object)this.mPhone, (Object)sourceOwner.mPhone) && ObjectUtils.equals((Object)this.mVerifiedAddress, (Object)sourceOwner.mVerifiedAddress) && ObjectUtils.equals((Object)this.mVerifiedEmail, (Object)sourceOwner.mVerifiedEmail) && ObjectUtils.equals((Object)this.mVerifiedName, (Object)sourceOwner.mVerifiedName) && ObjectUtils.equals((Object)this.mVerifiedPhone, (Object)sourceOwner.mVerifiedPhone);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash((Object[])new Object[]{this.mAddress, this.mEmail, this.mName, this.mPhone, this.mVerifiedAddress, this.mVerifiedEmail, this.mVerifiedName, this.mVerifiedPhone});
    }
}

