/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.utils.ObjectUtils;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class SourceCodeVerification
extends StripeModel {
    static final String PENDING = "pending";
    static final String SUCCEEDED = "succeeded";
    static final String FAILED = "failed";
    private static final String FIELD_ATTEMPTS_REMAINING = "attempts_remaining";
    private static final String FIELD_STATUS = "status";
    private static final int INVALID_ATTEMPTS_REMAINING = -1;
    private final int mAttemptsRemaining;
    @Nullable
    private final String mStatus;

    private SourceCodeVerification(int attemptsRemaining, @Nullable String status) {
        this.mAttemptsRemaining = attemptsRemaining;
        this.mStatus = status;
    }

    public int getAttemptsRemaining() {
        return this.mAttemptsRemaining;
    }

    @Nullable
    public String getStatus() {
        return this.mStatus;
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FIELD_ATTEMPTS_REMAINING, this.mAttemptsRemaining);
        if (this.mStatus != null) {
            map.put(FIELD_STATUS, this.mStatus);
        }
        return map;
    }

    @Nullable
    public static SourceCodeVerification fromString(@Nullable String jsonString) {
        try {
            return SourceCodeVerification.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException ignored) {
            return null;
        }
    }

    @Nullable
    public static SourceCodeVerification fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return new SourceCodeVerification(jsonObject.optInt(FIELD_ATTEMPTS_REMAINING, -1), SourceCodeVerification.asStatus(StripeJsonUtils.optString(jsonObject, FIELD_STATUS)));
    }

    @Nullable
    private static String asStatus(@Nullable String stringStatus) {
        if (PENDING.equals(stringStatus)) {
            return PENDING;
        }
        if (SUCCEEDED.equals(stringStatus)) {
            return SUCCEEDED;
        }
        if (FAILED.equals(stringStatus)) {
            return FAILED;
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof SourceCodeVerification && this.typedEquals((SourceCodeVerification)obj);
    }

    private boolean typedEquals(@NonNull SourceCodeVerification sourceCodeVerification) {
        return this.mAttemptsRemaining == sourceCodeVerification.mAttemptsRemaining && ObjectUtils.equals((Object)this.mStatus, (Object)sourceCodeVerification.mStatus);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash((Object[])new Object[]{this.mAttemptsRemaining, this.mStatus});
    }
}

