/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.StripeNetworkUtils;
import com.stripe.android.model.Address;
import com.stripe.android.model.StripeJsonUtils;
import com.stripe.android.model.StripeModel;
import com.stripe.android.utils.ObjectUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public final class ShippingInformation
extends StripeModel
implements Parcelable {
    public static final Parcelable.Creator<ShippingInformation> CREATOR = new Parcelable.Creator<ShippingInformation>(){

        public ShippingInformation createFromParcel(Parcel source) {
            return new ShippingInformation(source);
        }

        public ShippingInformation[] newArray(int size) {
            return new ShippingInformation[size];
        }
    };
    private static final String FIELD_ADDRESS = "address";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_PHONE = "phone";
    @Nullable
    private final Address mAddress;
    @Nullable
    private final String mName;
    @Nullable
    private final String mPhone;

    public ShippingInformation() {
        this(null, null, null);
    }

    public ShippingInformation(@Nullable Address address, @Nullable String name, @Nullable String phone) {
        this.mAddress = address;
        this.mName = name;
        this.mPhone = phone;
    }

    protected ShippingInformation(@NonNull Parcel in) {
        this.mAddress = (Address)in.readParcelable(Address.class.getClassLoader());
        this.mName = in.readString();
        this.mPhone = in.readString();
    }

    @Nullable
    public Address getAddress() {
        return this.mAddress;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public String getPhone() {
        return this.mPhone;
    }

    @Nullable
    public static ShippingInformation fromJson(@Nullable JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        return new ShippingInformation(Address.fromJson(jsonObject.optJSONObject(FIELD_ADDRESS)), StripeJsonUtils.optString(jsonObject, FIELD_NAME), StripeJsonUtils.optString(jsonObject, FIELD_PHONE));
    }

    @Override
    @NonNull
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ((AbstractMap)map).put(FIELD_NAME, this.mName);
        ((AbstractMap)map).put(FIELD_PHONE, this.mPhone);
        if (this.mAddress != null) {
            ((AbstractMap)map).put(FIELD_ADDRESS, this.mAddress.toMap());
        }
        StripeNetworkUtils.removeNullAndEmptyParams(map);
        return map;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.mAddress, flags);
        dest.writeString(this.mName);
        dest.writeString(this.mPhone);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof ShippingInformation && this.typedEquals((ShippingInformation)obj);
    }

    private boolean typedEquals(@NonNull ShippingInformation shippingInformation) {
        return ObjectUtils.equals((Object)this.mAddress, (Object)shippingInformation.mAddress) && ObjectUtils.equals((Object)this.mName, (Object)shippingInformation.mName) && ObjectUtils.equals((Object)this.mPhone, (Object)shippingInformation.mPhone);
    }

    @Override
    public int hashCode() {
        return ObjectUtils.hash((Object[])new Object[]{this.mAddress, this.mName, this.mPhone});
    }
}

