/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.utils.ObjectUtils;
import com.stripe.android.view.ActivityStarter;
import com.stripe.android.view.PaymentRelayActivity;
import java.io.Serializable;

class PaymentRelayStarter
implements ActivityStarter<Data> {
    @NonNull
    private final Activity mActivity;
    private final int mRequestCode;

    PaymentRelayStarter(@NonNull Activity activity, int requestCode) {
        this.mActivity = activity;
        this.mRequestCode = requestCode;
    }

    @Override
    public void start(@NonNull Data data) {
        Intent intent = new Intent((Context)this.mActivity, PaymentRelayActivity.class).putExtra("client_secret", data.paymentIntent != null ? data.paymentIntent.getClientSecret() : null).putExtra("exception", (Serializable)data.exception).putExtra("status", data.status);
        this.mActivity.startActivityForResult(intent, this.mRequestCode);
    }

    public static final class Data {
        @Nullable
        final PaymentIntent paymentIntent;
        @Nullable
        final Exception exception;
        final int status;

        Data(@NonNull PaymentIntent paymentIntent) {
            this.paymentIntent = paymentIntent;
            this.status = 1;
            this.exception = null;
        }

        Data(@NonNull Exception exception) {
            this.paymentIntent = null;
            this.status = 2;
            this.exception = exception;
        }

        public int hashCode() {
            return ObjectUtils.hash((Object[])new Object[]{this.paymentIntent, this.exception, this.status});
        }

        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) || obj instanceof Data && this.typedEquals((Data)obj);
        }

        private boolean typedEquals(@NonNull Data data) {
            return ObjectUtils.equals((Object)this.paymentIntent, (Object)data.paymentIntent) && ObjectUtils.equals((Object)this.exception, (Object)data.exception) && ObjectUtils.equals((Object)this.status, (Object)data.status);
        }
    }
}

