/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.utils.ObjectUtils;

final class ApiVersion {
    private static final String DEFAULT_API_VERSION = "2019-05-16";
    @NonNull
    private static final ApiVersion DEFAULT_INSTANCE = new ApiVersion("2019-05-16");
    @NonNull
    private final String mCode;

    @NonNull
    static ApiVersion create(@NonNull String code) {
        return new ApiVersion(code);
    }

    @NonNull
    static ApiVersion getDefault() {
        return DEFAULT_INSTANCE;
    }

    private ApiVersion(@NonNull String code) {
        this.mCode = code;
    }

    @NonNull
    String getCode() {
        return this.mCode;
    }

    public int hashCode() {
        return ObjectUtils.hash((Object[])new Object[]{this.mCode});
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof ApiVersion && this.typedEquals((ApiVersion)obj);
    }

    private boolean typedEquals(@NonNull ApiVersion apiVersion) {
        return ObjectUtils.equals((Object)this.mCode, (Object)apiVersion.mCode);
    }
}

