/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.stripe.android.ApiKeyValidator;
import com.stripe.android.ApiOperation;
import com.stripe.android.ApiResultCallback;
import com.stripe.android.PaymentAuthConfig;
import com.stripe.android.PaymentAuthRelayStarter;
import com.stripe.android.PaymentAuthResult;
import com.stripe.android.PaymentAuthWebViewStarter;
import com.stripe.android.Stripe;
import com.stripe.android.Stripe3ds2AuthParams;
import com.stripe.android.Stripe3ds2CompletionStarter;
import com.stripe.android.StripeApiHandler;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentIntentParams;
import com.stripe.android.model.Stripe3ds2AuthResult;
import com.stripe.android.model.Stripe3ds2Fingerprint;
import com.stripe.android.stripe3ds2.init.ConfigParameters;
import com.stripe.android.stripe3ds2.init.StripeConfigParameters;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2Service;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2ServiceImpl;
import com.stripe.android.stripe3ds2.transaction.AuthenticationRequestParameters;
import com.stripe.android.stripe3ds2.transaction.ChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.CompletionEvent;
import com.stripe.android.stripe3ds2.transaction.MessageVersionRegistry;
import com.stripe.android.stripe3ds2.transaction.ProtocolErrorEvent;
import com.stripe.android.stripe3ds2.transaction.RuntimeErrorEvent;
import com.stripe.android.stripe3ds2.transaction.StripeChallengeParameters;
import com.stripe.android.stripe3ds2.transaction.StripeChallengeStatusReceiver;
import com.stripe.android.stripe3ds2.transaction.Transaction;
import com.stripe.android.stripe3ds2.transaction.n;
import com.stripe.android.view.ActivityStarter;
import java.lang.ref.WeakReference;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

class PaymentAuthenticationController {
    static final int REQUEST_CODE = 50000;
    private static final String DIRECTORY_SERVER_ID = "F000000000";
    @NonNull
    private final StripeThreeDs2Service mThreeDs2Service;
    @NonNull
    private final StripeApiHandler mApiHandler;
    @NonNull
    private final MessageVersionRegistry mMessageVersionRegistry;
    @NonNull
    private final String mDirectoryServerId;
    @NonNull
    private final PaymentAuthConfig mConfig;
    @NonNull
    private final ApiKeyValidator mApiKeyValidator;

    PaymentAuthenticationController(@NonNull Context context, @NonNull StripeApiHandler apiHandler) {
        this(context, (StripeThreeDs2Service)new StripeThreeDs2ServiceImpl(context), apiHandler, new MessageVersionRegistry(), DIRECTORY_SERVER_ID, PaymentAuthConfig.get());
    }

    @VisibleForTesting
    PaymentAuthenticationController(@NonNull Context context, @NonNull StripeThreeDs2Service threeDs2Service, @NonNull StripeApiHandler apiHandler, @NonNull MessageVersionRegistry messageVersionRegistry, @NonNull String directoryServerId, @NonNull PaymentAuthConfig config) {
        this.mConfig = config;
        this.mThreeDs2Service = threeDs2Service;
        this.mThreeDs2Service.initialize(context, (ConfigParameters)new StripeConfigParameters(), null, config.stripe3ds2Config.uiCustomization);
        this.mApiHandler = apiHandler;
        this.mMessageVersionRegistry = messageVersionRegistry;
        this.mDirectoryServerId = directoryServerId;
        this.mApiKeyValidator = new ApiKeyValidator();
    }

    void startConfirmAndAuth(@NonNull Stripe stripe, @NonNull Activity activity, @NonNull PaymentIntentParams paymentIntentParams, @NonNull String publishableKey) {
        this.mApiKeyValidator.requireValid(publishableKey);
        new ConfirmPaymentIntentTask(stripe, paymentIntentParams, publishableKey, new ConfirmPaymentIntentCallback(activity, publishableKey, this)).execute(new Void[0]);
    }

    void startAuth(@NonNull Activity activity, @NonNull PaymentIntent paymentIntent, @NonNull String publishableKey) {
        this.handleNextAction(activity, paymentIntent, this.mApiKeyValidator.requireValid(publishableKey));
    }

    boolean shouldHandleResult(int requestCode, int resultCode, @Nullable Intent data) {
        return requestCode == 50000 && resultCode == -1 && data != null;
    }

    void handleResult(@NonNull Stripe stripe, @NonNull Intent data, @NonNull String publishableKey, final @NonNull ApiResultCallback<PaymentAuthResult> callback) {
        Exception authException = (Exception)data.getSerializableExtra("exception");
        if (authException != null) {
            callback.onError(authException);
            return;
        }
        String clientSecret = data.getStringExtra("client_secret");
        PaymentIntentParams paymentIntentParams = PaymentIntentParams.createRetrievePaymentIntentParams(clientSecret);
        new RetrievePaymentIntentTask(stripe, paymentIntentParams, publishableKey, new ApiResultCallback<PaymentIntent>(){

            @Override
            public void onSuccess(@NonNull PaymentIntent paymentIntent) {
                callback.onSuccess(new PaymentAuthResult.Builder().setPaymentIntent(paymentIntent).build());
            }

            @Override
            public void onError(@NonNull Exception e) {
                callback.onError(e);
            }
        }).execute(new Void[0]);
    }

    @VisibleForTesting
    void handleNextAction(@NonNull Activity activity, @NonNull PaymentIntent paymentIntent, @NonNull String publishableKey) {
        if (paymentIntent.requiresAction()) {
            PaymentIntent.NextActionType nextActionType = paymentIntent.getNextActionType();
            if (PaymentIntent.NextActionType.UseStripeSdk == nextActionType) {
                PaymentIntent.SdkData sdkData = Objects.requireNonNull(paymentIntent.getStripeSdkData());
                if (sdkData.is3ds2()) {
                    this.begin3ds2Auth(activity, paymentIntent, Stripe3ds2Fingerprint.create(sdkData), publishableKey);
                } else {
                    this.bypassAuth(activity, paymentIntent);
                }
            } else if (PaymentIntent.NextActionType.RedirectToUrl == nextActionType) {
                this.begin3ds1Auth(activity, Objects.requireNonNull(paymentIntent.getRedirectData()));
            } else {
                this.bypassAuth(activity, paymentIntent);
            }
        } else {
            this.bypassAuth(activity, paymentIntent);
        }
    }

    private void bypassAuth(@NonNull Activity activity, @NonNull PaymentIntent paymentIntent) {
        new PaymentAuthRelayStarter(activity, 50000).start(new PaymentAuthRelayStarter.Data(paymentIntent));
    }

    private void begin3ds2Auth(@NonNull Activity activity, @NonNull PaymentIntent paymentIntent, @NonNull Stripe3ds2Fingerprint stripe3ds2Fingerprint, @NonNull String publishableKey) {
        Transaction transaction = this.mThreeDs2Service.createTransaction(this.mDirectoryServerId, this.mMessageVersionRegistry.getCurrent(), false);
        ProgressDialog dialog = transaction.getProgressView(activity);
        dialog.show();
        AuthenticationRequestParameters areqParams = transaction.getAuthenticationRequestParameters();
        int timeout = this.mConfig.stripe3ds2Config.timeout;
        Stripe3ds2AuthParams authParams = new Stripe3ds2AuthParams(stripe3ds2Fingerprint.source, areqParams.getSDKAppID(), areqParams.getSDKReferenceNumber(), areqParams.getSDKTransactionID(), areqParams.getDeviceData(), areqParams.getSDKEphemeralPublicKey(), areqParams.getMessageVersion(), timeout);
        this.mApiHandler.start3ds2Auth(authParams, publishableKey, new Stripe3ds2AuthCallback(activity, transaction, dialog, timeout, paymentIntent));
    }

    private void begin3ds1Auth(@NonNull Activity activity, @NonNull PaymentIntent.RedirectData redirectData) {
        new PaymentAuthWebViewStarter(activity, 50000).start(redirectData);
    }

    private void handleError(@NonNull Activity activity, @NonNull Exception exception) {
        new PaymentAuthRelayStarter(activity, 50000).start(new PaymentAuthRelayStarter.Data(exception));
    }

    static final class PaymentAuth3ds2ChallengeStatusReceiver
    extends StripeChallengeStatusReceiver {
        @NonNull
        private final ActivityStarter<Stripe3ds2CompletionStarter.StartData> mStarter;
        @NonNull
        private final PaymentIntent mPaymentIntent;

        @NonNull
        static PaymentAuth3ds2ChallengeStatusReceiver create(@NonNull Activity activity, @NonNull PaymentIntent paymentIntent) {
            return new PaymentAuth3ds2ChallengeStatusReceiver(new Stripe3ds2CompletionStarter(activity, 50000), paymentIntent);
        }

        PaymentAuth3ds2ChallengeStatusReceiver(@NonNull ActivityStarter<Stripe3ds2CompletionStarter.StartData> starter, @NonNull PaymentIntent paymentIntent) {
            this.mStarter = starter;
            this.mPaymentIntent = paymentIntent;
        }

        public void completed(@NonNull CompletionEvent completionEvent) {
            super.completed(completionEvent);
            this.start(Stripe3ds2CompletionStarter.StartData.createForComplete(this.mPaymentIntent, completionEvent.getTransactionStatus()));
        }

        public void cancelled() {
            super.cancelled();
            this.start(new Stripe3ds2CompletionStarter.StartData(this.mPaymentIntent, 1));
        }

        public void timedout() {
            super.timedout();
            this.start(new Stripe3ds2CompletionStarter.StartData(this.mPaymentIntent, 2));
        }

        public void protocolError(@NonNull ProtocolErrorEvent protocolErrorEvent) {
            super.protocolError(protocolErrorEvent);
            this.start(new Stripe3ds2CompletionStarter.StartData(this.mPaymentIntent, 3));
        }

        public void runtimeError(@NonNull RuntimeErrorEvent runtimeErrorEvent) {
            super.runtimeError(runtimeErrorEvent);
            this.start(new Stripe3ds2CompletionStarter.StartData(this.mPaymentIntent, 4));
        }

        private void start(@NonNull Stripe3ds2CompletionStarter.StartData startData) {
            this.mStarter.start(startData);
        }
    }

    static final class Stripe3ds2AuthCallback
    implements ApiResultCallback<Stripe3ds2AuthResult> {
        @NonNull
        private final WeakReference<Activity> mActivityRef;
        @NonNull
        private final Transaction mTransaction;
        private final int mMaxTimeout;
        @NonNull
        private final PaymentIntent mPaymentIntent;
        @NonNull
        private final PaymentAuthRelayStarter mPaymentAuthRelayStarter;
        @NonNull
        private final Handler mBackgroundHandler;
        @NonNull
        private final WeakReference<ProgressDialog> mProgressDialog;

        private Stripe3ds2AuthCallback(@NonNull Activity activity, @NonNull Transaction transaction, @NonNull ProgressDialog progressDialog, int maxTimeout, @NonNull PaymentIntent paymentIntent) {
            this(activity, transaction, progressDialog, maxTimeout, paymentIntent, new PaymentAuthRelayStarter(activity, 50000));
        }

        @VisibleForTesting
        Stripe3ds2AuthCallback(@NonNull Activity activity, @NonNull Transaction transaction, @NonNull ProgressDialog progressDialog, int maxTimeout, @NonNull PaymentIntent paymentIntent, @NonNull PaymentAuthRelayStarter paymentAuthRelayStarter) {
            this.mActivityRef = new WeakReference<Activity>(activity);
            this.mTransaction = transaction;
            this.mProgressDialog = new WeakReference<ProgressDialog>(progressDialog);
            this.mMaxTimeout = maxTimeout;
            this.mPaymentIntent = paymentIntent;
            this.mPaymentAuthRelayStarter = paymentAuthRelayStarter;
            HandlerThread handlerThread = new HandlerThread(Stripe3ds2AuthCallback.class.getSimpleName());
            handlerThread.start();
            this.mBackgroundHandler = new Handler(handlerThread.getLooper());
        }

        @Override
        public void onSuccess(@NonNull Stripe3ds2AuthResult result) {
            Activity activity = (Activity)this.mActivityRef.get();
            if (activity == null) {
                return;
            }
            Stripe3ds2AuthResult.Ares ares = result.ares;
            if (ares != null) {
                if (ares.shouldChallenge()) {
                    this.startChallengeFlow(activity, ares);
                } else {
                    this.startFrictionlessFlow();
                }
            } else {
                Stripe3ds2AuthResult.ThreeDS2Error error = result.error;
                String errorMessage = error != null ? "Code: " + error.errorCode + ", Detail: " + error.errorDetail + ", Description: " + error.errorDescription + ", Component: " + error.errorComponent : "Invalid 3DS2 authentication response";
                this.onError(new RuntimeException("Error encountered during 3DS2 authentication request. " + errorMessage));
            }
        }

        @Override
        public void onError(@NonNull Exception e) {
            Activity activity = (Activity)this.mActivityRef.get();
            if (activity != null) {
                this.mPaymentAuthRelayStarter.start(new PaymentAuthRelayStarter.Data(e));
            }
        }

        private void startFrictionlessFlow() {
            this.mPaymentAuthRelayStarter.start(new PaymentAuthRelayStarter.Data(this.mPaymentIntent));
            ProgressDialog progressDialog = (ProgressDialog)this.mProgressDialog.get();
            if (progressDialog != null) {
                progressDialog.dismiss();
            }
        }

        private void startChallengeFlow(final @NonNull Activity activity, @NonNull Stripe3ds2AuthResult.Ares ares) {
            final StripeChallengeParameters challengeParameters = new StripeChallengeParameters();
            challengeParameters.setAcsSignedContent(ares.acsSignedContent);
            challengeParameters.set3DSServerTransactionID(ares.threeDSServerTransId);
            challengeParameters.setAcsTransactionID(ares.acsTransId);
            this.mBackgroundHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog progressDialog = (ProgressDialog)Stripe3ds2AuthCallback.this.mProgressDialog.get();
                    if (progressDialog != null) {
                        progressDialog.dismiss();
                    }
                    Stripe3ds2AuthCallback.this.mTransaction.doChallenge(activity, (ChallengeParameters)challengeParameters, (n)PaymentAuth3ds2ChallengeStatusReceiver.create(activity, Stripe3ds2AuthCallback.this.mPaymentIntent), Stripe3ds2AuthCallback.this.mMaxTimeout);
                }
            }, TimeUnit.SECONDS.toMillis(2L));
        }
    }

    private static final class ConfirmPaymentIntentCallback
    implements ApiResultCallback<PaymentIntent> {
        @NonNull
        private final WeakReference<Activity> mActivityRef;
        @NonNull
        private final String mPublishableKey;
        @NonNull
        private final PaymentAuthenticationController mPaymentAuthController;

        private ConfirmPaymentIntentCallback(@NonNull Activity activity, @NonNull String publishableKey, @NonNull PaymentAuthenticationController paymentAuthController) {
            this.mActivityRef = new WeakReference<Activity>(activity);
            this.mPublishableKey = publishableKey;
            this.mPaymentAuthController = paymentAuthController;
        }

        @Override
        public void onSuccess(@NonNull PaymentIntent paymentIntent) {
            Activity activity = (Activity)this.mActivityRef.get();
            if (activity != null) {
                this.mPaymentAuthController.handleNextAction(activity, paymentIntent, this.mPublishableKey);
            }
        }

        @Override
        public void onError(@NonNull Exception e) {
            Activity activity = (Activity)this.mActivityRef.get();
            if (activity != null) {
                this.mPaymentAuthController.handleError(activity, e);
            }
        }
    }

    private static final class ConfirmPaymentIntentTask
    extends ApiOperation<PaymentIntent> {
        @NonNull
        private final Stripe mStripe;
        @NonNull
        private final PaymentIntentParams mParams;
        @NonNull
        private final String mPublishableKey;

        private ConfirmPaymentIntentTask(@NonNull Stripe stripe, @NonNull PaymentIntentParams params, @NonNull String publishableKey, @NonNull ApiResultCallback<PaymentIntent> callback) {
            super(callback);
            this.mStripe = stripe;
            this.mParams = params;
            this.mPublishableKey = publishableKey;
        }

        @Override
        @Nullable
        PaymentIntent getResult() throws StripeException {
            return this.mStripe.confirmPaymentIntentSynchronous(this.mParams, this.mPublishableKey);
        }
    }

    private static final class RetrievePaymentIntentTask
    extends ApiOperation<PaymentIntent> {
        @NonNull
        private final Stripe mStripe;
        @NonNull
        private final PaymentIntentParams mParams;
        @NonNull
        private final String mPublishableKey;

        private RetrievePaymentIntentTask(@NonNull Stripe stripe, @NonNull PaymentIntentParams params, @NonNull String publishableKey, @NonNull ApiResultCallback<PaymentIntent> callback) {
            super(callback);
            this.mStripe = stripe;
            this.mParams = params;
            this.mPublishableKey = publishableKey;
        }

        @Override
        @Nullable
        PaymentIntent getResult() throws StripeException {
            return this.mStripe.retrievePaymentIntentSynchronous(this.mParams, this.mPublishableKey);
        }
    }
}

