/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.view.ActivityStarter;
import com.stripe.android.view.PaymentAuthRelayActivity;
import java.io.Serializable;

class PaymentAuthRelayStarter
implements ActivityStarter<Data> {
    @NonNull
    private final Activity mActivity;
    private final int mRequestCode;

    PaymentAuthRelayStarter(@NonNull Activity activity, int requestCode) {
        this.mActivity = activity;
        this.mRequestCode = requestCode;
    }

    @Override
    public void start(@NonNull Data data) {
        Intent intent = new Intent((Context)this.mActivity, PaymentAuthRelayActivity.class).putExtra("client_secret", data.paymentIntent != null ? data.paymentIntent.getClientSecret() : null).putExtra("exception", (Serializable)data.exception);
        this.mActivity.startActivityForResult(intent, this.mRequestCode);
    }

    public static final class Data {
        @Nullable
        final PaymentIntent paymentIntent;
        @Nullable
        final Exception exception;

        Data(@NonNull PaymentIntent paymentIntent) {
            this.paymentIntent = paymentIntent;
            this.exception = null;
        }

        Data(@NonNull Exception exception) {
            this.paymentIntent = null;
            this.exception = exception;
        }
    }
}

