/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.support.annotation.NonNull;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;

public class PaymentUtils {
    static String formatPriceStringUsingFree(long amount, @NonNull Currency currency, String free) {
        if (amount == 0L) {
            return free;
        }
        NumberFormat currencyFormat = NumberFormat.getCurrencyInstance();
        DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)currencyFormat).getDecimalFormatSymbols();
        decimalFormatSymbols.setCurrencySymbol(currency.getSymbol(Locale.getDefault()));
        ((DecimalFormat)currencyFormat).setDecimalFormatSymbols(decimalFormatSymbols);
        return PaymentUtils.formatPriceString(amount, currency);
    }

    static String formatPriceString(double amount, @NonNull Currency currency) {
        double majorUnitAmount = amount / Math.pow(10.0, currency.getDefaultFractionDigits());
        NumberFormat currencyFormat = NumberFormat.getCurrencyInstance();
        try {
            DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)currencyFormat).getDecimalFormatSymbols();
            decimalFormatSymbols.setCurrencySymbol(currency.getSymbol(Locale.getDefault()));
            ((DecimalFormat)currencyFormat).setDecimalFormatSymbols(decimalFormatSymbols);
            return currencyFormat.format(majorUnitAmount);
        }
        catch (ClassCastException e) {
            return currencyFormat.format(majorUnitAmount);
        }
    }
}

