/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.model;

import android.support.annotation.NonNull;
import com.stripe.android.StripeNetworkUtils;
import java.util.HashMap;
import java.util.Map;

public class AccountParams {
    static final String API_PARAM_LEGAL_ENTITY = "legal_entity";
    static final String API_TOS_SHOWN_AND_ACCEPTED = "tos_shown_and_accepted";
    private Boolean mTosShownAndAccepted;
    private Map<String, Object> mLegalEntity;

    public static AccountParams createAccountParams(boolean tosShownAndAccepted, Map<String, Object> legalEntity) {
        AccountParams accountParams = new AccountParams().setTosShownAndAccepted(tosShownAndAccepted).setLegalEntity(legalEntity);
        return accountParams;
    }

    public AccountParams setTosShownAndAccepted(boolean tosShownAndAccepted) {
        this.mTosShownAndAccepted = tosShownAndAccepted;
        return this;
    }

    public AccountParams setLegalEntity(Map<String, Object> legalEntity) {
        this.mLegalEntity = legalEntity;
        return this;
    }

    @NonNull
    public Map<String, Object> toParamMap() {
        HashMap<String, Object> networkReadyMap = new HashMap<String, Object>();
        HashMap<String, Object> tokenMap = new HashMap<String, Object>();
        tokenMap.put(API_TOS_SHOWN_AND_ACCEPTED, this.mTosShownAndAccepted);
        tokenMap.put(API_PARAM_LEGAL_ENTITY, this.mLegalEntity);
        networkReadyMap.put("account", tokenMap);
        StripeNetworkUtils.removeNullAndEmptyParams(networkReadyMap);
        return networkReadyMap;
    }
}

