/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.ContentResolver;
import android.content.Context;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import com.stripe.android.StripeTextUtils;
import com.stripe.android.model.BankAccount;
import com.stripe.android.model.Card;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class StripeNetworkUtils {
    private static final String MUID = "muid";
    private static final String GUID = "guid";

    @NonNull
    static Map<String, Object> hashMapFromCard(@NonNull Context context, Card card) {
        return StripeNetworkUtils.hashMapFromCard(null, context, card);
    }

    @NonNull
    static Map<String, Object> hashMapFromPersonalId(@NonNull Context context, @NonNull String personalId) {
        HashMap<String, String> tokenParams = new HashMap<String, String>();
        tokenParams.put("personal_id_number", personalId);
        HashMap<String, Object> piiParams = new HashMap<String, Object>();
        piiParams.put("pii", tokenParams);
        return piiParams;
    }

    @NonNull
    private static Map<String, Object> hashMapFromCard(@Nullable UidProvider provider, @NonNull Context context, Card card) {
        HashMap<String, Object> tokenParams = new HashMap<String, Object>();
        HashMap<String, Object> cardParams = new HashMap<String, Object>();
        cardParams.put("number", StripeTextUtils.nullIfBlank(card.getNumber()));
        cardParams.put("cvc", StripeTextUtils.nullIfBlank(card.getCVC()));
        cardParams.put("exp_month", card.getExpMonth());
        cardParams.put("exp_year", card.getExpYear());
        cardParams.put("name", StripeTextUtils.nullIfBlank(card.getName()));
        cardParams.put("currency", StripeTextUtils.nullIfBlank(card.getCurrency()));
        cardParams.put("address_line1", StripeTextUtils.nullIfBlank(card.getAddressLine1()));
        cardParams.put("address_line2", StripeTextUtils.nullIfBlank(card.getAddressLine2()));
        cardParams.put("address_city", StripeTextUtils.nullIfBlank(card.getAddressCity()));
        cardParams.put("address_zip", StripeTextUtils.nullIfBlank(card.getAddressZip()));
        cardParams.put("address_state", StripeTextUtils.nullIfBlank(card.getAddressState()));
        cardParams.put("address_country", StripeTextUtils.nullIfBlank(card.getAddressCountry()));
        StripeNetworkUtils.removeNullAndEmptyParams(cardParams);
        tokenParams.put("product_usage", card.getLoggingTokens());
        tokenParams.put("card", cardParams);
        StripeNetworkUtils.addUidParams(provider, context, tokenParams);
        return tokenParams;
    }

    @NonNull
    static Map<String, Object> hashMapFromBankAccount(@NonNull Context context, @NonNull BankAccount bankAccount) {
        return StripeNetworkUtils.hashMapFromBankAccount(null, context, bankAccount);
    }

    public static void removeNullAndEmptyParams(@NonNull Map<String, Object> mapToEdit) {
        for (String key : new HashSet<String>(mapToEdit.keySet())) {
            CharSequence sequence;
            if (mapToEdit.get(key) == null) {
                mapToEdit.remove(key);
            }
            if (mapToEdit.get(key) instanceof CharSequence && TextUtils.isEmpty((CharSequence)(sequence = (CharSequence)mapToEdit.get(key)))) {
                mapToEdit.remove(key);
            }
            if (!(mapToEdit.get(key) instanceof Map)) continue;
            Map stringObjectMap = (Map)mapToEdit.get(key);
            StripeNetworkUtils.removeNullAndEmptyParams(stringObjectMap);
        }
    }

    static void addUidParamsToPaymentIntent(@Nullable UidProvider provider, @NonNull Context context, @NonNull Map<String, Object> params) {
        if (params.containsKey("source_data") && params.get("source_data") instanceof Map) {
            StripeNetworkUtils.addUidParams(provider, context, (Map)params.get("source_data"));
        }
    }

    static void addUidParams(@Nullable UidProvider provider, @NonNull Context context, @NonNull Map<String, Object> params) {
        String guid;
        String string2 = guid = provider == null ? Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id") : provider.getUid();
        if (StripeTextUtils.isBlank(guid)) {
            return;
        }
        String hashGuid = StripeTextUtils.shaHashInput(guid);
        String muid = provider == null ? context.getApplicationContext().getPackageName() + guid : provider.getPackageName() + guid;
        String hashMuid = StripeTextUtils.shaHashInput(muid);
        if (!StripeTextUtils.isBlank(hashGuid)) {
            params.put(GUID, hashGuid);
        }
        if (!StripeTextUtils.isBlank(hashMuid)) {
            params.put(MUID, hashMuid);
        }
    }

    @NonNull
    private static Map<String, Object> hashMapFromBankAccount(@Nullable UidProvider provider, @NonNull Context context, @NonNull BankAccount bankAccount) {
        HashMap<String, Object> tokenParams = new HashMap<String, Object>();
        HashMap<String, Object> accountParams = new HashMap<String, Object>();
        accountParams.put("country", bankAccount.getCountryCode());
        accountParams.put("currency", bankAccount.getCurrency());
        accountParams.put("account_number", bankAccount.getAccountNumber());
        accountParams.put("routing_number", StripeTextUtils.nullIfBlank(bankAccount.getRoutingNumber()));
        accountParams.put("account_holder_name", StripeTextUtils.nullIfBlank(bankAccount.getAccountHolderName()));
        accountParams.put("account_holder_type", StripeTextUtils.nullIfBlank(bankAccount.getAccountHolderType()));
        StripeNetworkUtils.removeNullAndEmptyParams(accountParams);
        tokenParams.put("bank_account", accountParams);
        StripeNetworkUtils.addUidParams(provider, context, tokenParams);
        return tokenParams;
    }

    @VisibleForTesting
    static interface UidProvider {
        public String getUid();

        public String getPackageName();
    }
}

