/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.view;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import com.stripe.android.CustomerSession;
import com.stripe.android.PaymentSessionConfig;
import com.stripe.android.PaymentSessionData;
import com.stripe.android.R;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.ShippingMethod;
import com.stripe.android.view.PaymentFlowPagerAdapter;
import com.stripe.android.view.PaymentFlowPagerEnum;
import com.stripe.android.view.SelectShippingMethodWidget;
import com.stripe.android.view.ShippingInfoWidget;
import com.stripe.android.view.StripeActivity;
import java.util.List;

public class PaymentFlowActivity
extends StripeActivity {
    public static final String EXTRA_DEFAULT_SHIPPING_METHOD = "default_shipping_method";
    public static final String EXTRA_IS_SHIPPING_INFO_VALID = "shipping_is_shipping_info_valid";
    public static final String EXTRA_SHIPPING_INFO_DATA = "shipping_info_data";
    public static final String EXTRA_SHIPPING_INFO_ERROR = "shipping_info_error";
    public static final String EVENT_SHIPPING_INFO_PROCESSED = "shipping_info_processed";
    public static final String EVENT_SHIPPING_INFO_SUBMITTED = "shipping_info_submitted";
    public static final String EXTRA_VALID_SHIPPING_METHODS = "valid_shipping_methods";
    static final String TOKEN_PAYMENT_FLOW_ACTIVITY = "PaymentFlowActivity";
    private BroadcastReceiver mShippingInfoSavedBroadcastReceiver;
    private BroadcastReceiver mShippingInfoSubmittedBroadcastReceiver;
    private PaymentFlowPagerAdapter mPaymentFlowPagerAdapter;
    private ViewPager mViewPager;
    private PaymentSessionData mPaymentSessionData;
    private ShippingInformation mShippingInformationSubmitted;
    private List<ShippingMethod> mValidShippingMethods;
    private ShippingMethod mDefaultShippingMethod;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        CustomerSession.getInstance().addProductUsageTokenIfValid("PaymentSession");
        CustomerSession.getInstance().addProductUsageTokenIfValid(TOKEN_PAYMENT_FLOW_ACTIVITY);
        this.mViewStub.setLayoutResource(R.layout.activity_shipping_flow);
        this.mViewStub.inflate();
        this.mViewPager = (ViewPager)this.findViewById(R.id.shipping_flow_viewpager);
        PaymentSessionConfig paymentSessionConfig = (PaymentSessionConfig)this.getIntent().getParcelableExtra("payment_session_config");
        this.mPaymentSessionData = (PaymentSessionData)this.getIntent().getParcelableExtra("payment_session_data");
        if (this.mPaymentSessionData == null) {
            throw new IllegalArgumentException("PaymentFlowActivity launched without PaymentSessionData");
        }
        this.mPaymentFlowPagerAdapter = new PaymentFlowPagerAdapter((Context)this, paymentSessionConfig);
        this.mViewPager.setAdapter((PagerAdapter)this.mPaymentFlowPagerAdapter);
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int i, float v, int i1) {
            }

            public void onPageSelected(int i) {
                PaymentFlowActivity.this.setTitle(PaymentFlowActivity.this.mViewPager.getAdapter().getPageTitle(i));
                if (PaymentFlowActivity.this.mPaymentFlowPagerAdapter.getPageAt(i) == PaymentFlowPagerEnum.SHIPPING_INFO) {
                    PaymentFlowActivity.this.mPaymentFlowPagerAdapter.hideShippingPage();
                }
            }

            public void onPageScrollStateChanged(int i) {
            }
        });
        this.mShippingInfoSubmittedBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                boolean isShippingInfoValid = intent.getBooleanExtra(PaymentFlowActivity.EXTRA_IS_SHIPPING_INFO_VALID, false);
                if (isShippingInfoValid) {
                    PaymentFlowActivity.this.onShippingInfoValidated();
                    PaymentFlowActivity.this.mValidShippingMethods = intent.getParcelableArrayListExtra(PaymentFlowActivity.EXTRA_VALID_SHIPPING_METHODS);
                    PaymentFlowActivity.this.mDefaultShippingMethod = (ShippingMethod)intent.getParcelableExtra(PaymentFlowActivity.EXTRA_DEFAULT_SHIPPING_METHOD);
                } else {
                    PaymentFlowActivity.this.setCommunicatingProgress(false);
                    String shippingInfoError = intent.getStringExtra(PaymentFlowActivity.EXTRA_SHIPPING_INFO_ERROR);
                    if (shippingInfoError != null && !shippingInfoError.isEmpty()) {
                        PaymentFlowActivity.this.showError(shippingInfoError);
                    } else {
                        PaymentFlowActivity.this.showError(PaymentFlowActivity.this.getString(R.string.invalid_shipping_information));
                    }
                    PaymentFlowActivity.this.mShippingInformationSubmitted = null;
                }
            }
        };
        this.mShippingInfoSavedBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                PaymentFlowActivity.this.onShippingMethodsReady(PaymentFlowActivity.this.mValidShippingMethods, PaymentFlowActivity.this.mDefaultShippingMethod);
                PaymentFlowActivity.this.mPaymentSessionData.setShippingInformation(PaymentFlowActivity.this.mShippingInformationSubmitted);
            }
        };
        this.setTitle(this.mPaymentFlowPagerAdapter.getPageTitle(this.mViewPager.getCurrentItem()));
    }

    @Override
    protected void onActionSave() {
        if (this.mPaymentFlowPagerAdapter.getPageAt(this.mViewPager.getCurrentItem()).equals((Object)PaymentFlowPagerEnum.SHIPPING_INFO)) {
            this.onShippingInfoSubmitted();
        } else {
            this.onShippingMethodSave();
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mShippingInfoSubmittedBroadcastReceiver);
        LocalBroadcastManager.getInstance((Context)this).unregisterReceiver(this.mShippingInfoSavedBroadcastReceiver);
    }

    @Override
    protected void onResume() {
        super.onResume();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mShippingInfoSubmittedBroadcastReceiver, new IntentFilter(EVENT_SHIPPING_INFO_PROCESSED));
        LocalBroadcastManager.getInstance((Context)this).registerReceiver(this.mShippingInfoSavedBroadcastReceiver, new IntentFilter("shipping_info_saved"));
    }

    private void onShippingInfoValidated() {
        CustomerSession.getInstance().setCustomerShippingInformation((Context)this, this.mShippingInformationSubmitted);
    }

    private void onShippingMethodsReady(@NonNull List<ShippingMethod> validShippingMethods, @Nullable ShippingMethod defaultShippingMethod) {
        this.setCommunicatingProgress(false);
        this.mPaymentFlowPagerAdapter.setShippingMethods(validShippingMethods, defaultShippingMethod);
        this.mPaymentFlowPagerAdapter.setShippingInfoSaved(true);
        if (this.hasNextPage()) {
            this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() + 1);
        } else {
            this.mPaymentSessionData.setShippingInformation(this.mShippingInformationSubmitted);
            Intent intent = new Intent();
            intent.putExtra("payment_session_data", (Parcelable)this.mPaymentSessionData);
            this.setResult(-1, intent);
            this.finish();
        }
    }

    private void onShippingInfoSubmitted() {
        ShippingInfoWidget shippingInfoWidget = (ShippingInfoWidget)this.findViewById(R.id.shipping_info_widget);
        ShippingInformation shippingInformation = shippingInfoWidget.getShippingInformation();
        if (shippingInformation != null) {
            this.mShippingInformationSubmitted = shippingInformation;
            this.setCommunicatingProgress(true);
            this.broadcastShippingInfoSubmitted(shippingInformation);
        }
    }

    private void broadcastShippingInfoSubmitted(ShippingInformation shippingInformation) {
        Intent intent = new Intent(EVENT_SHIPPING_INFO_SUBMITTED);
        intent.putExtra(EXTRA_SHIPPING_INFO_DATA, (Parcelable)shippingInformation);
        LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }

    private boolean hasNextPage() {
        return this.mViewPager.getCurrentItem() + 1 < this.mPaymentFlowPagerAdapter.getCount();
    }

    private boolean hasPreviousPage() {
        int currentPageIndex = this.mViewPager.getCurrentItem();
        return currentPageIndex != 0;
    }

    private void onShippingMethodSave() {
        SelectShippingMethodWidget selectShippingMethodWidget = (SelectShippingMethodWidget)this.findViewById(R.id.select_shipping_method_widget);
        ShippingMethod shippingMethod = selectShippingMethodWidget.getSelectedShippingMethod();
        this.mPaymentSessionData.setShippingMethod(shippingMethod);
        Intent intent = new Intent();
        intent.putExtra("payment_session_data", (Parcelable)this.mPaymentSessionData);
        this.setResult(-1, intent);
        this.finish();
    }

    public void onBackPressed() {
        if (this.hasPreviousPage()) {
            this.mViewPager.setCurrentItem(this.mViewPager.getCurrentItem() - 1);
            return;
        }
        super.onBackPressed();
    }
}

