/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.LocalBroadcastManager;
import com.stripe.android.EphemeralKey;
import com.stripe.android.EphemeralKeyManager;
import com.stripe.android.EphemeralKeyProvider;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.StripeApiHandler;
import com.stripe.android.exception.APIConnectionException;
import com.stripe.android.exception.APIException;
import com.stripe.android.exception.InvalidRequestException;
import com.stripe.android.exception.StripeException;
import com.stripe.android.model.Customer;
import com.stripe.android.model.ShippingInformation;
import com.stripe.android.model.Source;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CustomerSession
implements EphemeralKeyManager.KeyManagerListener {
    public static final String ACTION_API_EXCEPTION = "action_api_exception";
    public static final String EXTRA_EXCEPTION = "exception";
    public static final String EVENT_SHIPPING_INFO_SAVED = "shipping_info_saved";
    private static final String ACTION_ADD_SOURCE = "add_source";
    private static final String ACTION_DELETE_SOURCE = "delete_source";
    private static final String ACTION_SET_DEFAULT_SOURCE = "default_source";
    private static final String ACTION_SET_CUSTOMER_SHIPPING_INFO = "set_shipping_info";
    private static final String KEY_SOURCE = "source";
    private static final String KEY_SOURCE_TYPE = "source_type";
    private static final String KEY_SHIPPING_INFO = "shipping_info";
    private static final String TOKEN_PAYMENT_SESSION = "PaymentSession";
    private static final Set<String> VALID_TOKENS = new HashSet<String>(Arrays.asList("AddSourceActivity", "PaymentMethodsActivity", "PaymentFlowActivity", "PaymentSession", "ShippingInfoScreen", "ShippingMethodScreen"));
    @Nullable
    private Customer mCustomer;
    private long mCustomerCacheTime;
    @Nullable
    private WeakReference<Context> mCachedContextReference;
    @Nullable
    private CustomerRetrievalListener mCustomerRetrievalListener;
    @Nullable
    private SourceRetrievalListener mSourceRetrievalListener;
    @Nullable
    private EphemeralKey mEphemeralKey;
    @NonNull
    private EphemeralKeyManager mEphemeralKeyManager;
    @NonNull
    private Handler mUiThreadHandler;
    @NonNull
    private Set<String> mProductUsageTokens;
    @Nullable
    private Calendar mProxyNowCalendar;
    @Nullable
    private StripeApiProxy mStripeApiProxy;
    private final BlockingQueue<Runnable> mNetworkQueue = new LinkedBlockingQueue<Runnable>();
    @NonNull
    private ThreadPoolExecutor mThreadPoolExecutor = this.createThreadPoolExecutor();
    private static final int CUSTOMER_RETRIEVED = 7;
    private static final int CUSTOMER_ERROR = 11;
    private static final int SOURCE_RETRIEVED = 13;
    private static final int SOURCE_ERROR = 17;
    private static final int CUSTOMER_SHIPPING_INFO_SAVED = 19;
    private static final int THREAD_POOL_SIZE = 3;
    private static final int KEEP_ALIVE_TIME = 2;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private static final long KEY_REFRESH_BUFFER_IN_SECONDS = 30L;
    private static final long CUSTOMER_CACHE_DURATION_MILLISECONDS = TimeUnit.MINUTES.toMillis(1L);
    private static CustomerSession mInstance;

    public static void initCustomerSession(@NonNull EphemeralKeyProvider keyProvider) {
        CustomerSession.initCustomerSession(keyProvider, null, null);
    }

    public static CustomerSession getInstance() {
        if (mInstance == null) {
            throw new IllegalStateException("Attempted to get instance of CustomerSession without initialization.");
        }
        return mInstance;
    }

    public static void endCustomerSession() {
        CustomerSession.clearInstance();
    }

    @VisibleForTesting
    static void initCustomerSession(@NonNull EphemeralKeyProvider keyProvider, @Nullable StripeApiProxy stripeApiProxy, @Nullable Calendar proxyNowCalendar) {
        mInstance = new CustomerSession(keyProvider, stripeApiProxy, proxyNowCalendar);
    }

    @VisibleForTesting
    static void clearInstance() {
        if (mInstance == null) {
            return;
        }
        CustomerSession.mInstance.mThreadPoolExecutor.shutdownNow();
        mInstance = null;
    }

    private CustomerSession(@NonNull EphemeralKeyProvider keyProvider, @Nullable StripeApiProxy stripeApiProxy, @Nullable Calendar proxyNowCalendar) {
        this.mUiThreadHandler = this.createMainThreadHandler();
        this.mStripeApiProxy = stripeApiProxy;
        this.mProxyNowCalendar = proxyNowCalendar;
        this.mProductUsageTokens = new HashSet<String>();
        this.mEphemeralKeyManager = new EphemeralKeyManager(keyProvider, this, 30L, proxyNowCalendar);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void addProductUsageTokenIfValid(String token) {
        if (token != null && VALID_TOKENS.contains(token)) {
            this.mProductUsageTokens.add(token);
        }
    }

    public void retrieveCurrentCustomer(@NonNull CustomerRetrievalListener listener) {
        if (this.canUseCachedCustomer()) {
            listener.onCustomerRetrieved(this.getCachedCustomer());
        } else {
            this.mCustomer = null;
            this.mCustomerRetrievalListener = listener;
            this.mEphemeralKeyManager.retrieveEphemeralKey(null, null);
        }
    }

    public void updateCurrentCustomer(@NonNull CustomerRetrievalListener listener) {
        this.mCustomer = null;
        this.mCustomerRetrievalListener = listener;
        this.mEphemeralKeyManager.retrieveEphemeralKey(null, null);
    }

    @Nullable
    public Customer getCachedCustomer() {
        if (this.canUseCachedCustomer()) {
            return this.mCustomer;
        }
        return null;
    }

    public void addCustomerSource(@NonNull Context context, @NonNull String sourceId, @NonNull String sourceType, @Nullable SourceRetrievalListener listener) {
        this.mCachedContextReference = new WeakReference<Context>(context);
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_SOURCE, sourceId);
        arguments.put(KEY_SOURCE_TYPE, sourceType);
        this.mSourceRetrievalListener = listener;
        this.mEphemeralKeyManager.retrieveEphemeralKey(ACTION_ADD_SOURCE, arguments);
    }

    public void deleteCustomerSource(@NonNull Context context, @NonNull String sourceId, @Nullable SourceRetrievalListener listener) {
        this.mCachedContextReference = new WeakReference<Context>(context);
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_SOURCE, sourceId);
        this.mSourceRetrievalListener = listener;
        this.mEphemeralKeyManager.retrieveEphemeralKey(ACTION_DELETE_SOURCE, arguments);
    }

    public void setCustomerShippingInformation(@NonNull Context context, @NonNull ShippingInformation shippingInformation) {
        this.mCachedContextReference = new WeakReference<Context>(context);
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_SHIPPING_INFO, shippingInformation);
        this.mEphemeralKeyManager.retrieveEphemeralKey(ACTION_SET_CUSTOMER_SHIPPING_INFO, arguments);
    }

    public void setCustomerDefaultSource(@NonNull Context context, @NonNull String sourceId, @NonNull String sourceType, @Nullable CustomerRetrievalListener listener) {
        this.mCachedContextReference = new WeakReference<Context>(context);
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put(KEY_SOURCE, sourceId);
        arguments.put(KEY_SOURCE_TYPE, sourceType);
        this.mCustomerRetrievalListener = listener;
        this.mEphemeralKeyManager.retrieveEphemeralKey(ACTION_SET_DEFAULT_SOURCE, arguments);
    }

    void resetUsageTokens() {
        this.mProductUsageTokens.clear();
    }

    @Nullable
    @VisibleForTesting
    Customer getCustomer() {
        return this.mCustomer;
    }

    @VisibleForTesting
    long getCustomerCacheTime() {
        return this.mCustomerCacheTime;
    }

    @Nullable
    @VisibleForTesting
    EphemeralKey getEphemeralKey() {
        return this.mEphemeralKey;
    }

    @VisibleForTesting
    Set<String> getProductUsageTokens() {
        return this.mProductUsageTokens;
    }

    @VisibleForTesting
    void setStripeApiProxy(@Nullable StripeApiProxy proxy) {
        this.mStripeApiProxy = proxy;
    }

    private void addCustomerSource(final @NonNull WeakReference<Context> contextWeakReference, final @NonNull EphemeralKey key, final @NonNull String sourceId, final @NonNull String sourceType, final @NonNull List<String> productUsageTokens) {
        Runnable fetchCustomerRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Source source = CustomerSession.addCustomerSourceWithKey(contextWeakReference, key, new ArrayList<String>(productUsageTokens), sourceId, sourceType, CustomerSession.this.mStripeApiProxy);
                    Message message = CustomerSession.this.mUiThreadHandler.obtainMessage(13, (Object)source);
                    CustomerSession.this.mUiThreadHandler.sendMessage(message);
                }
                catch (StripeException stripeEx) {
                    Message message = CustomerSession.this.mUiThreadHandler.obtainMessage(17, (Object)stripeEx);
                    CustomerSession.this.mUiThreadHandler.sendMessage(message);
                    CustomerSession.sendErrorIntent(contextWeakReference, stripeEx);
                }
            }
        };
        this.executeRunnable(fetchCustomerRunnable);
    }

    private boolean canUseCachedCustomer() {
        long currentTime = this.getCalendarInstance().getTimeInMillis();
        return this.mCustomer != null && currentTime - this.mCustomerCacheTime < CUSTOMER_CACHE_DURATION_MILLISECONDS;
    }

    private void deleteCustomerSource(final @NonNull WeakReference<Context> contextWeakReference, final @NonNull EphemeralKey key, final @NonNull String sourceId, final @NonNull List<String> productUsageTokens) {
        Runnable fetchCustomerRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Source source = CustomerSession.deleteCustomerSourceWithKey(contextWeakReference, key, new ArrayList<String>(productUsageTokens), sourceId, CustomerSession.this.mStripeApiProxy);
                    Message message = CustomerSession.this.mUiThreadHandler.obtainMessage(13, (Object)source);
                    CustomerSession.this.mUiThreadHandler.sendMessage(message);
                }
                catch (StripeException stripeEx) {
                    Message message = CustomerSession.this.mUiThreadHandler.obtainMessage(17, (Object)stripeEx);
                    CustomerSession.this.mUiThreadHandler.sendMessage(message);
                    CustomerSession.sendErrorIntent(contextWeakReference, stripeEx);
                }
            }
        };
        this.executeRunnable(fetchCustomerRunnable);
    }

    private void setCustomerSourceDefault(final @NonNull WeakReference<Context> contextWeakReference, final @NonNull EphemeralKey key, final @NonNull String sourceId, final @NonNull String sourceType, final @NonNull List<String> productUsageTokens) {
        Runnable fetchCustomerRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Customer customer = CustomerSession.setCustomerSourceDefaultWithKey(contextWeakReference, key, new ArrayList<String>(productUsageTokens), sourceId, sourceType, CustomerSession.this.mStripeApiProxy);
                    Message message = CustomerSession.this.mUiThreadHandler.obtainMessage(7, (Object)customer);
                    CustomerSession.this.mUiThreadHandler.sendMessage(message);
                }
                catch (StripeException stripeEx) {
                    Message message = CustomerSession.this.mUiThreadHandler.obtainMessage(11, (Object)stripeEx);
                    CustomerSession.this.mUiThreadHandler.sendMessage(message);
                    CustomerSession.sendErrorIntent(contextWeakReference, stripeEx);
                }
            }
        };
        this.executeRunnable(fetchCustomerRunnable);
    }

    private void setCustomerShippingInformation(final @NonNull WeakReference<Context> contextWeakReference, final @NonNull EphemeralKey key, final @NonNull ShippingInformation shippingInformation, final @NonNull List<String> productUsageTokens) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Customer customer = CustomerSession.setCustomerShippingInfoWithKey(contextWeakReference, key, new ArrayList<String>(productUsageTokens), shippingInformation, CustomerSession.this.mStripeApiProxy);
                    Message message = CustomerSession.this.mUiThreadHandler.obtainMessage(19, (Object)customer);
                    CustomerSession.this.mUiThreadHandler.sendMessage(message);
                }
                catch (StripeException stripeEx) {
                    Message message = CustomerSession.this.mUiThreadHandler.obtainMessage(11, (Object)stripeEx);
                    CustomerSession.this.mUiThreadHandler.sendMessage(message);
                    CustomerSession.sendErrorIntent(contextWeakReference, stripeEx);
                }
            }
        };
        this.executeRunnable(runnable);
    }

    private void updateCustomer(final @NonNull EphemeralKey key) {
        Runnable fetchCustomerRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Customer customer = CustomerSession.retrieveCustomerWithKey(CustomerSession.this.mCachedContextReference, key, CustomerSession.this.mStripeApiProxy);
                    Message message = CustomerSession.this.mUiThreadHandler.obtainMessage(7, (Object)customer);
                    CustomerSession.this.mUiThreadHandler.sendMessage(message);
                }
                catch (StripeException stripeEx) {
                    Message message = CustomerSession.this.mUiThreadHandler.obtainMessage(11, (Object)stripeEx);
                    CustomerSession.this.mUiThreadHandler.sendMessage(message);
                }
            }
        };
        this.executeRunnable(fetchCustomerRunnable);
    }

    private void executeRunnable(@NonNull Runnable runnable) {
        if (this.mStripeApiProxy != null) {
            runnable.run();
            return;
        }
        this.mThreadPoolExecutor.execute(runnable);
    }

    @Override
    public void onKeyUpdate(@Nullable EphemeralKey ephemeralKey, @Nullable String actionString, @Nullable Map<String, Object> arguments) {
        this.mEphemeralKey = ephemeralKey;
        if (this.mEphemeralKey != null) {
            if (actionString == null) {
                this.updateCustomer(this.mEphemeralKey);
            } else if (ACTION_ADD_SOURCE.equals(actionString) && this.mCachedContextReference != null && arguments != null && arguments.containsKey(KEY_SOURCE) && arguments.containsKey(KEY_SOURCE_TYPE)) {
                this.addCustomerSource(this.mCachedContextReference, this.mEphemeralKey, (String)arguments.get(KEY_SOURCE), (String)arguments.get(KEY_SOURCE_TYPE), new ArrayList<String>(this.mProductUsageTokens));
                this.resetUsageTokens();
            } else if (ACTION_DELETE_SOURCE.equals(actionString) && this.mCachedContextReference != null && arguments != null && arguments.containsKey(KEY_SOURCE)) {
                this.deleteCustomerSource(this.mCachedContextReference, this.mEphemeralKey, (String)arguments.get(KEY_SOURCE), new ArrayList<String>(this.mProductUsageTokens));
                this.resetUsageTokens();
            } else if (ACTION_SET_DEFAULT_SOURCE.equals(actionString) && this.mCachedContextReference != null && arguments != null && arguments.containsKey(KEY_SOURCE) && arguments.containsKey(KEY_SOURCE_TYPE)) {
                this.setCustomerSourceDefault(this.mCachedContextReference, this.mEphemeralKey, (String)arguments.get(KEY_SOURCE), (String)arguments.get(KEY_SOURCE_TYPE), new ArrayList<String>(this.mProductUsageTokens));
                this.resetUsageTokens();
            } else if (ACTION_SET_CUSTOMER_SHIPPING_INFO.equals(actionString) && this.mCachedContextReference != null && arguments != null && arguments.containsKey(KEY_SHIPPING_INFO)) {
                this.setCustomerShippingInformation(this.mCachedContextReference, this.mEphemeralKey, (ShippingInformation)arguments.get(KEY_SHIPPING_INFO), new ArrayList<String>(this.mProductUsageTokens));
                this.resetUsageTokens();
            }
        }
    }

    @Override
    public void onKeyError(int errorCode, @Nullable String errorMessage) {
        if (this.mCustomerRetrievalListener != null) {
            this.mCustomerRetrievalListener.onError(errorCode, errorMessage);
            this.mCustomerRetrievalListener = null;
        }
        if (this.mSourceRetrievalListener != null) {
            this.mSourceRetrievalListener.onError(errorCode, errorMessage);
            this.mSourceRetrievalListener = null;
        }
    }

    private Handler createMainThreadHandler() {
        return new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                Object messageObject = msg.obj;
                switch (msg.what) {
                    case 7: {
                        if (!(messageObject instanceof Customer)) break;
                        CustomerSession.this.mCustomer = (Customer)messageObject;
                        CustomerSession.this.mCustomerCacheTime = CustomerSession.this.getCalendarInstance().getTimeInMillis();
                        if (CustomerSession.this.mCustomerRetrievalListener == null) break;
                        CustomerSession.this.mCustomerRetrievalListener.onCustomerRetrieved(CustomerSession.this.mCustomer);
                        CustomerSession.this.mCustomerRetrievalListener = null;
                        break;
                    }
                    case 13: {
                        if (messageObject instanceof Source && CustomerSession.this.mSourceRetrievalListener != null) {
                            CustomerSession.this.mSourceRetrievalListener.onSourceRetrieved((Source)messageObject);
                        }
                        CustomerSession.this.mSourceRetrievalListener = null;
                        CustomerSession.this.mCachedContextReference = null;
                        break;
                    }
                    case 19: {
                        if (!(messageObject instanceof Customer)) break;
                        CustomerSession.this.mCustomer = (Customer)messageObject;
                        Intent intent = new Intent(CustomerSession.EVENT_SHIPPING_INFO_SAVED);
                        LocalBroadcastManager.getInstance((Context)((Context)CustomerSession.this.mCachedContextReference.get())).sendBroadcast(intent);
                        break;
                    }
                    case 11: {
                        if (!(messageObject instanceof StripeException)) break;
                        StripeException exception = (StripeException)messageObject;
                        if (CustomerSession.this.mCustomerRetrievalListener != null) {
                            int errorCode = exception.getStatusCode() == null ? 400 : exception.getStatusCode();
                            CustomerSession.this.mCustomerRetrievalListener.onError(errorCode, exception.getLocalizedMessage());
                            CustomerSession.this.mCustomerRetrievalListener = null;
                        }
                        CustomerSession.this.resetUsageTokens();
                        break;
                    }
                    case 17: {
                        StripeException exception = (StripeException)messageObject;
                        if (CustomerSession.this.mSourceRetrievalListener == null) break;
                        int errorCode = exception.getStatusCode() == null ? 400 : exception.getStatusCode();
                        CustomerSession.this.mSourceRetrievalListener.onError(errorCode, exception.getLocalizedMessage());
                        CustomerSession.this.mSourceRetrievalListener = null;
                        CustomerSession.this.resetUsageTokens();
                    }
                }
            }
        };
    }

    private ThreadPoolExecutor createThreadPoolExecutor() {
        return new ThreadPoolExecutor(3, 3, 2L, KEEP_ALIVE_TIME_UNIT, this.mNetworkQueue);
    }

    @NonNull
    private Calendar getCalendarInstance() {
        return this.mProxyNowCalendar == null ? Calendar.getInstance() : this.mProxyNowCalendar;
    }

    static Source addCustomerSourceWithKey(@NonNull WeakReference<Context> contextWeakReference, @NonNull EphemeralKey key, @NonNull List<String> productUsageTokens, @NonNull String sourceId, @NonNull String sourceType, @Nullable StripeApiProxy proxy) throws StripeException {
        if (proxy != null) {
            return proxy.addCustomerSourceWithKey((Context)contextWeakReference.get(), key.getCustomerId(), PaymentConfiguration.getInstance().getPublishableKey(), productUsageTokens, sourceId, sourceType, key.getSecret());
        }
        return StripeApiHandler.addCustomerSource((Context)contextWeakReference.get(), key.getCustomerId(), PaymentConfiguration.getInstance().getPublishableKey(), productUsageTokens, sourceId, sourceType, key.getSecret(), null);
    }

    static Source deleteCustomerSourceWithKey(@NonNull WeakReference<Context> contextWeakReference, @NonNull EphemeralKey key, @NonNull List<String> productUsageTokens, @NonNull String sourceId, @Nullable StripeApiProxy proxy) throws StripeException {
        if (proxy != null) {
            return proxy.deleteCustomerSourceWithKey((Context)contextWeakReference.get(), key.getCustomerId(), PaymentConfiguration.getInstance().getPublishableKey(), productUsageTokens, sourceId, key.getSecret());
        }
        return StripeApiHandler.deleteCustomerSource((Context)contextWeakReference.get(), key.getCustomerId(), PaymentConfiguration.getInstance().getPublishableKey(), productUsageTokens, sourceId, key.getSecret(), null);
    }

    static Customer setCustomerShippingInfoWithKey(@NonNull WeakReference<Context> contextWeakReference, @NonNull EphemeralKey key, @NonNull List<String> productUsageTokens, @NonNull ShippingInformation shippingInformation, @Nullable StripeApiProxy proxy) throws StripeException {
        if (proxy != null) {
            return proxy.setCustomerShippingInfoWithKey((Context)contextWeakReference.get(), key.getCustomerId(), PaymentConfiguration.getInstance().getPublishableKey(), productUsageTokens, shippingInformation, key.getSecret());
        }
        return StripeApiHandler.setCustomerShippingInfo((Context)contextWeakReference.get(), key.getCustomerId(), PaymentConfiguration.getInstance().getPublishableKey(), productUsageTokens, shippingInformation, key.getSecret(), null);
    }

    static Customer setCustomerSourceDefaultWithKey(@NonNull WeakReference<Context> contextWeakReference, @NonNull EphemeralKey key, @NonNull List<String> productUsageTokens, @NonNull String sourceId, @NonNull String sourceType, @Nullable StripeApiProxy proxy) throws StripeException {
        if (proxy != null) {
            return proxy.setDefaultCustomerSourceWithKey((Context)contextWeakReference.get(), key.getCustomerId(), PaymentConfiguration.getInstance().getPublishableKey(), productUsageTokens, sourceId, sourceType, key.getSecret());
        }
        return StripeApiHandler.setDefaultCustomerSource((Context)contextWeakReference.get(), key.getCustomerId(), PaymentConfiguration.getInstance().getPublishableKey(), productUsageTokens, sourceId, sourceType, key.getSecret(), null);
    }

    @Nullable
    static Customer retrieveCustomerWithKey(@Nullable WeakReference<Context> errorContext, @NonNull EphemeralKey key, @Nullable StripeApiProxy proxy) throws StripeException {
        if (proxy != null) {
            return proxy.retrieveCustomerWithKey(key.getCustomerId(), key.getSecret());
        }
        return StripeApiHandler.retrieveCustomer(key.getCustomerId(), key.getSecret());
    }

    @NonNull
    static void sendErrorIntent(@Nullable WeakReference<Context> errorContext, @NonNull StripeException exception) {
        if (errorContext == null || errorContext.get() == null) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putSerializable(EXTRA_EXCEPTION, (Serializable)exception);
        Intent intent = new Intent(ACTION_API_EXCEPTION);
        intent.putExtras(bundle);
        LocalBroadcastManager.getInstance((Context)((Context)errorContext.get())).sendBroadcast(intent);
    }

    static interface StripeApiProxy {
        public Customer retrieveCustomerWithKey(@NonNull String var1, @NonNull String var2) throws InvalidRequestException, APIConnectionException, APIException;

        public Source addCustomerSourceWithKey(@Nullable Context var1, @NonNull String var2, @NonNull String var3, @NonNull List<String> var4, @NonNull String var5, @NonNull String var6, @NonNull String var7) throws InvalidRequestException, APIConnectionException, APIException;

        public Source deleteCustomerSourceWithKey(@Nullable Context var1, @NonNull String var2, @NonNull String var3, @NonNull List<String> var4, @NonNull String var5, @NonNull String var6) throws InvalidRequestException, APIConnectionException, APIException;

        public Customer setDefaultCustomerSourceWithKey(@Nullable Context var1, @NonNull String var2, @NonNull String var3, @NonNull List<String> var4, @NonNull String var5, @NonNull String var6, @NonNull String var7) throws InvalidRequestException, APIConnectionException, APIException;

        public Customer setCustomerShippingInfoWithKey(@Nullable Context var1, @NonNull String var2, @NonNull String var3, @NonNull List<String> var4, @NonNull ShippingInformation var5, @NonNull String var6) throws InvalidRequestException, APIConnectionException, APIException;
    }

    public static interface SourceRetrievalListener {
        public void onSourceRetrieved(@NonNull Source var1);

        public void onError(int var1, @Nullable String var2);
    }

    public static interface CustomerRetrievalListener {
        public void onCustomerRetrieved(@NonNull Customer var1);

        public void onError(int var1, @Nullable String var2);
    }
}

